/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskAttachmentStorage;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.oomph.gitbash.GitBash;
import org.eclipse.oomph.gitbash.Messages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class GitApplyAction
extends BaseSelectionListenerAction
implements IObjectActionDelegate,
IMenuCreator {
    private IWorkbenchPart targetPart;
    private ISelection currentSelection;
    private Menu dropDownMenu;

    public GitApplyAction() {
        super(Messages.GitApplyAction_ApplyPatch_label);
    }

    protected GitApplyAction(String text) {
        super(text);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        action.setMenuCreator((IMenuCreator)this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setMenuCreator((IMenuCreator)this);
        this.currentSelection = selection;
    }

    private ITaskAttachment getSelectedAttachment() {
        Object object;
        if (this.currentSelection instanceof StructuredSelection && (object = ((StructuredSelection)this.currentSelection).getFirstElement()) instanceof ITaskAttachment) {
            return (ITaskAttachment)object;
        }
        return null;
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.dispose();
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        this.dispose();
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    private void addActionsToMenu() {
        ITaskAttachment attachment = this.getSelectedAttachment();
        if (attachment == null) {
            return;
        }
        Repository[] repositories = this.getRepositories();
        List<Repository> sorted = Arrays.asList(repositories);
        Collections.sort(sorted, new Comparator<Repository>(){

            @Override
            public int compare(Repository r1, Repository r2) {
                String n1 = r1.getWorkTree().getName();
                String n2 = r2.getWorkTree().getName();
                return n1.compareTo(n2);
            }
        });
        for (Repository repository : sorted) {
            RepositorySelectionAction action = new RepositorySelectionAction(attachment, repository);
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(this.dropDownMenu, -1);
        }
    }

    private Repository[] getRepositories() {
        return org.eclipse.egit.core.Activator.getDefault().getRepositoryCache().getAllRepositories();
    }

    private class RepositorySelectionAction
    extends Action {
        private final ITaskAttachment attachment;
        private final Repository repository;

        public RepositorySelectionAction(ITaskAttachment attachment, Repository repository) {
            this.attachment = attachment;
            this.repository = repository;
            this.setText(repository.getWorkTree().getName());
            this.setImageDescriptor(Activator.getImageDescriptor("icons/repository.gif"));
        }

        public void run() {
            try {
                IStorage storage = TaskAttachmentStorage.create((ITaskAttachment)this.attachment);
                File file = this.savePatch(storage);
                this.applyPatch(file);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }

        private File savePatch(IStorage storage) throws CoreException {
            InputStream in = null;
            BufferedWriter writer = null;
            try {
                String line;
                File tempFile = File.createTempFile("~attachment-", ".patch");
                writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tempFile)));
                in = storage.getContents();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.write("\n");
                }
                File file = tempFile;
                return file;
            }
            catch (CoreException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.oomph.gitbash", Messages.GitApplyAction_Save_exception, (Throwable)ex));
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        protected void applyPatch(File file) {
            if (this.repository != null) {
                Shell shell = GitApplyAction.this.targetPart.getSite().getShell();
                File workTree = this.repository.getWorkTree();
                String command = "git apply " + file.getAbsolutePath().replace('\\', '/');
                GitBash.executeCommand(shell, workTree, command);
            }
        }
    }
}

