/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.misc.UIStats;

public class PageListenerList
extends EventManager {
    public void addPageListener(IPageListener l) {
        this.addListenerObject(l);
    }

    private void fireEvent(SafeRunnable runnable, IPageListener listener, IWorkbenchPage page, String description) {
        String label = null;
        if (UIStats.isDebugging(11)) {
            label = String.valueOf(description) + page.getLabel();
            UIStats.start(11, label);
        }
        SafeRunner.run((ISafeRunnable)runnable);
        if (UIStats.isDebugging(11)) {
            UIStats.end(11, listener, label);
        }
    }

    public void firePageActivated(final IWorkbenchPage page) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageListener pageListener = (IPageListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    pageListener.pageActivated(page);
                }
            }, pageListener, page, "activated::");
            ++n2;
        }
    }

    public void firePageClosed(final IWorkbenchPage page) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageListener pageListener = (IPageListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    pageListener.pageClosed(page);
                }
            }, pageListener, page, "closed::");
            ++n2;
        }
    }

    public void firePageOpened(final IWorkbenchPage page) {
        Object[] objectArray = this.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final IPageListener pageListener = (IPageListener)listener;
            this.fireEvent(new SafeRunnable(){

                public void run() {
                    pageListener.pageOpened(page);
                }
            }, pageListener, page, "opened::");
            ++n2;
        }
    }

    public void removePageListener(IPageListener l) {
        this.removeListenerObject(l);
    }
}

