/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.p2.core.CertificateConfirmer;
import org.eclipse.oomph.p2.internal.ui.P2ServiceUI;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.ExtensionPage;
import org.eclipse.oomph.setup.internal.installer.InstallerDialog;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.NetworkConnectionsDialog;
import org.eclipse.oomph.setup.internal.installer.ProductPage;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleProductPage;
import org.eclipse.oomph.setup.internal.installer.URISchemeUtil;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.ExtensionsDialog;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class Installer
extends SetupWizard {
    private final SetupWizard.SelectionMemento selectionMemento;
    public final UIServices uiServices;
    private final Set<URI> delayedResourceURIs = new LinkedHashSet<URI>();
    private final Map<ProjectPage.ConfigurationListener, ToolItem> extensionButtons = new HashMap<ProjectPage.ConfigurationListener, ToolItem>();
    private final Listener openListener;
    private boolean indexLoaded;

    public Installer(SetupWizard.SelectionMemento theSelectionMemento) {
        this.selectionMemento = theSelectionMemento;
        this.setTrigger(Trigger.BOOTSTRAP);
        this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
        this.setSetupContext(SetupContext.createUserOnly((ResourceSet)this.getResourceSet()));
        this.setWindowTitle(PropertiesUtil.getProductName());
        this.uiServices = new P2ServiceUI(){

            protected Confirmer getUnsignedContentConfirmer() {
                return UnsignedContentDialog.createUnsignedContentConfirmer((User)Installer.this.getUser(), (boolean)false);
            }

            protected CertificateConfirmer getCertificateConfirmer() {
                return SetupCoreUtil.createCertificateConfirmer((User)Installer.this.getUser(), (boolean)false);
            }

            protected UIServices getDelegate() {
                return null;
            }
        };
        this.openListener = new Listener(){

            public void handleEvent(Event event) {
                Installer.this.handleArgument(event.text);
            }
        };
        Display display = Display.getDefault();
        display.addListener(46, this.openListener);
        display.addListener(54, this.openListener);
    }

    public void handleArgument(String argument) {
        this.handleURI(URISchemeUtil.getResourceURI(argument));
    }

    public void handleURI(URI uri) {
        this.delayedResourceURIs.add(uri);
    }

    protected boolean canHandleDelayedResourceURIs() {
        if (!this.indexLoaded) {
            return false;
        }
        if (this.isSimple()) {
            SimpleInstallerDialog simpleInstallerDialog = (SimpleInstallerDialog)this.getShell();
            return simpleInstallerDialog.getTopPage() instanceof SimpleProductPage;
        }
        IWizardPage currentPage = this.getCurrentPage();
        return currentPage instanceof ProductPage || currentPage instanceof ProjectPage;
    }

    public UIServices getUiServices() {
        return this.uiServices;
    }

    public SetupWizard.SelectionMemento getSelectionMemento() {
        return this.selectionMemento;
    }

    public String getHelpPath() {
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocInstallWizard.html";
    }

    public void addPages() {
        this.addPage((IWizardPage)new ProductPage(this.selectionMemento));
        this.addPage((IWizardPage)new ProjectPage(this.selectionMemento));
        this.addPage((IWizardPage)new ExtensionPage());
        super.addPages();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Installer.this.loadIndex();
            }
        });
    }

    protected void indexLoaded(Index index) {
        super.indexLoaded(index);
        this.getCatalogManager().indexLoaded(index);
        IWizardPage currentPage = this.getCurrentPage();
        if (currentPage instanceof ProjectPage) {
            ((ProjectPage)currentPage).gotoPreviousPage();
        }
        this.indexLoaded = true;
    }

    public void addAppliedConfigurationResource(Resource configurationResource) {
        super.addAppliedConfigurationResource(configurationResource);
        if (this.isSimple()) {
            SimpleInstallerDialog simpleInstallerDialog = (SimpleInstallerDialog)this.getShell();
            simpleInstallerDialog.setExtensionsAvailable(true);
        } else {
            for (Map.Entry<ProjectPage.ConfigurationListener, ToolItem> entry : this.extensionButtons.entrySet()) {
                ToolItem toolItem = entry.getValue();
                if (toolItem == null) {
                    entry.setValue(this.createExtensionsButton(entry.getKey()));
                }
                entry.getKey().checkConfigurationAvailability();
            }
        }
    }

    public void removeAppliedConfigurationResource(Resource configurationResource) {
        super.removeAppliedConfigurationResource(configurationResource);
        if (this.getAppliedConfigurationResources().isEmpty()) {
            if (this.isSimple()) {
                SimpleInstallerDialog simpleInstallerDialog = (SimpleInstallerDialog)this.getShell();
                simpleInstallerDialog.setExtensionsAvailable(false);
            } else {
                for (Map.Entry<ProjectPage.ConfigurationListener, ToolItem> entry : this.extensionButtons.entrySet()) {
                    ToolItem toolItem = entry.getValue();
                    toolItem.dispose();
                    entry.setValue(null);
                    entry.getKey().checkConfigurationAvailability();
                }
            }
        }
    }

    public void addConfigurationListener(ProjectPage.ConfigurationListener configurationListener) {
        this.extensionButtons.put(configurationListener, null);
    }

    private ToolItem createExtensionsButton(ProjectPage.ConfigurationListener configurationListener) {
        ToolBar toolBar = configurationListener.getToolBar();
        int index = toolBar.getItemCount() > 0 && toolBar.getItem(0).getData("ConfigurationSelectionAdapter") != null ? 1 : 0;
        ToolItem extensionsButton = new ToolItem(toolBar, 0, index);
        extensionsButton.setToolTipText(SimpleInstallerDialog.EXTENSIONS_MENU_ITEM_DESCRIPTION);
        extensionsButton.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/extension_notification_overlay.png"));
        AccessUtil.setKey((Widget)extensionsButton, (Object)"manageExtensions");
        extensionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Collection appliedConfigurationResources = Installer.this.getAppliedConfigurationResources();
                ExtensionsDialog extensionsDialog = new ExtensionsDialog(Installer.this.getShell(), appliedConfigurationResources);
                if (extensionsDialog.open() == 0) {
                    Installation installation = Installer.this.getSetupContext().getInstallation();
                    boolean reset = false;
                    Collection result = extensionsDialog.getResult();
                    block0: for (Resource resource : appliedConfigurationResources) {
                        if (result.contains(resource)) continue;
                        Installer.this.removeAppliedConfigurationResource(resource);
                        if (installation == null) continue;
                        URI uri = resource.getURI();
                        if (MarketPlaceListing.isMarketPlaceListing((URI)uri)) {
                            for (SetupTask setupTask : installation.getSetupTasks()) {
                                Macro macro;
                                if (!(setupTask instanceof MacroTask) || (macro = ((MacroTask)setupTask).getMacro()) != null && macro.eResource() != null && !macro.eResource().getURI().equals(uri)) continue;
                                EcoreUtil.delete((EObject)macro);
                                continue block0;
                            }
                            continue;
                        }
                        reset = true;
                    }
                    IWizardContainer container = Installer.this.getContainer();
                    if (reset && container instanceof InstallerDialog) {
                        InstallerDialog installerDialog = (InstallerDialog)container;
                        installerDialog.reset();
                    }
                }
            }
        });
        this.extensionButtons.put(configurationListener, extensionsButton);
        toolBar.getParent().layout(true);
        toolBar.layout(true);
        return extensionsButton;
    }

    public void setPerformer(SetupTaskPerformer performer) {
        super.setPerformer(performer);
        if (performer != null) {
            performer.put(UIServices.class, (Object)this.getUiServices());
        }
    }

    public boolean handleMissingIndex(Shell shell) {
        int answer = new MessageDialog(shell, Messages.Installer_NetworkProblem_title, null, Messages.Installer_TalogNotLoaded_message, 1, new String[]{Messages.Installer_Retry_label, Messages.Installer_Configure_label, Messages.Installer_Exit_label}, 0).open();
        switch (answer) {
            case 1: {
                new NetworkConnectionsDialog(shell).open();
            }
            case 0: {
                ResourceSet resourceSet = this.getResourceSet();
                URI currentIndexLocation = resourceSet.getURIConverter().normalize(SetupContext.INDEX_SETUP_URI);
                ECFURIHandlerImpl.clearExpectedETags();
                this.reloadIndex(currentIndexLocation);
                return true;
            }
        }
        return false;
    }

    public void runEventLoop(Shell shell) {
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            try {
                if (display.readAndDispatch()) continue;
                if (this.canHandleDelayedResourceURIs() && !this.delayedResourceURIs.isEmpty()) {
                    Iterator<URI> it = this.delayedResourceURIs.iterator();
                    URI resourceURI = it.next();
                    it.remove();
                    this.getTransferSupport().urisDropped(Collections.singleton(resourceURI));
                    continue;
                }
                display.sleep();
            }
            catch (Throwable throwable) {
                SetupInstallerPlugin.INSTANCE.log(throwable);
            }
        }
        if (!display.isDisposed()) {
            display.update();
        }
        display.removeListener(46, this.openListener);
        display.removeListener(54, this.openListener);
    }
}

