/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.targlets.internal.core.TargletContainer;
import org.eclipse.oomph.util.pde.TargetPlatformListener;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;

public class TargetPlatformBundlePoolInitializer
extends ClasspathVariableInitializer {
    public static final String VARIABLE = "TARGET_PLATFORM_BUNDLE_POOL";
    private static final TargetPlatformListener TARGET_PLATFORM_LISTENER = new TargetPlatformListener(){

        public void targetDefinitionActivated(ITargetDefinition oldTargetDefinition, ITargetDefinition newTargetDefinition) throws Exception {
            TargetPlatformBundlePoolInitializer.resetVariable();
        }
    };

    public void initialize(String variable) {
        TargetPlatformBundlePoolInitializer.resetVariable();
    }

    private static void resetVariable() {
        try {
            ITargetLocation[] targetLocations;
            ITargetDefinition target = TargetPlatformUtil.getActiveTargetDefinition();
            if (target != null && (targetLocations = target.getTargetLocations()) != null) {
                ITargetLocation[] iTargetLocationArray = targetLocations;
                int n = targetLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    TargletContainer container;
                    BundlePool bundlePool;
                    ITargetLocation location = iTargetLocationArray[n2];
                    if (location instanceof TargletContainer && (bundlePool = (container = (TargletContainer)location).getDescriptor().getBundlePool()) != null) {
                        JavaCore.setClasspathVariable((String)VARIABLE, (IPath)new Path(bundlePool.getLocation().getAbsolutePath()), null);
                        return;
                    }
                    ++n2;
                }
            }
            JavaCore.setClasspathVariable((String)VARIABLE, (IPath)new Path(TargetPlatform.getLocation()), null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static void start() {
        TargetPlatformUtil.addListener((TargetPlatformListener)TARGET_PLATFORM_LISTENER);
    }

    public static void stop() {
        TargetPlatformUtil.removeListener((TargetPlatformListener)TARGET_PLATFORM_LISTENER);
    }
}

