/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.util.List;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogSelector {
    private final CatalogManager catalogManager;
    private boolean product;

    public CatalogSelector(CatalogManager catalogManager, boolean product) {
        this.catalogManager = catalogManager;
        this.product = product;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public CatalogSelection getSelection() {
        return this.catalogManager.getSelection();
    }

    public List<? extends Scope> getSelectedCatalogs() {
        return this.catalogManager.getSelectedCatalogs(this.product);
    }

    public List<? extends Scope> getCatalogs() {
        return this.catalogManager.getCatalogs(this.product);
    }

    public void select(Scope catalog, boolean on) {
        this.catalogManager.selectCatalog(this.product, catalog, on);
    }

    public void configure(final ToolItem toolItem) {
        final ToolBar toolBar = toolItem.getParent();
        final Menu menu = new Menu((Control)toolBar);
        toolItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                menu.dispose();
            }
        });
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem[] menuItemArray = menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem menuItem = menuItemArray[n2];
                    menuItem.dispose();
                    ++n2;
                }
                List selectedCatalogs = CatalogSelector.this.catalogManager.getSelectedCatalogs(CatalogSelector.this.product);
                for (final Scope catalog : CatalogSelector.this.catalogManager.getCatalogs(CatalogSelector.this.product)) {
                    String name = catalog.getName();
                    if ("self".equals(name) || "redirectable".equals(name)) continue;
                    final MenuItem item = new MenuItem(menu, 32);
                    item.setText(SetupCoreUtil.getLabel((Scope)catalog));
                    item.setSelection(selectedCatalogs.contains(catalog));
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            boolean on = item.getSelection();
                            CatalogSelector.this.select(catalog, on);
                        }
                    });
                }
                Composite parent = toolBar.getParent();
                Point location = parent.toDisplay(toolBar.getLocation());
                location.y += toolItem.getBounds().height;
                menu.setLocation(location);
                menu.setVisible(true);
            }
        });
    }
}

