/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.StyledString;
import org.eclipse.oomph.maven.Dependency;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.provider.CoordinateItemProvider;

public class DependencyItemProvider
extends CoordinateItemProvider {
    private final AdapterFactoryItemDelegator itemDelegator = new AdapterFactoryItemDelegator(this.getAdapterFactory());

    public DependencyItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addResolvedProjectPropertyDescriptor(object);
            this.addResolvedManagedDependencyPropertyDescriptor(object);
            this.addIncomingResolvedManagedDependenciesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addResolvedProjectPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dependency_resolvedProject_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dependency_resolvedProject_feature", "_UI_Dependency_type"), (EStructuralFeature)MavenPackage.Literals.DEPENDENCY__RESOLVED_PROJECT, false, false, true, null, null, null));
    }

    protected void addResolvedManagedDependencyPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dependency_resolvedManagedDependency_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dependency_resolvedManagedDependency_feature", "_UI_Dependency_type"), (EStructuralFeature)MavenPackage.Literals.DEPENDENCY__RESOLVED_MANAGED_DEPENDENCY, false, false, true, null, null, null));
    }

    protected void addIncomingResolvedManagedDependenciesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Dependency_incomingResolvedManagedDependencies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Dependency_incomingResolvedManagedDependencies_feature", "_UI_Dependency_type"), (EStructuralFeature)MavenPackage.Literals.DEPENDENCY__INCOMING_RESOLVED_MANAGED_DEPENDENCIES, true, false, true, null, null, null));
    }

    @Override
    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Dependency"));
    }

    @Override
    protected boolean shouldComposeCreationImage() {
        return true;
    }

    @Override
    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    @Override
    public StyledString getStyledText(Object object) {
        String expandedVersion;
        Project resolvedProject;
        StyledString styledLabel = super.getStyledText(object);
        Dependency dependency = (Dependency)object;
        Dependency resolvedManagedDependency = dependency.getResolvedManagedDependency();
        String referenceVersion = dependency.getExpandedVersion();
        if (resolvedManagedDependency != null) {
            String version = resolvedManagedDependency.getVersion();
            String dependencyVersion = dependency.getVersion();
            if (!version.isBlank() && !version.equals(dependencyVersion)) {
                String expandedVersion2 = resolvedManagedDependency.getExpandedVersion();
                if (expandedVersion2.equals(version)) {
                    styledLabel.append(" : ", StyledString.Style.QUALIFIER_STYLER);
                    styledLabel.append(version, StyledString.Style.COUNTER_STYLER);
                    referenceVersion = version;
                } else {
                    styledLabel.append(" : ", StyledString.Style.QUALIFIER_STYLER);
                    styledLabel.append(version, StyledString.Style.QUALIFIER_STYLER);
                    styledLabel.append(" = ", StyledString.Style.QUALIFIER_STYLER);
                    styledLabel.append(expandedVersion2, StyledString.Style.COUNTER_STYLER);
                    referenceVersion = expandedVersion2;
                }
            }
        }
        if ((resolvedProject = dependency.getResolvedProject()) != null && !(expandedVersion = resolvedProject.getExpandedVersion()).equals(referenceVersion)) {
            if (resolvedManagedDependency != null) {
                styledLabel.append(" : ", StyledString.Style.QUALIFIER_STYLER);
            } else {
                styledLabel.append(" \u26a0 ", StyledString.Style.COUNTER_STYLER);
            }
            styledLabel.append(expandedVersion, StyledString.Style.COUNTER_STYLER);
        }
        return styledLabel;
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public Object getParent(Object object) {
        Object parent = super.getParent(object);
        for (Object child : this.itemDelegator.getChildren(parent)) {
            if (!this.itemDelegator.getChildren(child).contains(object)) continue;
            return child;
        }
        return parent;
    }
}

