/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.util.Arrays;

public class BcPBESecretKeyDecryptorBuilder {
    private PGPDigestCalculatorProvider calculatorProvider;

    public BcPBESecretKeyDecryptorBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public PBESecretKeyDecryptor build(char[] cArray) {
        return new PBESecretKeyDecryptor(cArray, this.calculatorProvider){

            @Override
            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(false, BcImplProvider.createBlockCipher(n), byArray, byArray2);
                    byte[] byArray4 = new byte[n3];
                    int n4 = bufferedBlockCipher.processBytes(byArray3, n2, n3, byArray4, 0);
                    n4 += bufferedBlockCipher.doFinal(byArray4, n4);
                    return byArray4;
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
                }
            }

            @Override
            public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                byte[] byArray5 = new byte[]{(byte)(0xC0 | n3), (byte)n4, (byte)n, (byte)n2};
                HKDFParameters hKDFParameters = new HKDFParameters(byArray, null, byArray5);
                HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hKDFBytesGenerator.init((DerivationParameters)hKDFParameters);
                byte[] byArray6 = new byte[SymmetricKeyUtils.getKeyLengthInOctets(n)];
                hKDFBytesGenerator.generateBytes(byArray6, 0, byArray6.length);
                byte[] byArray7 = Arrays.prepend((byte[])byArray4, (byte)((byte)(0xC0 | n3)));
                AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(n, n2);
                aEADBlockCipher.init(false, (CipherParameters)new AEADParameters(new KeyParameter(byArray6), 128, byArray2, byArray7));
                int n5 = aEADBlockCipher.getOutputSize(byArray3.length);
                byte[] byArray8 = new byte[n5];
                n5 = aEADBlockCipher.processBytes(byArray3, 0, byArray3.length, byArray8, 0);
                try {
                    aEADBlockCipher.doFinal(byArray8, n5);
                    return byArray8;
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("Exception recovering AEAD protected private key material", (Exception)((Object)invalidCipherTextException));
                }
            }
        };
    }
}

