/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assuranceassets.assuranceasset;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EventKind implements Enumerator
{
    CREATION(0, "Creation", "Creation"),
    MODIFICATION(1, "Modification", "Modification"),
    EVALUATION(2, "Evaluation", "Evaluation"),
    APPROVAL(3, "Approval", "Approval"),
    REVOCATION(4, "Revocation", "Revocation");

    public static final int CREATION_VALUE = 0;
    public static final int MODIFICATION_VALUE = 1;
    public static final int EVALUATION_VALUE = 2;
    public static final int APPROVAL_VALUE = 3;
    public static final int REVOCATION_VALUE = 4;
    private static final EventKind[] VALUES_ARRAY;
    public static final List<EventKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EventKind[]{CREATION, MODIFICATION, EVALUATION, APPROVAL, REVOCATION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EventKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EventKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EventKind get(int value) {
        switch (value) {
            case 0: {
                return CREATION;
            }
            case 1: {
                return MODIFICATION;
            }
            case 2: {
                return EVALUATION;
            }
            case 3: {
                return APPROVAL;
            }
            case 4: {
                return REVOCATION;
            }
        }
        return null;
    }

    private EventKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

