/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.nattable.xtext.valuespecification.celleditor;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.nattable.manager.table.ITableAxisElementProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.uml.nattable.xtext.integration.celleditor.AbstractXtextCellEditor;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.uml2.uml.UMLPackage;

public class ValueSpecificationCellEditor
extends AbstractXtextCellEditor {
    public ValueSpecificationCellEditor(Table table, Object axisElement, ITableAxisElementProvider elementProvider) {
        super(table, axisElement, elementProvider);
    }

    protected EObject getEditedEObject() {
        int columnIndex = this.layerCell.getColumnIndex();
        int rowIndex = this.layerCell.getRowIndex();
        Object row = this.elementProvider.getRowElement(rowIndex);
        Object column = this.elementProvider.getColumnElement(columnIndex);
        row = AxisUtils.getRepresentedElement((Object)row);
        column = AxisUtils.getRepresentedElement((Object)column);
        EObject editedEObject = null;
        if (row instanceof EObject && column instanceof EStructuralFeature) {
            if (UMLPackage.Literals.VALUE_SPECIFICATION == ((EStructuralFeature)column).getEType()) {
                editedEObject = (EObject)row;
            }
        } else if (row instanceof EStructuralFeature && column instanceof EObject && UMLPackage.Literals.VALUE_SPECIFICATION == ((EStructuralFeature)row).getEType()) {
            editedEObject = (EObject)column;
        }
        return editedEObject;
    }

    protected DefaultXtextDirectEditorConfiguration getConfigurationFromEditedEObject(Object row, Object column) {
        if (row instanceof EObject && column instanceof EStructuralFeature || row instanceof EStructuralFeature && column instanceof EObject) {
            EStructuralFeature feature = (EStructuralFeature)(column instanceof EStructuralFeature ? column : row);
            EObject contextElement = (EObject)(row instanceof EObject ? row : column);
            String semanticClassName = feature.getEType().getInstanceClassName();
            if (contextElement instanceof EObject) {
                List languages = DirectEditorsUtil.getLanguages((String)semanticClassName);
                for (String currentLanguage : languages) {
                    IDirectEditorConfiguration directEditorConfiguration = DirectEditorsUtil.findEditorConfigurationWithPriority((String)currentLanguage, (String)semanticClassName);
                    if (!(directEditorConfiguration instanceof DefaultXtextDirectEditorConfiguration)) continue;
                    DefaultXtextDirectEditorConfiguration xtextConfiguration = (DefaultXtextDirectEditorConfiguration)directEditorConfiguration;
                    xtextConfiguration.preEditAction(contextElement.eGet(feature));
                    return xtextConfiguration;
                }
            }
        }
        return null;
    }
}

