/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.impactanalysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceAssetEvent;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.EventKind;
import org.eclipse.opencert.evm.evidspec.evidence.Artefact;
import org.eclipse.opencert.impactanalysis.ImpactSource;
import org.eclipse.opencert.impactanalysis.eventcreators.ChangeDrivenEventsCreatorsFactory;
import org.eclipse.opencert.impactanalysis.eventcreators.IChangeDrivenEventsCreator;
import org.eclipse.opencert.impactanalysis.relations.ArtefactRelationType;
import org.eclipse.opencert.impactanalysis.relations.IArtefactRelationImpact;
import org.eclipse.opencert.impactanalysis.relations.RelationVisitationRecord;
import org.eclipse.opencert.impactanalysis.relations.traverse.AbstractRelationsTraverser;
import org.eclipse.opencert.impactanalysis.relations.traverse.DirectAndBaseRelationsTraverser;
import org.eclipse.opencert.impactanalysis.relations.traverse.DirectArtefactsRelationsTraverser;
import org.eclipse.opencert.infra.general.general.ChangeEffectKind;
import org.eclipse.opencert.storage.cdo.CDOStorageUtil;
import org.eclipse.opencert.storage.cdo.executors.SessionNotClosingInTransactionExecutor;
import org.eclipse.opencert.storage.cdo.property.IOpencertClientConfigurationAdapter;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.eclipse.opencert.storage.cdo.session.ICDOSessionProvider;
import org.eclipse.opencert.storage.cdo.session.SimpleCDOSessionProvider;

public class ImpactAnalyser {
    private final ICDOSessionProvider cdoSessionProvider;

    public ImpactAnalyser(IOpencertClientConfigurationAdapter clientConfigurationAdapter) {
        this.cdoSessionProvider = new SimpleCDOSessionProvider(clientConfigurationAdapter);
    }

    public ImpactAnalyser(ICDOSessionProvider icdoSessionProvider) {
        this.cdoSessionProvider = icdoSessionProvider;
    }

    public List<IArtefactRelationImpact> listArtefactsRelationImpacts(final List<ImpactSource> impactSources) {
        final ArrayList<IArtefactRelationImpact> artefactsRelationImpacts = new ArrayList<IArtefactRelationImpact>();
        final HashSet artefactRelVisitationRecords = new HashSet();
        new SessionNotClosingInTransactionExecutor(this.cdoSessionProvider){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                for (ImpactSource impactSource : impactSources) {
                    ImpactAnalyser.this.recurseAllImpactedArtefactRelations(impactSource.getImpactingArtefactCdoId(), null, impactSource.getImpactingEventKind(), artefactsRelationImpacts, artefactRelVisitationRecords, cdoTransaction, 0);
                }
            }
        }.executeReadOnlyOperation();
        return artefactsRelationImpacts;
    }

    public String visualizeArtefactsRelationImpacts(List<IArtefactRelationImpact> artefactsRelationImpacts) {
        return this.visualizeArtefactsRelationImpacts(artefactsRelationImpacts, "\t", "\n");
    }

    public String visualizeArtefactsRelationImpacts(List<IArtefactRelationImpact> artefactsRelationImpacts, String indendationString, String nextLineString) {
        StringBuilder stringBuilder = new StringBuilder();
        for (IArtefactRelationImpact artefactsRelationImpact : artefactsRelationImpacts) {
            int nr = 0;
            while (nr < artefactsRelationImpact.getRecursionDepth()) {
                stringBuilder.append(indendationString);
                ++nr;
            }
            stringBuilder.append(artefactsRelationImpact.toString());
            stringBuilder.append(nextLineString);
        }
        return stringBuilder.toString();
    }

    public void close() {
        this.cdoSessionProvider.close();
    }

    public void executeArtefactsRelationImpacts(final List<IArtefactRelationImpact> artefactsRelationImpacts) {
        new SessionNotClosingInTransactionExecutor(this.cdoSessionProvider){

            public void executeInTransaction(CDOTransaction cdoTransaction) {
                for (IArtefactRelationImpact artefactsRelationImpact : artefactsRelationImpacts) {
                    ChangeEffectKind impactedChangeEffectKind;
                    IChangeDrivenEventsCreator changeDrivenEventsCreator;
                    if (!ArtefactRelationType.DIRECT_EVIDENCE_RELATION.equals((Object)artefactsRelationImpact.getArtefactRelationType()) && !ArtefactRelationType.BASELINE_TO_EVIDENCE_VIA_MAP_RELATION.equals((Object)artefactsRelationImpact.getArtefactRelationType()) || (changeDrivenEventsCreator = ChangeDrivenEventsCreatorsFactory.getProperChangeDrivenEventsCreator(impactedChangeEffectKind = artefactsRelationImpact.getImpactedChangeEffectKind())) == null) continue;
                    AssuranceAssetEvent newEvent = changeDrivenEventsCreator.produceEvent(artefactsRelationImpact, impactedChangeEffectKind);
                    Artefact impactedArtefact = ImpactAnalyser.this.queryForArtefact(artefactsRelationImpact.getImpactedArtefactCDOId(), cdoTransaction);
                    if (impactedArtefact == null) {
                        throw new RuntimeException("IA execution called for impactedArtefact which doesn't exist in database");
                    }
                    impactedArtefact.getLifecycleEvent().add((Object)newEvent);
                }
            }
        }.executeReadWriteOperation();
    }

    private void recurseAllImpactedArtefactRelations(Long impactSourceCdoId, IArtefactRelationImpact sourceArtefactRelationImpact, EventKind impactingEventKind, List<IArtefactRelationImpact> artefactsRelationImpacts, Set<RelationVisitationRecord> artefactRelVisitationRecords, CDOTransaction cdoTransaction, int recursionDepth) {
        boolean isImpactAnalysisViaBaselineElementsEnabled = OpencertPropertiesReader.getInstance().isImpactAnalysisViaBaselineElementsEnabled();
        AbstractRelationsTraverser relationsTraverser = isImpactAnalysisViaBaselineElementsEnabled ? new DirectAndBaseRelationsTraverser() : new DirectArtefactsRelationsTraverser();
        List<IArtefactRelationImpact> artefactRelationImpacts = relationsTraverser.generateArtefactRelationImpactsList(cdoTransaction, impactSourceCdoId, sourceArtefactRelationImpact, recursionDepth, impactingEventKind);
        for (IArtefactRelationImpact artefactRelationImpact : artefactRelationImpacts) {
            RelationVisitationRecord artefactRelVisitationRecord;
            EventKind newImpactingEventKind = null;
            newImpactingEventKind = artefactRelationImpact.generateNewEventBasedOnChangeEffectKindOrForwardCurrent(impactingEventKind);
            if (newImpactingEventKind == null || artefactRelVisitationRecords.contains(artefactRelVisitationRecord = new RelationVisitationRecord(artefactRelationImpact))) continue;
            artefactRelVisitationRecords.add(artefactRelVisitationRecord);
            artefactsRelationImpacts.add(artefactRelationImpact);
            this.recurseAllImpactedArtefactRelations(artefactRelationImpact.getImpactedArtefactCDOId(), artefactRelationImpact, newImpactingEventKind, artefactsRelationImpacts, artefactRelVisitationRecords, cdoTransaction, recursionDepth + 1);
        }
    }

    private Artefact queryForArtefact(Long impactingArtefactCdoId, CDOTransaction cdoTransaction) {
        CDOQuery query = cdoTransaction.createQuery("sql", "select * from evidence_artefact where cdo_id = " + impactingArtefactCdoId + CDOStorageUtil.getMandatoryCDOQuerySuffix());
        return (Artefact)query.getResultValue(Artefact.class);
    }
}

