/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOClassNotFoundException;
import org.eclipse.emf.cdo.common.util.CDOPackageNotFoundException;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOQueryInfoImpl
implements CDOQueryInfo {
    protected String queryLanguage;
    protected String queryString;
    protected Object context;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    protected int maxResults = -1;
    protected CDOChangeSetData changeSetData;

    public CDOQueryInfoImpl(String queryLanguage, String queryString, Object context) {
        this.queryLanguage = queryLanguage;
        this.queryString = queryString;
        this.context = context;
    }

    public CDOQueryInfoImpl(CDODataInput in) throws IOException {
        this.queryLanguage = in.readString();
        this.queryString = in.readString();
        try {
            this.context = in.readCDORevisionOrPrimitiveOrClassifier();
        }
        catch (CDOPackageNotFoundException cDOPackageNotFoundException) {
        }
        catch (CDOClassNotFoundException cDOClassNotFoundException) {
            // empty catch block
        }
        this.maxResults = in.readInt();
        if (in.readBoolean()) {
            this.changeSetData = in.readCDOChangeSetData();
        }
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            String key = in.readString();
            try {
                Object object = in.readCDORevisionOrPrimitiveOrClassifier();
                this.parameters.put(key, object);
            }
            catch (CDOPackageNotFoundException cDOPackageNotFoundException) {
            }
            catch (CDOClassNotFoundException cDOClassNotFoundException) {
                // empty catch block
            }
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeString(this.queryLanguage);
        out.writeString(this.queryString);
        out.writeCDORevisionOrPrimitiveOrClassifier(this.context);
        out.writeInt(this.maxResults);
        if (this.changeSetData != null) {
            out.writeBoolean(true);
            out.writeCDOChangeSetData(this.changeSetData);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.parameters.size());
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            out.writeString(entry.getKey());
            out.writeCDORevisionOrPrimitiveOrClassifier(entry.getValue());
        }
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getQueryLanguage() {
        return this.queryLanguage;
    }

    @Override
    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public CDOQueryInfoImpl setContext(Object context) {
        this.context = context;
        return this;
    }

    public void addParameter(String key, Object value) {
        this.parameters.put(key, value);
    }

    @Override
    public int getMaxResults() {
        return this.maxResults;
    }

    public CDOQueryInfoImpl setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    @Deprecated
    public boolean isLegacyModeEnabled() {
        return true;
    }

    @Override
    public CDOChangeSetData getChangeSetData() {
        return this.changeSetData;
    }

    public void setChangeSetData(CDOChangeSetData changeSetData) {
        this.changeSetData = changeSetData;
    }
}

