/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatableComboBoxFieldEditor
extends FieldEditor {
    private Control label;
    private Combo widget;
    private EObject prefValue;
    private List<EObject> data;
    private EAttribute attribute;

    public UpdatableComboBoxFieldEditor(String preference, String label, Composite parent) {
        this.init(preference, label);
        this.data = new ArrayList<EObject>();
        this.label = this.getLabelControl(parent);
        this.widget = new Combo(parent, 8);
        this.widget.setFont(parent.getFont());
        this.widget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                EObject oldValue = UpdatableComboBoxFieldEditor.this.prefValue;
                UpdatableComboBoxFieldEditor.this.prefValue = null;
                String name = UpdatableComboBoxFieldEditor.this.widget.getText();
                if (name != null) {
                    for (EObject obj : UpdatableComboBoxFieldEditor.this.data) {
                        if (!name.equals(UpdatableComboBoxFieldEditor.this.getLabelFor(obj))) continue;
                        UpdatableComboBoxFieldEditor.this.prefValue = obj;
                        break;
                    }
                }
                UpdatableComboBoxFieldEditor.this.setPresentsDefaultValue(false);
                UpdatableComboBoxFieldEditor.this.fireValueChanged("field_editor_value", oldValue, UpdatableComboBoxFieldEditor.this.prefValue);
            }
        });
        this.createControl(parent);
    }

    public EObject getSelection() {
        return this.prefValue;
    }

    public void setSelection(EObject obj) {
        this.prefValue = obj;
        this.widget.setText(this.getLabelFor(this.prefValue));
    }

    public void setSelection(String value) {
        this.load(value);
    }

    public void setContent(List<? extends EObject> data, EAttribute attribute) {
        this.data = new ArrayList<EObject>(data);
        this.attribute = attribute;
        this.widget.removeAll();
        for (EObject obj : this.data) {
            this.widget.add(this.getLabelFor(obj));
        }
        this.prefValue = this.data.get(0);
        this.widget.setText(this.getLabelFor(this.prefValue));
    }

    public void clearContent() {
        this.data = new ArrayList<EObject>();
        this.prefValue = null;
        this.widget.removeAll();
    }

    private String getValueFor(EObject object) {
        Object value = object.eGet((EStructuralFeature)this.attribute);
        return value == null ? null : value.toString();
    }

    private String getLabelFor(EObject object) {
        Object value = object.eGet((EStructuralFeature)this.attribute);
        return value == null ? null : value.toString();
    }

    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        this.label.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        this.widget.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        this.load(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.load(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    private void load(String value) {
        this.prefValue = null;
        if (value != null) {
            for (EObject obj : this.data) {
                if (!value.equals(this.getValueFor(obj))) continue;
                this.prefValue = obj;
                this.widget.setText(this.getLabelFor(obj));
                return;
            }
        }
        if (this.data.size() > 0) {
            this.prefValue = this.data.get(0);
            this.widget.setText(this.getLabelFor(this.prefValue));
        } else {
            this.widget.setText(null);
        }
    }

    protected void doStore() {
        if (this.prefValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.getValueFor(this.prefValue));
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.widget.setEnabled(enabled);
    }
}

