/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.cdo.server.internal.admin.InternalCDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.spi.server.IAppExtension;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RepositoryConfigurationManagerExtension
implements IAppExtension {
    private static final String DEFAULT_CATALOG_PATH = "/catalog";

    public void start(File configFile) throws Exception {
        OM.LOG.info("Repository configuration manager extension starting");
        IPluginContainer container = IPluginContainer.INSTANCE;
        Document document = this.getDocument(configFile);
        NodeList repositoryConfigs = document.getElementsByTagName("repository");
        int i = 0;
        while (i < repositoryConfigs.getLength()) {
            Element repositoryConfig = (Element)repositoryConfigs.item(i);
            if (this.configureAdminRepository((IManagedContainer)container, repositoryConfig)) break;
            ++i;
        }
        OM.LOG.info("Repository configuration manager extension started");
    }

    public void stop() throws Exception {
        OM.LOG.info("Repository configuration manager extension stopping");
        OM.LOG.info("Repository configuration manager extension stopped");
    }

    protected Document getDocument(File configFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(configFile);
    }

    protected boolean configureAdminRepository(IManagedContainer container, Element repositoryConfig) {
        String name = repositoryConfig.getAttribute("name");
        InternalRepository repository = (InternalRepository)RepositoryFactory.get((IManagedContainer)container, (String)name);
        if (repository == null) {
            OM.LOG.warn("Repository not registered with container: " + name);
            return false;
        }
        NodeList adminRepositories = repositoryConfig.getElementsByTagName("adminRepository");
        if (adminRepositories.getLength() > 1) {
            OM.LOG.warn("A maximum of one administration catalog can be configured in repository " + repository);
            return false;
        }
        if (adminRepositories.getLength() == 1) {
            Element adminRepositoryElement = (Element)adminRepositories.item(0);
            String type = adminRepositoryElement.getAttribute("configurationManager");
            if (type == null || type.length() == 0) {
                OM.LOG.warn("Repository configuration manager type not specified for repository " + repository);
                return false;
            }
            String description = adminRepositoryElement.getAttribute("description");
            if (StringUtil.isEmpty((String)description)) {
                description = adminRepositoryElement.getAttribute("catalogPath");
            }
            if (StringUtil.isEmpty((String)description)) {
                description = DEFAULT_CATALOG_PATH;
            }
            InternalCDORepositoryConfigurationManager repoManager = (InternalCDORepositoryConfigurationManager)container.getElement("org.eclipse.emf.cdo.server.admin.repositoryConfigurationManagers", type, description);
            repoManager.setAdminRepository(repository);
            return true;
        }
        return false;
    }
}

