/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.configuration.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationFactory;
import org.eclipse.papyrus.infra.viewpoints.configuration.ConfigurationPackage;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusView;
import org.eclipse.papyrus.infra.viewpoints.configuration.PapyrusViewpoint;
import org.eclipse.papyrus.infra.viewpoints.configuration.ProfilePropertyDescriptor;
import org.eclipse.papyrus.infra.viewpoints.iso42010.provider.ModelKindItemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PapyrusViewItemProvider
extends ModelKindItemProvider {
    public PapyrusViewItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIconPropertyDescriptor(object);
            this.addParentPropertyDescriptor(object);
            this.addProfilesPropertyDescriptor(object);
            this.addImplementationIDPropertyDescriptor(object);
            this.addCategoriesPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addIconPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusView_icon_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusView_icon_feature", "_UI_PapyrusView_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_VIEW__ICON, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addParentPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusView_parent_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusView_parent_feature", "_UI_PapyrusView_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_VIEW__PARENT, true, false, true, null, null, null));
    }

    protected void addProfilesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ProfilePropertyDescriptor((IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusView_profiles_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusView_profiles_feature", "_UI_PapyrusView_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_VIEW__PROFILES, true, false, true, null, null, null)));
    }

    protected void addImplementationIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusView_implementationID_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusView_implementationID_feature", "_UI_PapyrusView_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_VIEW__IMPLEMENTATION_ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCategoriesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_PapyrusView_categories_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_PapyrusView_categories_feature", "_UI_PapyrusView_type"), (EStructuralFeature)ConfigurationPackage.Literals.PAPYRUS_VIEW__CATEGORIES, true, false, true, null, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ConfigurationPackage.Literals.PAPYRUS_VIEW__MODEL_RULES);
            this.childrenFeatures.add(ConfigurationPackage.Literals.PAPYRUS_VIEW__OWNING_RULES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PapyrusView.png"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((PapyrusView)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_PapyrusView_type") : String.valueOf(this.getString("_UI_PapyrusView_type")) + " " + label;
    }

    protected static String getTextFor(PapyrusView view) {
        PapyrusViewpoint vp = (PapyrusViewpoint)view.eContainer();
        if (view.getName() == null) {
            return String.valueOf(vp.getName()) + " :: <natural> [" + view.getImplementationID() + "]";
        }
        return String.valueOf(vp.getName()) + " :: " + view.getName();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(PapyrusView.class)) {
            case 4: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 7: 
            case 8: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ConfigurationPackage.Literals.PAPYRUS_VIEW__MODEL_RULES, ConfigurationFactory.eINSTANCE.createModelRule()));
        newChildDescriptors.add(this.createChildParameter(ConfigurationPackage.Literals.PAPYRUS_VIEW__OWNING_RULES, ConfigurationFactory.eINSTANCE.createOwningRule()));
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

