/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.actions;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SynchronizeWithCDOCheckout
implements IObjectActionDelegate {
    private org.eclipse.core.internal.resources.File sel = null;
    private String checkoutId = "0";

    public void run(IAction action) {
        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "SynchronizeWithCDOCheckout", "CDOCheckoutID", "", null);
        if (dialog.open() != 0) {
            return;
        }
        this.checkoutId = dialog.getValue();
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = null;
        try {
            dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
        try {
            Document doc = dBuilder.parse(this.sel.getLocationURI().toString());
            doc.getDocumentElement().getElementsByTagName("Contract");
            if (doc.hasChildNodes()) {
                this.fixCDOCheckoutID(doc.getChildNodes());
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            File jfile = new File(this.sel.getLocation().toString());
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(jfile);
            transformer.transform(source, result);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            org.eclipse.core.internal.resources.File file;
            TreeSelection treeSel = (TreeSelection)selection;
            this.sel = file = (org.eclipse.core.internal.resources.File)treeSel.getFirstElement();
        }
        catch (Exception exception) {}
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private void fixCDOCheckoutID(NodeList nodeList) {
        int count = 0;
        while (count < nodeList.getLength()) {
            Node tempNode = nodeList.item(count);
            if (tempNode.getNodeType() == 1) {
                if (tempNode.hasAttributes()) {
                    NamedNodeMap nodeMap = tempNode.getAttributes();
                    String value = "";
                    int i = 0;
                    while (i < nodeMap.getLength()) {
                        Node node = nodeMap.item(i);
                        if (node.getNodeName().equals("href") && (value = node.getNodeValue()).contains("cdo.checkout")) {
                            value = value.replaceFirst("\\/\\/[0-9]", "//" + this.checkoutId);
                            node.setNodeValue(value);
                        }
                        ++i;
                    }
                }
                if (tempNode.hasChildNodes()) {
                    this.fixCDOCheckoutID(tempNode.getChildNodes());
                }
            }
            ++count;
        }
    }
}

