/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.papyrus.infra.services.validation.ValidationTool;
import org.eclipse.papyrus.infra.services.validation.commands.AbstractValidateCommand;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.chess.validator.command.util.ChessGenericDiagnostician;

public class ChessGenericValidateCommand
extends AbstractValidateCommand {
    public Collection<String> pluginIds = new ArrayList<String>();
    private boolean markers = false;

    public ChessGenericValidateCommand(String label, String pluginId, EObject selectedElement) {
        super(label, TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
        this.pluginIds.add(pluginId);
    }

    public ChessGenericValidateCommand(String label, Collection<String> pluginIds, EObject selectedElement) {
        super(label, TransactionUtil.getEditingDomain((EObject)selectedElement), selectedElement);
        for (String id : pluginIds) {
            this.pluginIds.add(id);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
        while (this.selectedElement.eContainer() != null) {
            this.selectedElement = this.selectedElement.eContainer();
        }
        this.runValidation(this.selectedElement);
        Resource resource = this.selectedElement.eResource();
        if (resource != null) {
            Path path = new Path(resource.getURI().toPlatformString(false));
            IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = wsRoot.getFile((IPath)path);
            try {
                ChessGenericValidateCommand.processMarkers((IResource)file);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected Diagnostic validate(IProgressMonitor progressMonitor, EObject validateElement) {
        int count = 0;
        TreeIterator i = validateElement.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        progressMonitor.beginTask("", count);
        IConstraintFilter constraintFilter = new IConstraintFilter(){

            public boolean accept(IConstraintDescriptor constraint, EObject target) {
                return ChessGenericValidateCommand.this.pluginIds.contains(constraint.getPluginId());
            }
        };
        AdapterFactory adapterFactory = this.domain instanceof AdapterFactoryEditingDomain ? ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory() : null;
        ChessGenericDiagnostician diagnostician = this.createChessGenericDiagnostician(adapterFactory, progressMonitor, constraintFilter);
        BasicDiagnostic diagnostic = diagnostician.createDefaultDiagnostic(validateElement);
        Map context = diagnostician.createDefaultContext();
        progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(validateElement)}));
        diagnostician.validate(validateElement, (DiagnosticChain)diagnostic, context);
        return diagnostic;
    }

    protected ChessGenericDiagnostician createChessGenericDiagnostician(final AdapterFactory adapterFactory, IProgressMonitor progressMonitor, IConstraintFilter filter) {
        return new ChessGenericDiagnostician(filter){

            public String getObjectLabel(EObject eObject) {
                IItemLabelProvider itemLabelProvider;
                if (adapterFactory != null && !eObject.eIsProxy() && (itemLabelProvider = (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProvider.class)) != null) {
                    return itemLabelProvider.getText((Object)eObject);
                }
                return super.getObjectLabel(eObject);
            }
        };
    }

    protected static void processMarkers(IResource resource) throws CoreException {
        IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        ArrayList<IMarker> markersToDelete = new ArrayList<IMarker>();
        int index = 0;
        while (index < markers.length) {
            IMarker currentMarker = markers[index];
            if (currentMarker.getAttributes().containsKey("relatedURIs")) {
                markersToDelete.add(currentMarker);
            }
            ++index;
        }
        for (IMarker marker : markersToDelete) {
            marker.delete();
        }
    }

    protected void handleDiagnostic(IProgressMonitor monitor, Diagnostic diagnostic, EObject validateElement, Shell shell) {
        Resource resource = this.getValidationResource();
        if (resource != null) {
            if (this.selectedElement != null) {
                ValidationTool vt = new ValidationTool(this.selectedElement);
                vt.deleteSubMarkers();
            }
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (!this.pluginIds.contains(childDiagnostic.getSource())) continue;
                MarkerListenerUtils.eclipseResourcesUtil.createMarkers(resource, childDiagnostic);
                this.markers = true;
            }
        }
    }

    public boolean getMarkers() {
        return this.markers;
    }

    public final void executeCommand(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        super.execute(monitor, info);
    }
}

