/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.widgets;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.FirstChildLayout;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;

public class SearchField
extends Composite {
    private static final Field patternFilterField = ReflectUtil.getField(FilteredTree.class, (String)"patternFilter");
    private static final Field refreshJobField = ReflectUtil.getField(FilteredTree.class, (String)"refreshJob");
    private final InternalTree filteredTree;

    public SearchField(Composite parent, final FilterHandler filterHandler) {
        super(parent, 0);
        this.setLayout(new FirstChildLayout());
        PatternFilter patternFilter = new PatternFilter(){

            public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
                if (SearchField.this.filteredTree != null) {
                    Text filterControl = SearchField.this.filteredTree.getFilterControl();
                    String filter = filterControl.getText();
                    if (ObjectUtil.equals((Object)filter, (Object)SearchField.this.filteredTree.getInitialText())) {
                        filter = null;
                    }
                    filterHandler.handleFilter(filter);
                }
                return new Object[0];
            }
        };
        this.filteredTree = new InternalTree(this, 0, patternFilter, true, patternFilter);
        final Text filterControl = this.filteredTree.getFilterControl();
        filterControl.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27 && !"".equals(filterControl.getText())) {
                    filterControl.setText("");
                    e.doit = false;
                }
            }
        });
        filterControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000002) {
                    SearchField.this.finishFilter();
                    e.doit = false;
                }
            }
        });
    }

    public final PatternFilter getPatternFilter() {
        return this.filteredTree.getPatternFilter();
    }

    public final Text getFilterControl() {
        return this.filteredTree.getFilterControl();
    }

    public final void setInitialText(String text) {
        this.filteredTree.setInitialText(text);
    }

    public final boolean getEnabled() {
        return this.filteredTree.getEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.filteredTree.setEnabled(enabled);
    }

    public boolean setFocus() {
        return this.getFilterControl().setFocus();
    }

    protected void checkSubclass() {
    }

    protected void finishFilter() {
    }

    public static interface FilterHandler {
        public void handleFilter(String var1);
    }

    private final class InternalTree
    extends FilteredTree {
        private final PatternFilter patternFilter;

        private InternalTree(Composite parent, int treeStyle, PatternFilter filter, boolean useNewLook, PatternFilter patternFilter) {
            super(parent, treeStyle, filter, useNewLook);
            this.patternFilter = patternFilter;
        }

        protected void init(int treeStyle, PatternFilter filter) {
            ReflectUtil.setValue((Field)patternFilterField, (Object)((Object)this), (Object)filter);
            this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
            this.createControl(SearchField.this, treeStyle);
            Job refreshJob = new Job("Refresh Filter"){

                protected IStatus run(IProgressMonitor monitor) {
                    UIUtil.syncExec(new Runnable(){

                        public void run() {
                            InternalTree.this.patternFilter.filter((Viewer)InternalTree.this.treeViewer, null, null);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            refreshJob.setSystem(true);
            ReflectUtil.setValue((Field)refreshJobField, (Object)((Object)this), (Object)refreshJob);
            this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
            this.setFont(SearchField.this.getFont());
        }

        protected void createControl(Composite xxx, int treeStyle) {
            super.createControl((Composite)SearchField.this, treeStyle);
            Tree tree = this.treeViewer.getTree();
            tree.setParent((Composite)SearchField.this);
            tree.setLayoutData((Object)new GridData(0, 0));
            this.treeComposite.dispose();
            this.treeComposite = null;
        }

        public String getInitialText() {
            return super.getInitialText();
        }
    }
}

