/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.wizards.profile;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.uml.diagram.wizards.messages.Messages;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserContentProvider;
import org.eclipse.papyrus.uml.diagram.wizards.profile.ProfileChooserLabelProvider;
import org.eclipse.papyrus.uml.diagram.wizards.widget.ExtensionFilter;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.extensionpoints.profile.RegisteredProfile;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class ProfileChooserComposite
extends Composite {
    private Text textField;
    private Button workspaceButton;
    private Button registeredButton;
    private LinkedList<ViewerFilter> filters;
    private IFile selectedFile;
    private ElementTreeSelectionDialog treeDialog;
    private boolean workspaceProfile;
    private String[] workspaceFilters = new String[]{"profile.uml"};

    public ProfileChooserComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(2, true));
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createProfileChooser(this);
    }

    private void createProfileChooser(Composite parent) {
        this.filters = new LinkedList();
        this.setFilterExtensions(this.workspaceFilters);
        this.textField = new Text(parent, 2048);
        GridData fieldGrid = new GridData(4, 4, true, false);
        fieldGrid.verticalAlignment = 4;
        fieldGrid.horizontalSpan = 2;
        this.textField.setLayoutData((Object)fieldGrid);
        this.treeDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new ProfileChooserLabelProvider(), (ITreeContentProvider)new ProfileChooserContentProvider());
        this.treeDialog.setInput((Object)RegisteredProfile.getRegisteredProfiles());
        this.treeDialog.setAllowMultiple(false);
        this.treeDialog.setTitle(Messages.SelectDiagramKindPage_ProfileComposite_RegisteredProfilesDialog);
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.equals(ProfileChooserComposite.this.workspaceButton)) {
                    ProfileChooserComposite.this.workspaceProfile = true;
                    IFile[] ifile = WorkspaceResourceDialog.openFileSelection((Shell)ProfileChooserComposite.this.getShell(), null, null, (boolean)false, (Object[])new IFile[]{ProfileChooserComposite.this.selectedFile}, (List)ProfileChooserComposite.this.filters);
                    if (ifile.length > 0) {
                        ProfileChooserComposite.this.selectedFile = ifile[0];
                        ProfileChooserComposite.this.textField.setText(ProfileChooserComposite.this.selectedFile.getFullPath().toString());
                    }
                }
                if (e.widget.equals(ProfileChooserComposite.this.registeredButton)) {
                    ProfileChooserComposite.this.workspaceProfile = false;
                    ProfileChooserComposite.this.treeDialog.open();
                    IRegisteredProfile profile = (IRegisteredProfile)ProfileChooserComposite.this.treeDialog.getFirstResult();
                    if (profile != null) {
                        ProfileChooserComposite.this.textField.setText(profile.getPath().toString());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.workspaceButton = new Button(parent, 0);
        this.workspaceButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.workspaceButton.addSelectionListener(selectionListener);
        this.workspaceButton.setText(Messages.SelectDiagramKindPage_ProfileComposite_WorkspaceSelectionButton);
        this.registeredButton = new Button(parent, 0);
        this.registeredButton.setLayoutData((Object)new GridData(4, 4, true, false));
        this.registeredButton.addSelectionListener(selectionListener);
        this.registeredButton.setText(Messages.SelectDiagramKindPage_ProfileComposite_RegisteredSelectionButton);
    }

    public String getProfileURI() {
        if (this.textField.isDisposed()) {
            return null;
        }
        String path = this.textField.getText();
        if (path.trim().equals("")) {
            return null;
        }
        if (this.workspaceProfile) {
            return path.trim();
        }
        return URI.createURI((String)path).toString();
    }

    public void setFilterExtensions(String[] extensions) {
        this.filters.clear();
        ExtensionFilter filter = new ExtensionFilter(extensions);
        this.filters.add(filter);
    }
}

