/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DiagramEditPartsUtil {
    public static final String BelongToDiagramSource = "es.cv.gvcase.mdt.uml2.diagram.common.Belongs_To_This_Diagram";
    public static final String DiagramsRelatedToElement = "es.cv.gvcase.mdt.uml2.diagram.common.DiagramsRelatedToElement";

    public static List<IGraphicalEditPart> getAllEditParts(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        DiagramEditPartsUtil.getTopMostEditPart(editPart);
        ArrayList<IGraphicalEditPart> editParts = new ArrayList<IGraphicalEditPart>();
        if (editPart instanceof IGraphicalEditPart) {
            editParts.add((IGraphicalEditPart)editPart);
        }
        DiagramEditPartsUtil.addEditPartGraphicalChildren(editPart, editParts);
        return editParts;
    }

    public static EditPart getTopMostEditPart(EditPart editPart) {
        EditPart parent;
        if (editPart == null) {
            return null;
        }
        EditPart actual = editPart;
        while ((parent = actual.getParent()) != null) {
            actual = parent;
        }
        return actual;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        if (editPart == null) {
            return null;
        }
        if (editPart instanceof IGraphicalEditPart) {
            IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
            View view = graphicalEditPart.getNotationView();
            Diagram diagram = view.getDiagram();
            Object object = graphicalEditPart.getViewer().getEditPartRegistry().get(diagram);
            if (object instanceof DiagramEditPart) {
                return (DiagramEditPart)object;
            }
        }
        if (editPart instanceof DiagramEditPart) {
            return (DiagramEditPart)editPart;
        }
        EditPart actual = editPart;
        EditPart parent = null;
        while ((parent = actual.getParent()) != null) {
            if (parent instanceof DiagramEditPart) {
                return (DiagramEditPart)parent;
            }
            actual = parent;
        }
        return null;
    }

    public static void handleNotificationForDiagram(IGraphicalEditPart editPart, Notification notification, List<EStructuralFeature> features) {
        EObject element = editPart.resolveSemanticElement();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (notifier != null && notifier == element && feature != null && oldValue != null && oldValue != newValue && features.contains(feature)) {
            DiagramEditPartsUtil.updateDiagram(editPart);
        }
    }

    public static void handleNotificationForView(IGraphicalEditPart editPart, Notification notification, List<EStructuralFeature> features) {
        EObject element = editPart.resolveSemanticElement();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        if (notifier != null && notifier == element && feature != null && oldValue != null && oldValue != newValue && features.contains(feature)) {
            DiagramEditPartsUtil.updateEditPart(editPart);
        }
    }

    public static void updateDiagram(View view) {
        if (view == null) {
            return;
        }
        if ((view = view.getDiagram()) == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateDiagram(IGraphicalEditPart editPart) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        if ((view = view.getDiagram()) == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateEditPart(IGraphicalEditPart editPart) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        EObject element = view.getElement();
        if (element == null) {
            return;
        }
        List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
        for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
            nextEditPolicy.refresh();
        }
    }

    public static void updateEditPartAndChildren(IGraphicalEditPart editPart, EClass eClass) {
        if (editPart == null) {
            return;
        }
        View view = editPart.getNotationView();
        if (view == null) {
            return;
        }
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            DiagramEditPartsUtil.updateEditPartAndChildren((IGraphicalEditPart)child, eClass);
        }
        EObject element = view.getElement();
        if (eClass != null && eClass.isInstance((Object)element)) {
            List editPolicies = CanonicalEditPolicy.getRegisteredEditPolicies((EObject)element);
            for (CanonicalEditPolicy nextEditPolicy : editPolicies) {
                nextEditPolicy.refresh();
            }
        }
    }

    private static void addEditPartGraphicalChildren(EditPart editPart, List<IGraphicalEditPart> list) {
        if (editPart == null) {
            return;
        }
        List children = editPart.getChildren();
        for (EditPart ep : children) {
            if (ep instanceof IGraphicalEditPart) {
                list.add((IGraphicalEditPart)ep);
            }
            DiagramEditPartsUtil.addEditPartGraphicalChildren(ep, list);
        }
    }

    public static List getEObjectViews(EObject element) {
        ArrayList views = new ArrayList();
        if (element != null) {
            EReference[] features = new EReference[]{NotationPackage.eINSTANCE.getView_Element()};
            views.addAll(EMFCoreUtil.getReferencers((EObject)element, (EReference[])features));
        }
        return views;
    }

    public static List<View> findViews(EObject parserElement, EditPartViewer viewer) {
        ArrayList<View> modelElements = new ArrayList<View>();
        if (parserElement != null) {
            for (Object ep : viewer.getEditPartRegistry().keySet()) {
                View view;
                if (!(ep instanceof View) || !parserElement.equals((view = (View)ep).getElement())) continue;
                modelElements.add(view);
            }
        }
        return modelElements;
    }

    public static List<EditPart> getEditPartsFromSelection(ISelection selection, IDiagramGraphicalViewer viewer) {
        if (selection instanceof StructuredSelection && !selection.isEmpty()) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            ArrayList<View> views = new ArrayList<View>();
            for (Object o : structuredSelection.toList()) {
                if (!(o instanceof EObject)) continue;
                List referencerViews = DiagramEditPartsUtil.getEObjectViews((EObject)o);
                for (Object ro : referencerViews) {
                    if (!(ro instanceof View)) continue;
                    views.add((View)ro);
                }
            }
            if (!views.isEmpty()) {
                ArrayList<EditPart> editParts = new ArrayList<EditPart>();
                for (View view : views) {
                    Object ep = viewer.getEditPartRegistry().get(view);
                    if (!(ep instanceof EditPart)) continue;
                    editParts.add((EditPart)ep);
                }
                if (!editParts.isEmpty()) {
                    return editParts;
                }
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static EditPart getEditPartFromView(View view, EditPart anyEditPart) {
        if (view != null) {
            return (EditPart)anyEditPart.getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }

    public static Diagram findDiagramFromPlugin(AbstractUIPlugin plugin) {
        IEditorPart editor = plugin.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof DiagramEditor) {
            return ((DiagramEditor)editor).getDiagram();
        }
        return null;
    }

    public static Diagram findDiagramFromEditPart(EditPart editPart) {
        Object object = editPart.getModel();
        if (object instanceof View) {
            return ((View)object).getDiagram();
        }
        return null;
    }

    public static void refreshITextAwareEditParts(EditPart editPart) {
        for (Object obj : editPart.getChildren()) {
            if (!(obj instanceof EditPart)) continue;
            DiagramEditPartsUtil.refreshITextAwareEditParts((EditPart)obj);
        }
        if (editPart instanceof ITextAwareEditPart) {
            editPart.refresh();
        }
    }
}

