/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.cdo.core.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.cdo.internal.core.Activator;
import org.eclipse.papyrus.cdo.internal.core.CDOUtils;

public class CDOFunctions {
    private CDOFunctions() {
    }

    public static <F, T> Function<F, T> adapt(Class<? extends T> adapterType) {
        return new AdaptFunction(adapterType);
    }

    public static <T> Function<Resource, T> getRoot(Class<? extends T> rootElementType) {
        return new ResourceRootFunction<T>(rootElementType);
    }

    public static Function<CDOResourceNode, Iterable<CDOResourceNode>> getFolderContents() {
        return new FolderContentsFunction<CDOResourceNode>(CDOResourceNode.class);
    }

    public static <T extends CDOResourceNode> Function<CDOResourceNode, Iterable<T>> getFolderContents(Class<T> nodeType) {
        return new FolderContentsFunction<T>(nodeType);
    }

    public static Function<CDOObject, EObject> getEObject() {
        return GetEObjectFunction.INSTANCE;
    }

    private static final class AdaptFunction<F, T>
    implements Function<F, T> {
        private final Class<? extends T> adapterType;

        AdaptFunction(Class<? extends T> adapterType) {
            this.adapterType = adapterType;
        }

        public T apply(F input) {
            return CDOUtils.adapt(input, this.adapterType);
        }

        public String toString() {
            return String.format("adapt(%s)", this.adapterType.getName());
        }

        public int hashCode() {
            return this.adapterType.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof AdaptFunction && ((AdaptFunction)other).adapterType == this.adapterType;
        }
    }

    private static final class FolderContentsFunction<T extends CDOResourceNode>
    implements Function<CDOResourceNode, Iterable<T>> {
        private final Class<T> nodeType;

        FolderContentsFunction(Class<T> nodeType) {
            this.nodeType = nodeType;
        }

        public Iterable<T> apply(CDOResourceNode input) {
            Iterable<Object> result = input instanceof CDOResourceFolder ? Iterables.filter((Iterable)((CDOResourceFolder)input).getNodes(), this.nodeType) : (input.isRoot() ? Iterables.filter((Iterable)((CDOResource)input).getContents(), this.nodeType) : Collections.emptyList());
            return result;
        }

        public String toString() {
            return String.format("getFolderContents(%s)", this.nodeType.getName());
        }

        public int hashCode() {
            return this.nodeType.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof FolderContentsFunction && ((FolderContentsFunction)other).nodeType == this.nodeType;
        }
    }

    private static final class GetEObjectFunction
    implements Function<CDOObject, EObject> {
        static final GetEObjectFunction INSTANCE = new GetEObjectFunction();

        private GetEObjectFunction() {
        }

        public EObject apply(CDOObject input) {
            return CDOUtil.getEObject((EObject)input);
        }

        public String toString() {
            return "getEObject()";
        }
    }

    private static final class ResourceRootFunction<T>
    implements Function<Resource, T> {
        private final Class<? extends T> rootElementType;

        ResourceRootFunction(Class<? extends T> rootElementType) {
            this.rootElementType = rootElementType;
        }

        public T apply(Resource input) {
            if (!input.isLoaded()) {
                try {
                    input.load(null);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            }
            return (T)Iterables.getFirst((Iterable)Iterables.filter((Iterable)input.getContents(), this.rootElementType), null);
        }

        public String toString() {
            return String.format("getRoot(%s)", this.rootElementType.getName());
        }

        public int hashCode() {
            return this.rootElementType.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof ResourceRootFunction && ((ResourceRootFunction)other).rootElementType == this.rootElementType;
        }
    }
}

