/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl;

import java.io.PrintStream;
import java.sql.Connection;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.IDBConnectionProvider;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBIndexField;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBSchemaVisitor;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.SchemaElementNotFoundException;
import org.eclipse.net4j.db.ddl.delta.IDBSchemaDelta;
import org.eclipse.net4j.internal.db.ddl.DBSchemaElement;
import org.eclipse.net4j.internal.db.ddl.DBTable;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.spi.db.ddl.InternalDBIndex;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBSchema
extends DBSchemaElement
implements InternalDBSchema {
    private static final long serialVersionUID = 1L;
    private static int indexCounter;
    private Map<String, IDBTable> tables = new HashMap<String, IDBTable>();
    private transient boolean locked;

    public DBSchema(String name) {
        super(name);
    }

    public DBSchema(IDBSchema source) {
        super(source.getName());
        IDBTable[] iDBTableArray = source.getTables();
        int n = iDBTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBTable sourceTable = iDBTableArray[n2];
            IDBTable table = this.addTable(sourceTable.getName());
            IDBSchemaElement[] iDBSchemaElementArray = sourceTable.getFields();
            int n3 = iDBSchemaElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IDBField sourceField = iDBSchemaElementArray[n4];
                table.addField(sourceField.getName(), sourceField.getType(), sourceField.getPrecision(), sourceField.getScale(), sourceField.isNotNull());
                ++n4;
            }
            iDBSchemaElementArray = sourceTable.getIndices();
            n3 = iDBSchemaElementArray.length;
            n4 = 0;
            while (n4 < n3) {
                IDBSchemaElement sourceIndex = iDBSchemaElementArray[n4];
                IDBIndex index = table.addIndexEmpty(sourceIndex.getName(), sourceIndex.getType());
                ((InternalDBIndex)index).setOptional(((InternalDBIndex)sourceIndex).isOptional());
                IDBField[] iDBFieldArray = sourceIndex.getFields();
                int n5 = iDBFieldArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    IDBField sourceField = iDBFieldArray[n6];
                    IDBField field = table.getField(sourceField.getPosition());
                    index.addIndexField(field);
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected DBSchema() {
    }

    @Override
    public IDBSchema getWrapper() {
        return (IDBSchema)super.getWrapper();
    }

    @Override
    public IDBSchemaElement.SchemaElementType getSchemaElementType() {
        return IDBSchemaElement.SchemaElementType.SCHEMA;
    }

    @Override
    public IDBSchema getSchema() {
        return this;
    }

    @Override
    public final IDBSchemaElement getParent() {
        return null;
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    @Override
    public final <T extends IDBSchemaElement> T findElement(IDBSchemaElement prototype) {
        IDBSchemaElement.SchemaElementType schemaElementType = prototype.getSchemaElementType();
        switch (schemaElementType) {
            case SCHEMA: {
                return (T)(prototype.equals(this) ? this : null);
            }
            case TABLE: {
                return (T)this.getElement(IDBTable.class, prototype.getName());
            }
            case FIELD: {
                IDBTable table = this.getElement(IDBTable.class, prototype.getParent().getName());
                if (table == null) {
                    return null;
                }
                return (T)table.getElement(IDBField.class, prototype.getName());
            }
            case INDEX: {
                IDBTable table = this.getElement(IDBTable.class, prototype.getParent().getName());
                if (table == null) {
                    return null;
                }
                return (T)table.getElement(IDBIndex.class, prototype.getName());
            }
            case INDEX_FIELD: {
                IDBTable table = this.getElement(IDBTable.class, prototype.getParent().getParent().getName());
                if (table == null) {
                    return null;
                }
                IDBIndex index = table.getElement(IDBIndex.class, prototype.getParent().getName());
                if (index == null) {
                    return null;
                }
                return (T)index.getElement(IDBIndexField.class, prototype.getName());
            }
        }
        throw new IllegalStateException("Illegal schema element type: " + (Object)((Object)schemaElementType));
    }

    @Override
    public IDBTable addTable(String name) throws DBException {
        this.assertUnlocked();
        if (this.tables.containsKey(name)) {
            throw new DBException("IDBTable exists: " + name);
        }
        DBTable table = new DBTable(this, name);
        this.tables.put(table.getName(), table);
        this.resetElements();
        return table;
    }

    @Override
    public IDBTable removeTable(String name) {
        this.assertUnlocked();
        name = DBSchema.name(name);
        IDBTable table = this.tables.remove(name);
        this.resetElements();
        return table;
    }

    @Override
    public final IDBTable getTableSafe(String name) throws SchemaElementNotFoundException {
        IDBTable table = this.getTable(name);
        if (table == null) {
            throw new SchemaElementNotFoundException(this, IDBSchemaElement.SchemaElementType.TABLE, name);
        }
        return table;
    }

    @Override
    public IDBTable getTable(String name) {
        name = DBSchema.name(name);
        return this.tables.get(name);
    }

    @Override
    public IDBTable[] getTables() {
        return this.tables.values().toArray(new IDBTable[this.tables.size()]);
    }

    @Override
    public void remove() {
        this.assertUnlocked();
        this.tables.clear();
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public boolean lock() {
        this.locked = true;
        return true;
    }

    @Override
    public boolean unlock() {
        this.locked = false;
        return false;
    }

    @Override
    public void assertUnlocked() throws DBException {
        if (this.locked) {
            throw new DBException("Schema locked: " + this);
        }
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, Connection connection) throws DBException {
        return dbAdapter.createTables(this.tables.values(), connection);
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        return this.create(dbAdapter, dbAdapter.createConnectionProvider(dataSource));
    }

    @Override
    public Set<IDBTable> create(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            if (connection == null) {
                throw new DBException("No connection available from " + connectionProvider);
            }
            Set<IDBTable> set = this.create(dbAdapter, connection);
            return set;
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Override
    public void drop(IDBAdapter dbAdapter, Connection connection) throws DBException {
        dbAdapter.dropTables(this.tables.values(), connection);
    }

    @Override
    public void drop(IDBAdapter dbAdapter, DataSource dataSource) throws DBException {
        this.drop(dbAdapter, dbAdapter.createConnectionProvider(dataSource));
    }

    @Override
    public void drop(IDBAdapter dbAdapter, IDBConnectionProvider connectionProvider) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            this.drop(dbAdapter, connection);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Override
    public void export(Connection connection, PrintStream out) throws DBException {
        IDBTable[] iDBTableArray = this.getTables();
        int n = iDBTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDBTable table = iDBTableArray[n2];
            this.export(table, connection, out);
            ++n2;
        }
    }

    private void export(final IDBTable table, Connection connection, final PrintStream out) {
        if (DBUtil.select(connection, new IDBRowHandler(){

            public boolean handle(int row, Object ... values) {
                if (row == 0) {
                    String tableName = table.getName();
                    out.println(tableName);
                    int i = 0;
                    while (i < tableName.length()) {
                        out.print("=");
                        ++i;
                    }
                    out.println();
                }
                out.println(Arrays.asList(values));
                return true;
            }
        }, table.getFields()) > 0) {
            out.println();
        }
    }

    @Override
    public void export(DataSource dataSource, PrintStream out) throws DBException {
        this.export(DBUtil.createConnectionProvider(dataSource), out);
    }

    @Override
    public void export(IDBConnectionProvider connectionProvider, PrintStream out) throws DBException {
        Connection connection = null;
        try {
            connection = connectionProvider.getConnection();
            this.export(connection, out);
        }
        finally {
            DBUtil.close(connection);
        }
    }

    @Override
    public IDBSchemaDelta compare(IDBSchema oldSchema) {
        return new DBSchemaDelta(this, oldSchema);
    }

    @Override
    public String createIndexName(IDBTable table, IDBIndex.Type type, IDBField[] fields, int position) {
        return "I" + System.currentTimeMillis() + "_" + ++indexCounter;
    }

    @Override
    protected void collectElements(List<IDBSchemaElement> elements) {
        elements.addAll(this.tables.values());
    }

    @Override
    protected void doAccept(IDBSchemaVisitor visitor) {
        visitor.visit(this);
    }
}

