/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.language;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.editor.ModelSetServiceFactory;
import org.eclipse.papyrus.infra.core.language.ILanguage;
import org.eclipse.papyrus.infra.core.language.ILanguageChangeListener;
import org.eclipse.papyrus.infra.core.language.ILanguageProvider;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;

public interface ILanguageService
extends IAdaptable,
ILanguageChangeListener {
    public Set<ILanguage> getLanguages(URI var1, boolean var2);

    public Set<ILanguage> getLanguages(ModelSet var1);

    public void addLanguageChangeListener(ILanguageChangeListener var1);

    public void removeLanguageChangeListener(ILanguageChangeListener var1);

    public void addLanguageProvider(ILanguageProvider var1);

    public void removeLanguageProvider(ILanguageProvider var1);

    public static Collection<IModel> getLanguageModels(ModelSet modelSet) {
        ILanguageService service = ServiceUtils.getInstance().getService(ILanguageService.class, ModelSetServiceFactory.getServiceRegistry((ResourceSet)modelSet), null);
        List<IModel> result = service == null ? Collections.emptyList() : service.getLanguages(modelSet).stream().map(l -> l.getModel(modelSet)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        return result;
    }
}

