/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.assuranceproject.utils;

import java.util.HashMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssetsPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceProject;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.etl.CDOTransformHandler;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactModel;
import org.eclipse.opencert.pam.procspec.process.ProcessModel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class ImportFromEpfUI
extends Dialog {
    private static final String EVIDENCE_Extension = ".evidence";
    private static final String PROCESS_Extension = ".process";
    private static final String EVIDENCE_Folder = "EVIDENCE";
    private static final String PROCESSES_Folder = "PROCESSES";
    private static final String IMPORT = "Import";
    private static final String CLOSE = "Close";
    protected AssuranceprojectPackage dprojectPackage = AssuranceprojectPackage.eINSTANCE;
    protected AssuranceprojectFactory dprojectFactory = this.dprojectPackage.getAssuranceprojectFactory();
    CDOResourceFolder assuranceprojectFolder;
    CDOResourceFolder evidenceFolder;
    CDOResourceFolder procFolder;
    private IEditorPart editor;
    private URI resourceURI;
    private CDOSession sessionCDO = null;
    private CDOTransaction transaction;
    HashMap<Object, Object> options = new HashMap();
    private static final String UTF_8 = "UTF-8";
    private Label methodLabel;
    private Text methodText;
    private Button methodButton;
    private String methodPath;
    private String methodDirectory;
    private Text configurationText;
    private Label configurationLabel;
    private Button configurationButton;
    private String configurationPath;
    private String configurationDirectory;
    private Label eviLabel;
    private Text eviNameText;
    private Label importedEviModelPath;
    private Label procLabel;
    private Text procNameText;
    private Label importedProcModelPath;

    public ImportFromEpfUI(Shell parentShell) {
        super(parentShell);
        this.options.put("ENCODING", UTF_8);
        this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.resourceURI = EditUIUtil.getURI((IEditorInput)this.editor.getEditorInput());
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        this.sessionCDO = CDOConnectionUtil.instance.openSession();
        this.transaction = this.sessionCDO.openTransaction();
    }

    public ImportFromEpfUI(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText(IMPORT);
        this.setButtonLayoutData(ok);
        Button cancel = this.getButton(1);
        cancel.setText(CLOSE);
        this.setButtonLayoutData(cancel);
    }

    protected Control createDialogArea(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Composite contents = (Composite)super.createDialogArea(parent);
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createSourceDialogArea(contents, adapterFactory);
        this.createTargetDialogArea(contents, adapterFactory);
        return contents;
    }

    protected void createSourceDialogArea(Composite contents, ComposedAdapterFactory adapterFactory) {
        Composite sourceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, false, true);
        data.horizontalAlignment = 0x1000008;
        data.horizontalAlignment = 4;
        sourceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        sourceComposite.setLayout((Layout)layout);
        Group groupSource = new Group(sourceComposite, 0);
        groupSource.setLayoutData((Object)new GridData(4, 4, true, true));
        groupSource.setText("EPF Source Files");
        GridLayout layoutNew = new GridLayout();
        layoutNew.marginHeight = 10;
        layoutNew.marginWidth = 10;
        layoutNew.numColumns = 3;
        groupSource.setLayout((Layout)layoutNew);
        this.methodLabel = new Label((Composite)groupSource, 0);
        this.methodLabel.setText("EPF Method Library:");
        GridData methodLabelGridData = new GridData();
        methodLabelGridData.horizontalAlignment = 4;
        methodLabelGridData.verticalAlignment = 4;
        this.methodLabel.setLayoutData((Object)methodLabelGridData);
        this.methodText = new Text((Composite)groupSource, 2048);
        GridData methodTextGridData = new GridData();
        methodTextGridData.grabExcessHorizontalSpace = true;
        methodTextGridData.minimumWidth = 500;
        methodTextGridData.horizontalAlignment = 4;
        methodTextGridData.verticalAlignment = 4;
        this.methodText.setLayoutData((Object)methodTextGridData);
        this.methodText.setEditable(true);
        this.methodButton = new Button((Composite)groupSource, 0);
        this.methodButton.setText("Browse...");
        this.methodButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(ImportFromEpfUI.this.methodButton.getShell(), 0);
                dlg.setFilterPath(ImportFromEpfUI.this.methodDirectory);
                dlg.setText("Select a EPF Method File");
                String[] methodFilterExt = new String[]{"*.xml"};
                dlg.setFilterExtensions(methodFilterExt);
                ImportFromEpfUI.this.methodPath = dlg.open();
                ImportFromEpfUI.this.methodDirectory = dlg.getFilterPath();
                if (ImportFromEpfUI.this.methodPath != null) {
                    ImportFromEpfUI.this.methodText.setText(ImportFromEpfUI.this.methodPath);
                }
            }
        });
        this.configurationLabel = new Label((Composite)groupSource, 0);
        this.configurationLabel.setText("EPF Process Configuration:");
        GridData configurationLabelGridData = new GridData();
        configurationLabelGridData.horizontalAlignment = 4;
        configurationLabelGridData.verticalAlignment = 4;
        this.configurationLabel.setLayoutData((Object)configurationLabelGridData);
        GridData configurationTextGridData = new GridData();
        configurationTextGridData.grabExcessHorizontalSpace = true;
        configurationTextGridData.minimumWidth = 500;
        configurationTextGridData.horizontalAlignment = 4;
        configurationTextGridData.verticalAlignment = 4;
        this.configurationText = new Text((Composite)groupSource, 2048);
        this.configurationText.setLayoutData((Object)configurationTextGridData);
        this.configurationText.setEditable(true);
        this.configurationButton = new Button((Composite)groupSource, 0);
        this.configurationButton.setText("Browse...");
        this.configurationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(ImportFromEpfUI.this.configurationButton.getShell(), 0);
                dlg.setFilterPath(ImportFromEpfUI.this.methodDirectory);
                dlg.setText("Select a EPF Configuration File");
                String[] configurationFilterExt = new String[]{"*.xml"};
                dlg.setFilterExtensions(configurationFilterExt);
                ImportFromEpfUI.this.configurationPath = dlg.open();
                ImportFromEpfUI.this.configurationDirectory = dlg.getFilterPath();
                String confFileName = dlg.getFileName();
                if (ImportFromEpfUI.this.configurationPath != null) {
                    ImportFromEpfUI.this.configurationText.setText(ImportFromEpfUI.this.configurationPath);
                    ImportFromEpfUI.this.setDefaultTargetModelNames(confFileName);
                }
            }
        });
    }

    protected void setDefaultTargetModelNames(String fileName) {
        String defaultEviName = "";
        String defaultProcName = "";
        defaultEviName = String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + "_Evid";
        defaultProcName = String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + "_Proc";
        this.eviNameText.setText(defaultEviName);
        this.procNameText.setText(defaultProcName);
    }

    protected void createTargetDialogArea(Composite contents, ComposedAdapterFactory adapterFactory) {
        Composite targetComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, false, true);
        data.horizontalAlignment = 0x1000008;
        data.horizontalAlignment = 4;
        targetComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        targetComposite.setLayout((Layout)layout);
        Group groupTarget = new Group(targetComposite, 0);
        groupTarget.setLayoutData((Object)new GridData(4, 4, true, true));
        groupTarget.setText("Imported Models (Evidence and Process models)");
        GridLayout layoutNew = new GridLayout();
        layoutNew.marginHeight = 10;
        layoutNew.marginWidth = 10;
        layoutNew.numColumns = 3;
        groupTarget.setLayout((Layout)layoutNew);
        Label modelLabel = new Label((Composite)groupTarget, 0);
        modelLabel.setText("");
        GridData modelLabelGridData = new GridData();
        modelLabelGridData.horizontalAlignment = 4;
        modelLabelGridData.verticalAlignment = 4;
        modelLabel.setLayoutData((Object)modelLabelGridData);
        Label nameLabel = new Label((Composite)groupTarget, 0);
        nameLabel.setText("Import using Name:");
        GridData nameLabelGridData = new GridData();
        nameLabelGridData.horizontalAlignment = 4;
        nameLabelGridData.verticalAlignment = 4;
        nameLabel.setLayoutData((Object)nameLabelGridData);
        Label importedLabel = new Label((Composite)groupTarget, 0);
        String projectPath = this.resourceURI.path().substring(0, this.resourceURI.path().lastIndexOf("/"));
        projectPath = projectPath.substring(0, projectPath.lastIndexOf("/"));
        importedLabel.setText("Result @" + projectPath);
        GridData importedLabelGridData = new GridData();
        importedLabelGridData.horizontalAlignment = 4;
        importedLabelGridData.verticalAlignment = 4;
        importedLabel.setLayoutData((Object)importedLabelGridData);
        this.eviLabel = new Label((Composite)groupTarget, 0);
        this.eviLabel.setText("EVIDENCE model:");
        GridData eviLabelGridData = new GridData();
        eviLabelGridData.horizontalAlignment = 4;
        eviLabelGridData.verticalAlignment = 4;
        this.eviLabel.setLayoutData((Object)eviLabelGridData);
        this.eviNameText = new Text((Composite)groupTarget, 2048);
        GridData eviNameTextGridData = new GridData();
        eviNameTextGridData.grabExcessHorizontalSpace = true;
        eviNameTextGridData.minimumWidth = 200;
        this.eviNameText.setLayoutData((Object)eviNameTextGridData);
        this.eviNameText.setEditable(true);
        this.importedEviModelPath = new Label((Composite)groupTarget, 2048);
        GridData importedEviModelPathGridData = new GridData();
        importedEviModelPathGridData.grabExcessHorizontalSpace = true;
        importedEviModelPathGridData.minimumWidth = 350;
        importedEviModelPathGridData.horizontalAlignment = 4;
        importedEviModelPathGridData.verticalAlignment = 4;
        this.importedEviModelPath.setLayoutData((Object)importedEviModelPathGridData);
        this.procLabel = new Label((Composite)groupTarget, 0);
        this.procLabel.setText("PROCESS model:");
        GridData procLabelGridData = new GridData();
        procLabelGridData.horizontalAlignment = 4;
        procLabelGridData.verticalAlignment = 4;
        this.procLabel.setLayoutData((Object)procLabelGridData);
        this.procNameText = new Text((Composite)groupTarget, 2048);
        GridData procNameTextGridData = new GridData();
        procNameTextGridData.grabExcessHorizontalSpace = true;
        procNameTextGridData.minimumWidth = 200;
        this.procNameText.setLayoutData((Object)procNameTextGridData);
        this.procNameText.setEditable(true);
        this.importedProcModelPath = new Label((Composite)groupTarget, 2048);
        GridData importedProcModelPathGridData = new GridData();
        importedProcModelPathGridData.grabExcessHorizontalSpace = true;
        importedProcModelPathGridData.minimumWidth = 350;
        importedProcModelPathGridData.horizontalAlignment = 4;
        importedProcModelPathGridData.verticalAlignment = 4;
        this.importedProcModelPath.setLayoutData((Object)importedProcModelPathGridData);
    }

    protected void setImportBottom() {
        if (this.configurationText.getText().length() != 0) {
            this.methodText.getText().length();
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import from EPF");
    }

    protected void okPressed() {
        boolean allOK = true;
        if (this.configurationText.getText().length() == 0 || this.methodText.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"EPF Source Files", (String)"You must select the EPF source files.");
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        dialog.open();
        IProgressMonitor monitor = dialog.getProgressMonitor();
        monitor.beginTask("Import EPF Information", 5);
        monitor.worked(1);
        try {
            this.runImportFromEPF(monitor, this.resourceURI);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        monitor.worked(5);
        monitor.done();
        dialog.close();
        if (allOK) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Import success", (String)"Selected EPF files imported");
            this.getButton(0).setEnabled(false);
        }
    }

    public boolean close() {
        DawnExplorer repoView = null;
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            if ("org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer".equals(viewReferences[i].getId())) {
                repoView = (DawnExplorer)viewReferences[i].getView(false);
                repoView.refreshViewer(false);
                break;
            }
            ++i;
        }
        if (!this.transaction.isClosed()) {
            this.transaction.close();
        }
        return super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImportFromEPF(IProgressMonitor monitor, URI projectModel) throws ExecutionException {
        CDOResource assuranceprojectResource = null;
        String path = projectModel.path();
        path = path.substring(0, path.lastIndexOf("/"));
        this.assuranceprojectFolder = this.transaction.getResourceFolder(path);
        String eviFolderPath = this.assuranceprojectFolder.getPath().substring(0, this.assuranceprojectFolder.getPath().lastIndexOf("/"));
        eviFolderPath = String.valueOf(eviFolderPath) + "/" + EVIDENCE_Folder;
        this.evidenceFolder = this.transaction.getResourceFolder(eviFolderPath);
        String procFolderPath = this.assuranceprojectFolder.getPath().substring(0, this.assuranceprojectFolder.getPath().lastIndexOf("/"));
        procFolderPath = String.valueOf(procFolderPath) + "/" + PROCESSES_Folder;
        this.procFolder = this.transaction.getResourceFolder(procFolderPath);
        URI evidenceModelURI = null;
        URI processModelURI = null;
        CDOResource evidenceModelResource = null;
        CDOResource processModelResource = null;
        evidenceModelResource = this.transaction.getOrCreateResource(String.valueOf(this.evidenceFolder.getPath()) + "/" + this.eviNameText.getText() + EVIDENCE_Extension);
        evidenceModelURI = evidenceModelResource.getURI();
        processModelResource = this.transaction.getOrCreateResource(String.valueOf(this.procFolder.getPath()) + "/" + this.procNameText.getText() + PROCESS_Extension);
        processModelURI = processModelResource.getURI();
        try {
            CDOTransaction cDOTransaction = this.transaction;
            synchronized (cDOTransaction) {
                CDOTransformHandler transfo = new CDOTransformHandler(this.assuranceprojectFolder, this.methodText.getText(), this.configurationText.getText(), evidenceModelResource, processModelResource, this.transaction);
                transfo.execute();
                this.transaction.commit();
                String evidenceSubPath = evidenceModelURI.path().substring(evidenceModelURI.path().indexOf("/") + 1);
                String processSubPath = processModelURI.path().substring(processModelURI.path().indexOf("/") + 1);
                evidenceSubPath = evidenceSubPath.substring(evidenceSubPath.indexOf("/"));
                processSubPath = processSubPath.substring(processSubPath.indexOf("/"));
                this.importedEviModelPath.setText(evidenceSubPath);
                this.importedProcModelPath.setText(processSubPath);
                monitor.worked(4);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.transaction.rollback();
            String msgError = "Issues at importing the model:";
            this.importedEviModelPath.setText(String.valueOf(msgError) + e.getMessage());
            this.importedProcModelPath.setText(String.valueOf(msgError) + e.getMessage());
            monitor.done();
        }
        try {
            assuranceprojectResource = this.transaction.getResource(projectModel.path());
            EList contents = assuranceprojectResource.getContents();
            EObject rootObject = (EObject)contents.get(0);
            AssuranceProject assurproj = (AssuranceProject)rootObject;
            AssetsPackage assPackageconfig = null;
            for (AssetsPackage assetPackage : assurproj.getAssetsPackage()) {
                if (!assetPackage.isIsActive()) continue;
                assPackageconfig = assetPackage;
            }
            CDOResource eviResource = this.transaction.getResource(evidenceModelURI.path());
            EList eviContents = eviResource.getContents();
            EObject eviRootObject = (EObject)eviContents.get(0);
            ArtefactModel eviArtefactModel = (ArtefactModel)eviRootObject;
            assPackageconfig.getArtefactsModel().add((Object)eviArtefactModel);
            CDOResource procResource = this.transaction.getResource(processModelURI.path());
            EList procContents = procResource.getContents();
            EObject procRootObject = (EObject)procContents.get(0);
            ProcessModel procProcessModel = (ProcessModel)procRootObject;
            assPackageconfig.getProcessModel().add((Object)procProcessModel);
            assuranceprojectResource.save(this.options);
            this.transaction.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Models not Linked", (String)"The generated models cannot be linked to the Assurance Project");
            this.transaction.rollback();
            monitor.done();
        }
    }
}

