/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.UnorderedGroup;
import org.eclipse.xtext.generator.LineSeparatorHarmonizer;
import org.eclipse.xtext.parser.antlr.IAntlrTokenFileProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.CodeConfig;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammar;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrGrammarGenUtil;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrOptions;
import org.eclipse.xtext.xtext.generator.parser.antlr.AntlrToolFacade;
import org.eclipse.xtext.xtext.generator.parser.antlr.KeywordHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.MutableTokenDefProvider;
import org.eclipse.xtext.xtext.generator.parser.antlr.postProcessing.SuppressWarningsProcessor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrCodeQualityHelper;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrLexerSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.AntlrParserSplitter;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardForUnorderedGroupsRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.BacktrackingGuardRemover;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.PartialClassExtractor;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.SyntacticPredicateFixup;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.UnorderedGroupsSplitter;

public abstract class AbstractAntlrGeneratorFragment2
extends AbstractXtextGeneratorFragment {
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private AntlrToolFacade antlrTool;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private AntlrCodeQualityHelper codeQualityHelper;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private LineSeparatorHarmonizer newLineNormalizer;
    @Inject
    @Accessors(value={AccessorType.PROTECTED_GETTER})
    private CodeConfig codeConfig;
    @Accessors
    private AntlrOptions options = new AntlrOptions();
    private final ArrayList<String> antlrParams = CollectionLiterals.newArrayList((Object[])new String[0]);

    public void addAntlrParam(String param) {
        this.antlrParams.add(param);
    }

    public String[] getAntlrParams() {
        boolean _not;
        ArrayList params = Lists.newArrayList(this.antlrParams);
        boolean _contains = params.contains("-Xconversiontimeout");
        boolean bl = _not = !_contains;
        if (_not) {
            params.add(0, "-Xconversiontimeout");
            params.add(1, "100000");
        }
        return (String[])Conversions.unwrapArray((Object)params, String.class);
    }

    @Override
    public void checkConfiguration(Issues issues) {
        boolean _not;
        super.checkConfiguration(issues);
        boolean _isWorkable = this.antlrTool.isWorkable();
        boolean bl = _not = !_isWorkable;
        if (_not) {
            issues.addError("\n\n*ATTENTION*\nIt is highly recommended to use ANTLR's parser generator (get it from 'http://xtext.itemis.com/'). \nAs an alternative to ANTLR you could also use the alternative implementation shipped with Xtext.\nTo do so use the generator fragment 'org.eclipse.xtext.generator.parser.packrat.PackratParserFragment' in your mwe2 file instead.");
        }
    }

    @Override
    public void generate() {
        this.checkGrammar();
        this.doGenerate();
    }

    protected abstract void doGenerate();

    protected void checkGrammar() {
        boolean _not;
        Grammar _grammar = this.getGrammar();
        boolean _hasProductionRules = this.hasProductionRules(_grammar);
        boolean bl = _not = !_hasProductionRules;
        if (_not) {
            throw new IllegalArgumentException("You may not generate an ANTLR parser for a grammar without production rules.");
        }
    }

    protected boolean hasProductionRules(Grammar grammar) {
        EList _rules = grammar.getRules();
        AbstractRule firstRule = (AbstractRule)_rules.get(0);
        return firstRule instanceof ParserRule && !GrammarUtil.isDatatypeRule((ParserRule)((ParserRule)firstRule));
    }

    protected void splitLexerClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer) {
        String _javaPath = lexer.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        AntlrLexerSplitter splitter = new AntlrLexerSplitter(content);
        int _casesPerSpecialStateSwitch = this.options.getCasesPerSpecialStateSwitch();
        splitter.setCasesPerSpecialStateSwitch(_casesPerSpecialStateSwitch);
        String _javaPath_1 = lexer.getJavaPath();
        String _transform = splitter.transform();
        fsa.generateFile(_javaPath_1, _transform);
    }

    protected void splitParserClassFile(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String _javaPath = parser.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        AntlrOptions _options = this.getOptions();
        int _fieldsPerClass = _options.getFieldsPerClass();
        AntlrParserSplitter splitter = new AntlrParserSplitter(content, _fieldsPerClass);
        String _transform = splitter.transform();
        AntlrOptions _options_1 = this.getOptions();
        int _methodsPerClass = _options_1.getMethodsPerClass();
        PartialClassExtractor extractor = new PartialClassExtractor(_transform, _methodsPerClass);
        String _javaPath_1 = parser.getJavaPath();
        String _transform_1 = extractor.transform();
        fsa.generateFile(_javaPath_1, _transform_1);
    }

    protected void simplifyUnorderedGroupPredicatesIfRequired(Grammar grammar, IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        if (this.containsUnorderedGroup(grammar) || this.hasParameterizedRules(grammar)) {
            this.simplifyUnorderedGroupPredicates(fsa, parser);
        }
    }

    protected boolean hasParameterizedRules(Grammar grammar) {
        List _allParserRules = GrammarUtil.allParserRules((Grammar)grammar);
        for (ParserRule rule : _allParserRules) {
            boolean _not;
            EList _parameters = rule.getParameters();
            boolean _isEmpty = _parameters.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            return true;
        }
        return false;
    }

    protected void simplifyUnorderedGroupPredicates(IXtextGeneratorFileSystemAccess fsa, TypeReference parser) {
        String _transform;
        String _javaPath = parser.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        UnorderedGroupsSplitter splitter = new UnorderedGroupsSplitter(content);
        String transformed = splitter.transform();
        SyntacticPredicateFixup fixup = new SyntacticPredicateFixup(transformed);
        transformed = _transform = fixup.transform();
        BacktrackingGuardForUnorderedGroupsRemover remover = new BacktrackingGuardForUnorderedGroupsRemover(transformed);
        String newContent = remover.transform();
        String _javaPath_1 = parser.getJavaPath();
        fsa.generateFile(_javaPath_1, newContent);
    }

    protected void suppressWarnings(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String _javaPath = type.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        SuppressWarningsProcessor _suppressWarningsProcessor = new SuppressWarningsProcessor();
        String newContent = _suppressWarningsProcessor.process(content);
        String _javaPath_1 = type.getJavaPath();
        fsa.generateFile(_javaPath_1, newContent);
    }

    protected void suppressWarnings(final IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        Procedures.Procedure1<TypeReference> _function = new Procedures.Procedure1<TypeReference>(){

            public void apply(TypeReference it) {
                AbstractAntlrGeneratorFragment2.this.suppressWarnings(fsa, it);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)types)), (Procedures.Procedure1)_function);
    }

    protected void normalizeLineDelimiters(IXtextGeneratorFileSystemAccess fsa, TypeReference type) {
        String _replaceAll;
        String _string;
        String _javaPath = type.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        String _javaPath_1 = type.getJavaPath();
        URI _uRI = fsa.getURI(_javaPath_1);
        CharSequence _postProcess = this.newLineNormalizer.postProcess(_uRI, (CharSequence)content);
        content = _string = _postProcess.toString();
        content = _replaceAll = content.replaceAll("\"\\+(\\r)?\\n\\s+\"", "");
        String _javaPath_2 = type.getJavaPath();
        fsa.generateFile(_javaPath_2, content);
    }

    protected void normalizeLineDelimiters(final IXtextGeneratorFileSystemAccess fsa, TypeReference ... types) {
        Procedures.Procedure1<TypeReference> _function = new Procedures.Procedure1<TypeReference>(){

            public void apply(TypeReference it) {
                AbstractAntlrGeneratorFragment2.this.normalizeLineDelimiters(fsa, it);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)types)), (Procedures.Procedure1)_function);
    }

    protected void normalizeTokens(IXtextGeneratorFileSystemAccess fsa, String tokenFile) {
        String _plus;
        String _string;
        CharSequence _readTextFile = fsa.readTextFile(tokenFile);
        String content = _readTextFile.toString();
        URI _uRI = fsa.getURI(tokenFile);
        CharSequence _postProcess = this.newLineNormalizer.postProcess(_uRI, (CharSequence)content);
        content = _string = _postProcess.toString();
        String _lineDelimiter = this.codeConfig.getLineDelimiter();
        List splitted = Strings.split((String)content, (String)_lineDelimiter);
        Collections.sort(splitted);
        String _lineDelimiter_1 = this.codeConfig.getLineDelimiter();
        String _concat = Strings.concat((String)_lineDelimiter_1, (List)splitted);
        String _lineDelimiter_2 = this.codeConfig.getLineDelimiter();
        content = _plus = String.valueOf(_concat) + _lineDelimiter_2;
        fsa.generateFile(tokenFile, content);
    }

    protected void splitParserAndLexerIfEnabled(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, TypeReference lexer) {
        this.improveCodeQuality(fsa, lexer, parser);
        AntlrOptions _options = this.getOptions();
        boolean _isClassSplitting = _options.isClassSplitting();
        if (_isClassSplitting) {
            this.splitLexerClassFile(fsa, lexer);
            this.splitParserClassFile(fsa, parser);
        }
    }

    protected void improveCodeQuality(IXtextGeneratorFileSystemAccess fsa, TypeReference lexer, TypeReference parser) {
        String _removeDuplicateDFAs;
        String _removeDuplicateBitsets;
        String _stripUnnecessaryComments_1;
        String _stripUnnecessaryComments;
        String _javaPath = lexer.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String lexerContent = _readTextFile.toString();
        lexerContent = _stripUnnecessaryComments = this.codeQualityHelper.stripUnnecessaryComments(lexerContent, this.options);
        String _javaPath_1 = lexer.getJavaPath();
        fsa.generateFile(_javaPath_1, lexerContent);
        String _javaPath_2 = parser.getJavaPath();
        CharSequence _readTextFile_1 = fsa.readTextFile(_javaPath_2);
        String parserContent = _readTextFile_1.toString();
        parserContent = _stripUnnecessaryComments_1 = this.codeQualityHelper.stripUnnecessaryComments(parserContent, this.options);
        parserContent = _removeDuplicateBitsets = this.codeQualityHelper.removeDuplicateBitsets(parserContent, this.options);
        parserContent = _removeDuplicateDFAs = this.codeQualityHelper.removeDuplicateDFAs(parserContent, this.options);
        String _javaPath_3 = parser.getJavaPath();
        fsa.generateFile(_javaPath_3, parserContent);
    }

    protected void cleanupLexerTokensFile(AntlrGrammar lexerGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            boolean _isBacktrackLexer = this.options.isBacktrackLexer();
            if (_isBacktrackLexer) {
                MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
                Map _tokenDefMap = provider.getTokenDefMap();
                Set _entrySet = _tokenDefMap.entrySet();
                Iterator entries = _entrySet.iterator();
                while (entries.hasNext()) {
                    Map.Entry _next = entries.next();
                    String value = (String)_next.getValue();
                    if (helper.isKeywordRule(value) || value.startsWith("RULE_") || value.startsWith("SUPER_")) continue;
                    entries.remove();
                }
                CharArrayWriter writer = new CharArrayWriter();
                PrintWriter _printWriter = new PrintWriter(writer);
                provider.writeTokenFile(_printWriter);
                String _tokensFileName = lexerGrammar.getTokensFileName();
                char[] _charArray = writer.toCharArray();
                String _string = new String(_charArray);
                fsa.generateFile(_tokensFileName, _string);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected MutableTokenDefProvider createLexerTokensProvider(final AntlrGrammar lexerGrammar, KeywordHelper helper, final IXtextGeneratorFileSystemAccess fsa) {
        String _encoding = this.codeConfig.getEncoding();
        Charset _forName = Charset.forName(_encoding);
        MutableTokenDefProvider provider = new MutableTokenDefProvider(helper, _forName);
        IAntlrTokenFileProvider _function = new IAntlrTokenFileProvider(){

            public InputStream getAntlrTokenFile() {
                String _tokensFileName = lexerGrammar.getTokensFileName();
                return fsa.readBinaryFile(_tokensFileName);
            }
        };
        provider.setAntlrTokenFileProvider(_function);
        return provider;
    }

    protected void cleanupParserTokensFile(AntlrGrammar lexerGrammar, AntlrGrammar parserGrammar, KeywordHelper helper, IXtextGeneratorFileSystemAccess fsa) {
        try {
            MutableTokenDefProvider provider = this.createLexerTokensProvider(lexerGrammar, helper, fsa);
            Map _tokenDefMap = provider.getTokenDefMap();
            Set _entrySet = _tokenDefMap.entrySet();
            for (Map.Entry entry : _entrySet) {
                String value = (String)entry.getValue();
                boolean _isKeywordRule = helper.isKeywordRule(value);
                if (_isKeywordRule) {
                    String _keywordValue = helper.getKeywordValue(value);
                    String keywordAsAntlrString = AntlrGrammarGenUtil.toAntlrString(_keywordValue);
                    entry.setValue("'" + keywordAsAntlrString + "'");
                    continue;
                }
                boolean _startsWith = value.startsWith("'");
                if (!_startsWith) continue;
                String _antlrString = AntlrGrammarGenUtil.toAntlrString(value);
                String _plus = "'" + _antlrString;
                String _plus_1 = String.valueOf(_plus) + "'";
                entry.setValue(_plus_1);
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            PrintWriter _printWriter = new PrintWriter(charArrayWriter);
            provider.writeTokenFile(_printWriter);
            String _tokensFileName = parserGrammar.getTokensFileName();
            char[] _charArray = charArrayWriter.toCharArray();
            String _string = new String(_charArray);
            fsa.generateFile(_tokensFileName, _string);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected void removeBackTrackingGuards(IXtextGeneratorFileSystemAccess fsa, TypeReference parser, int lookaheadThreshold) {
        String _javaPath = parser.getJavaPath();
        CharSequence _readTextFile = fsa.readTextFile(_javaPath);
        String content = _readTextFile.toString();
        BacktrackingGuardRemover remover = new BacktrackingGuardRemover(content, lookaheadThreshold);
        String newContent = remover.transform();
        String _javaPath_1 = parser.getJavaPath();
        fsa.generateFile(_javaPath_1, newContent);
    }

    protected boolean containsUnorderedGroup(Grammar grammar) {
        List _allParserRules = GrammarUtil.allParserRules((Grammar)grammar);
        for (ParserRule rule : _allParserRules) {
            TreeIterator _eAllContents = rule.eAllContents();
            UnmodifiableIterator _filter = Iterators.filter((Iterator)_eAllContents, UnorderedGroup.class);
            boolean _hasNext = _filter.hasNext();
            if (!_hasNext) continue;
            return true;
        }
        return false;
    }

    @Pure
    protected AntlrToolFacade getAntlrTool() {
        return this.antlrTool;
    }

    @Pure
    protected AntlrCodeQualityHelper getCodeQualityHelper() {
        return this.codeQualityHelper;
    }

    @Pure
    protected LineSeparatorHarmonizer getNewLineNormalizer() {
        return this.newLineNormalizer;
    }

    @Pure
    protected CodeConfig getCodeConfig() {
        return this.codeConfig;
    }

    @Pure
    public AntlrOptions getOptions() {
        return this.options;
    }

    public void setOptions(AntlrOptions options) {
        this.options = options;
    }
}

