/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.emf.internal.resource.AbstractCrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.CrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.OnDemandCrossReferenceIndex;

public interface ICrossReferenceIndex {
    public static ICrossReferenceIndex getInstance(ResourceSet resourceSet) {
        AbstractCrossReferenceIndex result = !EcorePlugin.IS_ECLIPSE_RUNNING || Job.getJobManager().isSuspended() ? new OnDemandCrossReferenceIndex(InternalIndexUtil.getSemanticModelFileExtensions(resourceSet)) : CrossReferenceIndex.getInstance();
        return result;
    }

    public static ICrossReferenceIndex getAlternate(ICrossReferenceIndex index, ResourceSet resourceSet) {
        return index instanceof OnDemandCrossReferenceIndex ? null : new OnDemandCrossReferenceIndex(resourceSet);
    }

    public ListenableFuture<SetMultimap<URI, URI>> getOutgoingCrossReferencesAsync();

    public SetMultimap<URI, URI> getOutgoingCrossReferences() throws CoreException;

    public ListenableFuture<Set<URI>> getOutgoingCrossReferencesAsync(URI var1);

    public Set<URI> getOutgoingCrossReferences(URI var1) throws CoreException;

    public ListenableFuture<SetMultimap<URI, URI>> getIncomingCrossReferencesAsync();

    public SetMultimap<URI, URI> getIncomingCrossReferences() throws CoreException;

    public ListenableFuture<Set<URI>> getIncomingCrossReferencesAsync(URI var1);

    public Set<URI> getIncomingCrossReferences(URI var1) throws CoreException;

    public ListenableFuture<Boolean> isShardAsync(URI var1);

    public boolean isShard(URI var1) throws CoreException;

    public ListenableFuture<SetMultimap<URI, URI>> getSubunitsAsync();

    public SetMultimap<URI, URI> getSubunits() throws CoreException;

    public ListenableFuture<Set<URI>> getSubunitsAsync(URI var1);

    public ListenableFuture<Set<URI>> getSubunitsAsync(URI var1, boolean var2);

    public Set<URI> getSubunits(URI var1) throws CoreException;

    public Set<URI> getSubunits(URI var1, boolean var2) throws CoreException;

    public ListenableFuture<Set<URI>> getParentsAsync(URI var1);

    public ListenableFuture<Set<URI>> getParentsAsync(URI var1, boolean var2);

    public Set<URI> getParents(URI var1) throws CoreException;

    public Set<URI> getParents(URI var1, boolean var2) throws CoreException;

    public ListenableFuture<Set<URI>> getRootsAsync(URI var1);

    public ListenableFuture<Set<URI>> getRootsAsync(URI var1, boolean var2);

    public Set<URI> getRoots(URI var1) throws CoreException;

    public Set<URI> getRoots(URI var1, ICrossReferenceIndex var2) throws CoreException;

    public Set<URI> getRoots(URI var1, boolean var2) throws CoreException;

    public Set<URI> getRoots(URI var1, boolean var2, ICrossReferenceIndex var3) throws CoreException;
}

