/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.config;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.config.IAxisCellEditorConfiguration;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.ui.emf.providers.EMFLabelProvider;

public abstract class AbstractCellAxisConfiguration
implements ICellAxisConfiguration,
IAxisCellEditorConfiguration {
    protected static final INattableModelManager getModelManager(IConfigRegistry fromRegistry) {
        return (INattableModelManager)fromRegistry.getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
    }

    protected static final Table getTable(IConfigRegistry fromRegistry) {
        INattableModelManager manager = AbstractCellAxisConfiguration.getModelManager(fromRegistry);
        if (manager == null) {
            return null;
        }
        return manager.getTable();
    }

    @Override
    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        INattableModelManager modelManager = AbstractCellAxisConfiguration.getModelManager(configRegistry);
        Table table = modelManager.getTable();
        String displayMode = this.getDisplayMode(table, axis);
        ICellPainter painter = this.getCellPainter(table, axis);
        ICellEditor editor = this.getICellEditor(table, axis, modelManager.getTableAxisElementProvider());
        IDisplayConverter converter = this.getDisplayConvert(table, axis, (ILabelProvider)new EMFLabelProvider());
        IDataValidator validator = this.getDataValidator(table, axis);
        if (painter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)painter, displayMode, configLabel);
        }
        if (editor != null) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)editor, displayMode, configLabel);
        }
        if (converter != null) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)converter, displayMode, configLabel);
        }
        if (validator != null) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.DATA_VALIDATOR, (Object)validator, displayMode, configLabel);
        }
    }

    @Override
    public IDataValidator getDataValidator(Table table, Object axisElement) {
        return null;
    }

    @Override
    public IDisplayConverter getDisplayConvert(Table table, Object axisElement, ILabelProvider provider) {
        return null;
    }

    @Override
    public String getDisplayMode(Table table, Object axisElement) {
        return "NORMAL";
    }
}

