/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommand;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.print.config.DefaultPrintBindings;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.ColumnResizeEvent;
import org.eclipse.nebula.widgets.nattable.resize.event.RowResizeEvent;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectAllCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectColumnCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectRowsCommand;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.command.UpdateFilterMapCommand;
import org.eclipse.papyrus.infra.nattable.comparator.ObjectNameAndPathComparator;
import org.eclipse.papyrus.infra.nattable.configuration.CellEditorAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.ClearSelectionUIBindingConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.CornerConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.FilterRowAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.FilterRowCustomConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.RowSortModelConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.TableClickSortConfiguration;
import org.eclipse.papyrus.infra.nattable.configuration.TablePopupMenuConfiguration;
import org.eclipse.papyrus.infra.nattable.dataprovider.AbstractCompositeDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.BodyDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.ColumnIndexHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.ColumnLabelHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.CompositeColumnHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.dataprovider.CompositeRowHeaderDataProvider;
import org.eclipse.papyrus.infra.nattable.display.converter.ObjectNameAndPathDisplayConverter;
import org.eclipse.papyrus.infra.nattable.export.file.command.PapyrusFileExportCommand;
import org.eclipse.papyrus.infra.nattable.fillhandle.config.PapyrusFillHandleConfiguration;
import org.eclipse.papyrus.infra.nattable.layer.FilterRowHeaderComposite;
import org.eclipse.papyrus.infra.nattable.layer.PapyrusGridLayer;
import org.eclipse.papyrus.infra.nattable.layerstack.BodyLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.ColumnHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderHierarchicalLayerStack;
import org.eclipse.papyrus.infra.nattable.layerstack.RowHeaderLayerStack;
import org.eclipse.papyrus.infra.nattable.listener.NatTableDropListener;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EObjectAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.EStructuralFeatureAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.FeatureIdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.LocalTableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.IntValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NamedStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringListValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StringValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.Style;
import org.eclipse.papyrus.infra.nattable.provider.PapyrusNatTableToolTipProvider;
import org.eclipse.papyrus.infra.nattable.provider.TableSelectionProvider;
import org.eclipse.papyrus.infra.nattable.provider.TableStructuredSelection;
import org.eclipse.papyrus.infra.nattable.selection.ISelectionExtractor;
import org.eclipse.papyrus.infra.nattable.sort.IPapyrusSortModel;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.DefaultSizeUtils;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.LocationValue;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.nattable.utils.PapyrusTableSizeCalculation;
import org.eclipse.papyrus.infra.nattable.utils.PercentageCalculationUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableGridRegion;
import org.eclipse.papyrus.infra.nattable.utils.TableSelectionWrapper;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.ui.util.EclipseCommandUtils;
import org.eclipse.papyrus.infra.widgets.util.NavigationTarget;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.services.IDisposable;

public abstract class AbstractNattableWidgetManager
implements INattableModelManager,
NavigationTarget,
IAdaptable {
    protected TransactionalEditingDomain contextEditingDomain;
    protected TransactionalEditingDomain tableEditingDomain;
    private Table table;
    private EObject tableContext;
    protected NatTable natTable;
    private GridLayer gridLayer;
    private ColumnHeaderLayerStack columnHeaderLayerStack;
    private RowHeaderLayerStack rowHeaderLayerStack;
    private TableSelectionProvider selectionProvider;
    private IFilterStrategy<Object> filterStrategy;
    private BodyLayerStack bodyLayerStack;
    protected ILayerListener resizeAxisListener;
    private ILayerListener resizeRowHeaderListener;
    private ILayerListener resizeColumnHeaderListener;
    private AbstractCompositeDataProvider columnHeaderDataProvider;
    private AbstractCompositeDataProvider rowHeaderDataProvider;
    private BodyDataProvider bodyDataProvider;
    protected FilterRowHeaderComposite<?> filterColumnHeaderComposite;
    protected IPapyrusSortModel rowSortModel;
    private ISelectionExtractor selectionExtractor;
    private ResourceSetListener resourceSetListener;
    private FilterRowAxisConfiguration filterConfiguration;
    private CellEditorAxisConfiguration cellAxisConfiguration;
    protected DecorationService decorationService;
    private TablePopupMenuConfiguration tablePopupMenuConfiguration;

    public ColumnHeaderLayerStack getColumnHeaderLayerStack() {
        return this.columnHeaderLayerStack;
    }

    public RowHeaderLayerStack getRowHeaderLayerStack() {
        return this.rowHeaderLayerStack;
    }

    public AbstractNattableWidgetManager(Table table, ISelectionExtractor selectionExtractor) {
        this.table = table;
        this.tableContext = table.getContext();
        this.selectionExtractor = selectionExtractor;
        this.tableEditingDomain = TableEditingDomainUtils.getTableEditingDomain(table);
        this.contextEditingDomain = TableEditingDomainUtils.getTableContextEditingDomain(table);
    }

    protected final TransactionalEditingDomain getTableEditingDomain() {
        return this.tableEditingDomain;
    }

    protected final TransactionalEditingDomain getContextEditingDomain() {
        return this.contextEditingDomain;
    }

    @Override
    public NatTable createNattable(Composite parent, int style, IWorkbenchPartSite site) {
        this.bodyDataProvider = new BodyDataProvider(this);
        this.bodyLayerStack = new BodyLayerStack(this.bodyDataProvider, this);
        this.columnHeaderDataProvider = new CompositeColumnHeaderDataProvider(this);
        ColumnIndexHeaderDataProvider indexColumnProvider = new ColumnIndexHeaderDataProvider(this);
        ColumnLabelHeaderDataProvider labelColumnProvider = new ColumnLabelHeaderDataProvider(this);
        this.columnHeaderDataProvider.addDataProvider(indexColumnProvider);
        this.columnHeaderDataProvider.addDataProvider(labelColumnProvider);
        this.columnHeaderLayerStack = new ColumnHeaderLayerStack(this, indexColumnProvider, labelColumnProvider, this.bodyLayerStack, this.getRowSortModel());
        this.rowHeaderLayerStack = this.createRowHeaderLayerStack(this.bodyLayerStack);
        this.rowHeaderDataProvider = new CompositeRowHeaderDataProvider(this);
        this.rowHeaderDataProvider.addDataProvider(this.rowHeaderLayerStack.getIndexDataProvider());
        this.rowHeaderDataProvider.addDataProvider(this.rowHeaderLayerStack.getLabelDataProvider());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)this.columnHeaderDataProvider, (IDataProvider)this.rowHeaderDataProvider);
        this.filterStrategy = this.createFilterStrategy();
        this.filterColumnHeaderComposite = new FilterRowHeaderComposite<Object>(this.filterStrategy, (ILayer)this.columnHeaderLayerStack, this.columnHeaderDataProvider, this);
        this.filterColumnHeaderComposite.setFilterRowVisible(HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.table).isDisplayFilter());
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)this.rowHeaderLayerStack, this.filterColumnHeaderComposite);
        cornerLayer.addConfiguration((IConfiguration)new CornerConfiguration(this));
        this.gridLayer = new PapyrusGridLayer(TransactionUtil.getEditingDomain((EObject)this.tableContext), (ILayer)this.bodyLayerStack, (ILayer)this.filterColumnHeaderComposite, (ILayer)this.rowHeaderLayerStack, (ILayer)cornerLayer);
        this.gridLayer.addConfiguration((IConfiguration)new DefaultPrintBindings());
        this.natTable = new NatTable(parent, (ILayer)this.gridLayer, false);
        this.addClickSortConfiguration(this.natTable);
        this.natTable.addConfiguration((IConfiguration)new FilterRowCustomConfiguration());
        this.natTable.addConfiguration((IConfiguration)new RowSortModelConfiguration(this.getRowSortModel()));
        this.natTable.addConfiguration((IConfiguration)new ClearSelectionUIBindingConfiguration());
        this.natTable.addConfiguration((IConfiguration)new PapyrusFillHandleConfiguration(this.bodyLayerStack.getSelectionLayer(), this));
        IConfigRegistry configRegistry = this.natTable.getConfigRegistry();
        configRegistry.registerConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, (Object)this, "NORMAL", "nattable_model_manager_id");
        configRegistry.registerConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, (Object)this.getContextLabelProviderService(), "NORMAL", "label_provider_service_id");
        ObjectNameAndPathDisplayConverter converter = new ObjectNameAndPathDisplayConverter(this.getContextLabelProviderService());
        configRegistry.registerConfigAttribute(NattableConfigAttributes.OBJECT_NAME_AND_PATH_DISPLAY_CONVERTER, (Object)converter, "NORMAL", "object_name_and_path_display_converter_id");
        configRegistry.registerConfigAttribute(NattableConfigAttributes.OBJECT_NAME_AND_PATH_COMPARATOR, (Object)new ObjectNameAndPathComparator(converter), "NORMAL", "object_name_and_path_comparator_id");
        configRegistry.registerConfigAttribute(NattableConfigAttributes.DECORATION_SERVICE_CONFIG_ATTRIBUTE, (Object)this.getDecorationService(), "NORMAL", "decoration_service_id");
        this.natTable.setConfigRegistry(configRegistry);
        this.natTable.setUiBindingRegistry(new UiBindingRegistry(this.natTable));
        this.selectionProvider = new TableSelectionProvider(this, this.bodyLayerStack.getSelectionLayer());
        if (site != null) {
            site.setSelectionProvider((ISelectionProvider)this.selectionProvider);
        }
        this.registerPopupMenuConfiguration(this.natTable);
        this.natTable.configure();
        this.filterConfiguration = new FilterRowAxisConfiguration();
        this.cellAxisConfiguration = new CellEditorAxisConfiguration();
        this.configureFilters();
        this.configureCellAxisEditor();
        this.initTableAxis();
        this.initTableHeaders();
        this.initTableMerge();
        this.doFillColumnsSize();
        this.addColumnReorderListener(this.bodyLayerStack.getColumnReorderLayer());
        this.addAxisResizeListener(this.bodyLayerStack);
        this.addColumnHeaderResizeListener(this.getColumnHeaderLayerStack());
        this.addRowHeaderResizeListener(this.getRowHeaderLayerStack());
        this.addDragAndDropSupport(this.natTable);
        new PapyrusNatTableToolTipProvider(this.natTable, "BODY", "COLUMN_HEADER", "ROW_HEADER");
        this.initResourceSetListener();
        return this.natTable;
    }

    protected void registerPopupMenuConfiguration(NatTable natTable) {
        this.tablePopupMenuConfiguration = new TablePopupMenuConfiguration(natTable);
        natTable.addConfiguration((IConfiguration)this.tablePopupMenuConfiguration);
    }

    protected void addClickSortConfiguration(NatTable natTable) {
        natTable.addConfiguration((IConfiguration)new TableClickSortConfiguration());
    }

    protected abstract IFilterStrategy<Object> createFilterStrategy();

    private void initResourceSetListener() {
        this.resourceSetListener = new ResourceSetListener(){

            public org.eclipse.emf.common.command.Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
                return null;
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                for (final Notification notification : event.getNotifications()) {
                    Table notifiedTable = AbstractNattableWidgetManager.findTable(notification);
                    if (!AbstractNattableWidgetManager.this.getTable().equals(notifiedTable)) continue;
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Object notifier = notification.getNotifier();
                            Object feature = notification.getFeature();
                            Object newValue = notification.getNewValue();
                            Object oldValue = notification.getOldValue();
                            if (notifier instanceof LocalTableHeaderAxisConfiguration) {
                                boolean onColumnOnModel = AbstractNattableWidgetManager.this.getTable().getLocalColumnHeaderAxisConfiguration() == notifier;
                                boolean isInverted = AbstractNattableWidgetManager.this.table.isInvertAxis();
                                if (feature == NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayFilter() && newValue instanceof Boolean && (onColumnOnModel && !isInverted || !onColumnOnModel && isInverted)) {
                                    (this).AbstractNattableWidgetManager.this.filterColumnHeaderComposite.setFilterRowVisible((Boolean)newValue);
                                    (this).AbstractNattableWidgetManager.this.natTable.refresh();
                                }
                            } else if (notifier instanceof Table && feature == NattablePackage.eINSTANCE.getTable_InvertAxis()) {
                                (this).AbstractNattableWidgetManager.this.filterColumnHeaderComposite.setFilterRowVisible(HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(AbstractNattableWidgetManager.this.getTable()).isDisplayFilter());
                                (this).AbstractNattableWidgetManager.this.natTable.refresh();
                            } else if (notifier instanceof IAxis || notifier instanceof StringValueStyle || notifier instanceof StringListValueStyle) {
                                EObject container;
                                boolean refreshFilter = false;
                                IAxis axisToRefresh = null;
                                if (notifier instanceof IAxis) {
                                    axisToRefresh = (IAxis)notifier;
                                    if (oldValue instanceof NamedStyle && "filterValueToMatch".equals(((NamedStyle)oldValue).getName())) {
                                        refreshFilter = true;
                                    } else if (newValue instanceof NamedStyle && "filterValueToMatch".equals(((NamedStyle)newValue).getName())) {
                                        refreshFilter = true;
                                    }
                                }
                                if ((notifier instanceof StringValueStyle || notifier instanceof StringListValueStyle) && "filterValueToMatch".equals(((NamedStyle)notifier).getName()) && (container = ((NamedStyle)notifier).eContainer()) instanceof IAxis) {
                                    axisToRefresh = (IAxis)container;
                                    refreshFilter = true;
                                }
                                if (refreshFilter && axisToRefresh != null) {
                                    int index = -1;
                                    if (AbstractNattableWidgetManager.this.table.isInvertAxis() && AbstractNattableWidgetManager.this.getRowElementsList().contains(axisToRefresh)) {
                                        index = AbstractNattableWidgetManager.this.getRowElementsList().indexOf(axisToRefresh);
                                    } else if (!AbstractNattableWidgetManager.this.table.isInvertAxis() && AbstractNattableWidgetManager.this.getColumnElementsList().contains(axisToRefresh)) {
                                        index = AbstractNattableWidgetManager.this.getColumnElementsList().indexOf(axisToRefresh);
                                    }
                                    if (index != -1) {
                                        (this).AbstractNattableWidgetManager.this.filterColumnHeaderComposite.doCommand((ILayerCommand)new UpdateFilterMapCommand(index));
                                    }
                                }
                            }
                        }
                    });
                }
            }

            public boolean isPrecommitOnly() {
                return false;
            }

            public boolean isPostcommitOnly() {
                return false;
            }

            public boolean isAggregatePrecommitListener() {
                return false;
            }

            public NotificationFilter getFilter() {
                return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)3)).or(NotificationFilter.createEventTypeFilter((int)4)).and(NotificationFilter.createNotifierTypeFilter(BooleanValueStyle.class).or(NotificationFilter.createNotifierTypeFilter(IntValueStyle.class)).or(NotificationFilter.createNotifierTypeFilter(Style.class)).or(NotificationFilter.createNotifierTypeFilter(EObjectAxis.class)).or(NotificationFilter.createNotifierTypeFilter(FeatureIdAxis.class)).or(NotificationFilter.createNotifierTypeFilter(EStructuralFeatureAxis.class)).or(NotificationFilter.createNotifierTypeFilter(LocalTableHeaderAxisConfiguration.class)).or(NotificationFilter.createNotifierTypeFilter(Table.class)));
            }
        };
        if (this.tableEditingDomain != null) {
            this.tableEditingDomain.addResourceSetListener(this.resourceSetListener);
        }
    }

    protected static Table findTable(Notification notification) {
        if (notification.getNotifier() instanceof Table) {
            return (Table)notification.getNotifier();
        }
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            EObject container = ((EObject)notifier).eContainer();
            while (!(container instanceof Table) && container != null) {
                container = container.eContainer();
            }
            return (Table)container;
        }
        return null;
    }

    protected RowHeaderLayerStack createRowHeaderLayerStack(BodyLayerStack bodyLayerStack) {
        return new RowHeaderLayerStack(bodyLayerStack, this);
    }

    protected final void configureCellAxisEditor() {
        this.cellAxisConfiguration.configureRegistry(this.natTable.getConfigRegistry());
    }

    protected final void configureFilters() {
        this.filterConfiguration.configureRegistry(this.natTable.getConfigRegistry());
    }

    private LabelProviderService getContextLabelProviderService() {
        try {
            ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.table.getContext());
            return (LabelProviderService)serviceRegistry.getService(LabelProviderService.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    protected DecorationService getDecorationService() {
        if (this.decorationService == null && this.table.getContext().eResource() != null) {
            try {
                ServicesRegistry serviceRegistry = ServiceUtilsForEObject.getInstance().getServiceRegistry(this.table.getContext());
                return (DecorationService)serviceRegistry.getService(DecorationService.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return this.decorationService;
    }

    @Deprecated
    public MenuManager createMenuManager(NatTable natTable) {
        return this.createAndRegisterMenuManagerAndSelectionProvider(natTable, null, this.selectionProvider);
    }

    public MenuManager createAndRegisterMenuManagerAndSelectionProvider(NatTable natTable, IWorkbenchPartSite site, ISelectionProvider selectionProvider) {
        MenuManager menuManager = new MenuManager("#PopUp", "org.eclipse.papyrus.infra.nattable.widget.menu");
        menuManager.add((IContributionItem)new GroupMarker("additions"));
        menuManager.setRemoveAllWhenShown(true);
        return menuManager;
    }

    protected void addDragAndDropSupport(NatTable nattable) {
        int operations = 19;
        DropTarget target = new DropTarget((Control)nattable, 19);
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        LocalSelectionTransfer localSelectionTransfer = LocalSelectionTransfer.getTransfer();
        Transfer[] types = new Transfer[]{localSelectionTransfer, localTransfer};
        target.setTransfer(types);
        NatTableDropListener dropListener = this.createDropListener();
        target.addDropListener((DropTargetListener)dropListener);
    }

    protected NatTableDropListener createDropListener() {
        return new NatTableDropListener(this, this.selectionExtractor);
    }

    private void addColumnReorderListener(ColumnReorderLayer columnReorderLayer) {
        columnReorderLayer.addLayerListener(new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ColumnReorderEvent) {
                    ColumnReorderEvent columnReorderEvent = (ColumnReorderEvent)event;
                    int start = -1;
                    int end = columnReorderEvent.getBeforeToColumnPosition();
                    Iterator iterator = columnReorderEvent.getBeforeFromColumnPositionRanges().iterator();
                    if (iterator.hasNext()) {
                        Range range = (Range)iterator.next();
                        start = range.start;
                    }
                    if (start != -1) {
                        IAxis axisToMove;
                        EList allAxis = AbstractNattableWidgetManager.this.getColumnAxisManager().getRepresentedContentProvider().getAxis();
                        if (start >= 0 && start < end && columnReorderEvent.isReorderToLeftEdge()) {
                            --end;
                        }
                        if ((axisToMove = (IAxis)allAxis.get(start)) != null) {
                            AbstractNattableWidgetManager.this.moveColumnElement(axisToMove, end);
                        }
                    }
                }
            }
        });
    }

    protected void addAxisResizeListener(BodyLayerStack bodyLayerStack) {
        this.resizeAxisListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ColumnResizeEvent || event instanceof RowResizeEvent) {
                    int newRowSize;
                    int resizedRowPosition;
                    ICommand cmd;
                    CompositeCommand resizeCommand = new CompositeCommand("resize IAxis' width or height");
                    TransactionalEditingDomain tableDomain = TableEditingDomainUtils.getTableEditingDomain(AbstractNattableWidgetManager.this.table);
                    if (tableDomain == null) {
                        return;
                    }
                    if (event instanceof ColumnResizeEvent) {
                        int resizedColumnPosition = AbstractNattableWidgetManager.this.getRangeStart(event);
                        int newColumnSize = AbstractNattableWidgetManager.this.getBodyLayerStack().getBodyDataLayer().getColumnWidthByPosition(resizedColumnPosition);
                        if (AbstractNattableWidgetManager.this.isColumnWidthAsPercentage()) {
                            ICommand cmd2;
                            int parentSize;
                            int columnsSize;
                            int currentPercentage;
                            int columnSizePercentage = AbstractNattableWidgetManager.this.getInitialColumnWidthPercentage();
                            Composite parent = AbstractNattableWidgetManager.this.natTable.getParent();
                            if (parent != null && !parent.isDisposed() && (currentPercentage = Math.round((float)newColumnSize * 100.0f / (float)(columnsSize = (parentSize = parent.getSize().x) - PapyrusTableSizeCalculation.getRowHeaderWidth(AbstractNattableWidgetManager.this)))) != columnSizePercentage && (cmd2 = AbstractNattableWidgetManager.this.createSetColumnSizeCommand(resizedColumnPosition, currentPercentage)) != null && cmd2.canExecute()) {
                                resizeCommand.add((IUndoableOperation)cmd2);
                            }
                        } else {
                            ICommand cmd3 = AbstractNattableWidgetManager.this.createSetColumnSizeCommand(resizedColumnPosition, newColumnSize);
                            if (cmd3 != null && cmd3.canExecute()) {
                                resizeCommand.add((IUndoableOperation)cmd3);
                            }
                        }
                    } else if (event instanceof RowResizeEvent && (cmd = AbstractNattableWidgetManager.this.createSetRowSizeCommand(resizedRowPosition = AbstractNattableWidgetManager.this.getRangeStart(event), newRowSize = AbstractNattableWidgetManager.this.rowHeaderLayerStack.getRowHeightByPosition(resizedRowPosition))) != null && cmd.canExecute()) {
                        resizeCommand.add((IUndoableOperation)cmd);
                    }
                    if (!resizeCommand.isEmpty()) {
                        tableDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper((ICommand)resizeCommand));
                    }
                }
            }
        };
        bodyLayerStack.addLayerListener(this.resizeAxisListener);
    }

    protected int getInitialColumnWidthPercentage() {
        int remainingPercentage = 100;
        int numberColumnWithoutDefinedWidth = 0;
        BooleanValueStyle saveColumnsWidth = (BooleanValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "saveColumnsWidth");
        if (saveColumnsWidth == null) {
            TableConfiguration config = this.getTable().getTableConfiguration();
            saveColumnsWidth = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "saveColumnsWidth");
        }
        EList notationColumnsAxisList = this.getTable().getCurrentColumnAxisProvider().getAxis();
        int index = 0;
        while (index < notationColumnsAxisList.size()) {
            IAxis currentColumnAxis = (IAxis)notationColumnsAxisList.get(index);
            if (!this.getTable().isInvertAxis()) {
                int axisWidth = this.getBodyLayerStack().getBodyDataLayer().getColumnWidthByPosition(index);
                IntValueStyle value = (IntValueStyle)currentColumnAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisWidth");
                if (value != null && (saveColumnsWidth == null || saveColumnsWidth != null && saveColumnsWidth.isBooleanValue())) {
                    remainingPercentage -= axisWidth;
                } else {
                    ++numberColumnWithoutDefinedWidth;
                }
            }
            ++index;
        }
        if (numberColumnWithoutDefinedWidth == 0) {
            numberColumnWithoutDefinedWidth = 1;
        }
        return Math.round(remainingPercentage / numberColumnWithoutDefinedWidth);
    }

    private ICommand createSetColumnSizeCommand(int resizedColumnPosition, int newColumnWidth) {
        IAxis currentColumnIAxis;
        CompositeCommand compositeResizeCommand = new CompositeCommand("Resize Column");
        Object currentColumnObject = this.getColumnElement(resizedColumnPosition);
        if (currentColumnObject instanceof IAxis && (currentColumnIAxis = (IAxis)currentColumnObject).eContainer() != null) {
            IntValueStyle value = (IntValueStyle)currentColumnIAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisWidth");
            if (value != null && value.getIntValue() != newColumnWidth) {
                SetRequest resizeColumnRequest = new SetRequest(this.getTableEditingDomain(), (EObject)value, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newColumnWidth);
                compositeResizeCommand.add((IUndoableOperation)new SetValueCommand(resizeColumnRequest));
            } else if (value == null && newColumnWidth != DefaultSizeUtils.getDefaultCellWidth()) {
                value = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                value.setIntValue(newColumnWidth);
                value.setName("axisWidth");
                SetRequest initColumnSizeRequest = new SetRequest(this.getTableEditingDomain(), (EObject)currentColumnIAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)value);
                compositeResizeCommand.add((IUndoableOperation)new SetValueCommand(initColumnSizeRequest));
            }
        }
        if (!compositeResizeCommand.isEmpty()) {
            BooleanValueStyle fillColumnsSize = (BooleanValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize");
            if (fillColumnsSize == null) {
                TableConfiguration config = this.getTable().getTableConfiguration();
                fillColumnsSize = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize");
            }
            if (fillColumnsSize != null && fillColumnsSize.isBooleanValue()) {
                SetRequest fillColumnSizeRequest = new SetRequest(this.getTableEditingDomain(), (EObject)fillColumnsSize, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                compositeResizeCommand.add((IUndoableOperation)new SetValueCommand(fillColumnSizeRequest));
            }
        }
        return compositeResizeCommand;
    }

    private ICommand createSetRowSizeCommand(int resizedRowPosition, int newRowHeight) {
        IAxis currentRowIAxis;
        SetValueCommand resizeCommand = null;
        Object currentRowObject = this.getRowElement(resizedRowPosition);
        if (currentRowObject instanceof IAxis && (currentRowIAxis = (IAxis)currentRowObject).eContainer() != null) {
            IntValueStyle value = (IntValueStyle)currentRowIAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisHeight");
            if (value != null && value.getIntValue() != newRowHeight) {
                SetRequest resizeRowRequest = new SetRequest(this.getTableEditingDomain(), (EObject)value, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newRowHeight);
                resizeCommand = new SetValueCommand(resizeRowRequest);
            } else if (value == null && newRowHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                value = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                value.setIntValue(newRowHeight);
                value.setName("axisHeight");
                SetRequest initRowSizeRequest = new SetRequest(this.getTableEditingDomain(), (EObject)currentRowIAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)value);
                resizeCommand = new SetValueCommand(initRowSizeRequest);
            }
        }
        return resizeCommand;
    }

    private int getRangeStart(ILayerEvent event) {
        ColumnResizeEvent resizeEvent;
        int start = -1;
        if (event instanceof ColumnResizeEvent) {
            resizeEvent = (ColumnResizeEvent)event;
            for (Range current : resizeEvent.getColumnPositionRanges()) {
                start = current.start;
            }
        }
        if (event instanceof RowResizeEvent) {
            resizeEvent = (RowResizeEvent)event;
            for (Range current : resizeEvent.getRowPositionRanges()) {
                start = current.start;
            }
        }
        return start;
    }

    private void addColumnHeaderResizeListener(final ColumnHeaderLayerStack columnHeaderLayerStack) {
        this.resizeColumnHeaderListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof RowResizeEvent) {
                    int newHeaderIndexHeight = columnHeaderLayerStack.getColumnIndexDataLayer().getRowHeightByPosition(0);
                    int newHeaderLabelHeight = columnHeaderLayerStack.getColumnLabelDataLayer().getRowHeightByPosition(0);
                    int resizedHeaderPosition = AbstractNattableWidgetManager.this.getRangeStart(event);
                    if (resizedHeaderPosition != -1) {
                        SetRequest initLocalColumnHeaderAxis;
                        TableHeaderAxisConfiguration columnHeaderAxis;
                        EReference localHeaderFeature;
                        CompositeCommand resizeColumnHeaderCommand = new CompositeCommand("resize ColumnHeader's height");
                        TransactionalEditingDomain tableDomain = TableEditingDomainUtils.getTableEditingDomain(AbstractNattableWidgetManager.this.table);
                        LocalTableHeaderAxisConfiguration localColumnHeaderAxis = null;
                        if (!AbstractNattableWidgetManager.this.getTable().isInvertAxis()) {
                            if (AbstractNattableWidgetManager.this.getTable().getLocalColumnHeaderAxisConfiguration() != null) {
                                localColumnHeaderAxis = AbstractNattableWidgetManager.this.getTable().getLocalColumnHeaderAxisConfiguration();
                            } else if (newHeaderIndexHeight != DefaultSizeUtils.getDefaultCellHeight() || newHeaderLabelHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                                localHeaderFeature = null;
                                columnHeaderAxis = AbstractNattableWidgetManager.this.getTable().getTableConfiguration().getColumnHeaderAxisConfiguration();
                                localColumnHeaderAxis = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration(columnHeaderAxis);
                                localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
                                initLocalColumnHeaderAxis = new SetRequest(tableDomain, (EObject)AbstractNattableWidgetManager.this.table, (EStructuralFeature)localHeaderFeature, (Object)localColumnHeaderAxis);
                                IElementEditService localColumnHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((Object)AbstractNattableWidgetManager.this.table);
                                resizeColumnHeaderCommand.add((IUndoableOperation)localColumnHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalColumnHeaderAxis));
                            }
                        } else if (AbstractNattableWidgetManager.this.getTable().getLocalRowHeaderAxisConfiguration() != null) {
                            localColumnHeaderAxis = AbstractNattableWidgetManager.this.getTable().getLocalRowHeaderAxisConfiguration();
                        } else if (newHeaderIndexHeight != DefaultSizeUtils.getDefaultCellHeight() || newHeaderLabelHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                            localHeaderFeature = null;
                            columnHeaderAxis = AbstractNattableWidgetManager.this.getTable().getTableConfiguration().getRowHeaderAxisConfiguration();
                            localColumnHeaderAxis = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration(columnHeaderAxis);
                            localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
                            initLocalColumnHeaderAxis = new SetRequest(tableDomain, (EObject)AbstractNattableWidgetManager.this.table, (EStructuralFeature)localHeaderFeature, (Object)localColumnHeaderAxis);
                            IElementEditService localColumnHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((Object)AbstractNattableWidgetManager.this.table);
                            resizeColumnHeaderCommand.add((IUndoableOperation)localColumnHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalColumnHeaderAxis));
                        }
                        if (localColumnHeaderAxis != null && !localColumnHeaderAxis.isDisplayIndex()) {
                            ++resizedHeaderPosition;
                        }
                        if (resizedHeaderPosition == 0 && localColumnHeaderAxis != null) {
                            SetValueCommand resizeColumnHeaderIndexCommand;
                            IntValueStyle valueIndex = (IntValueStyle)localColumnHeaderAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "columnIndexHeight");
                            if (valueIndex != null && valueIndex.getIntValue() != newHeaderIndexHeight) {
                                SetRequest resizeRowHeaderIndex = new SetRequest(tableDomain, (EObject)valueIndex, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderIndexHeight);
                                resizeColumnHeaderIndexCommand = new SetValueCommand(resizeRowHeaderIndex);
                                resizeColumnHeaderCommand.add((IUndoableOperation)resizeColumnHeaderIndexCommand);
                            } else if (valueIndex == null && newHeaderIndexHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                                valueIndex = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                                valueIndex.setIntValue(newHeaderIndexHeight);
                                valueIndex.setName("columnIndexHeight");
                                SetRequest initRowHeaderIndexSizeRequest = new SetRequest(tableDomain, (EObject)localColumnHeaderAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueIndex);
                                resizeColumnHeaderIndexCommand = new SetValueCommand(initRowHeaderIndexSizeRequest);
                                resizeColumnHeaderCommand.add((IUndoableOperation)resizeColumnHeaderIndexCommand);
                            }
                        }
                        if (resizedHeaderPosition == 1 && localColumnHeaderAxis != null) {
                            SetValueCommand resizeRowHeaderLabelCommand;
                            IntValueStyle valueLabel = (IntValueStyle)localColumnHeaderAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "columnLabelHeight");
                            if (valueLabel != null && valueLabel.getIntValue() != newHeaderLabelHeight) {
                                SetRequest resizeRowHeaderLabel = new SetRequest(tableDomain, (EObject)valueLabel, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderLabelHeight);
                                resizeRowHeaderLabelCommand = new SetValueCommand(resizeRowHeaderLabel);
                                resizeColumnHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                            } else if (valueLabel == null && newHeaderLabelHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                                valueLabel = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                                valueLabel.setIntValue(newHeaderLabelHeight);
                                valueLabel.setName("columnLabelHeight");
                                SetRequest initRowHeaderLabelSizeRequest = new SetRequest(tableDomain, (EObject)localColumnHeaderAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueLabel);
                                resizeRowHeaderLabelCommand = new SetValueCommand(initRowHeaderLabelSizeRequest);
                                resizeColumnHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                            }
                        }
                        if (resizeColumnHeaderCommand.canExecute() && !resizeColumnHeaderCommand.isEmpty()) {
                            tableDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper((ICommand)resizeColumnHeaderCommand));
                        }
                    }
                }
            }
        };
        columnHeaderLayerStack.addLayerListener(this.resizeColumnHeaderListener);
    }

    private void addRowHeaderResizeListener(final RowHeaderLayerStack rowHeaderLayerStack) {
        this.resizeRowHeaderListener = new ILayerListener(){

            public void handleLayerEvent(ILayerEvent event) {
                if (event instanceof ColumnResizeEvent) {
                    int resizedHeaderPosition = AbstractNattableWidgetManager.this.getRangeStart(event);
                    boolean isLocalRowHeaderAxisCreation = false;
                    if (resizedHeaderPosition != -1) {
                        IElementEditService localRowHeaderAxisProvider;
                        SetRequest initLocalRowHeaderAxis;
                        TableHeaderAxisConfiguration rowHeaderAxis;
                        EReference localHeaderFeature;
                        CompositeCommand resizeRowHeaderCommand = new CompositeCommand("resize RowHeader's width");
                        TransactionalEditingDomain tableDomain = TableEditingDomainUtils.getTableEditingDomain(AbstractNattableWidgetManager.this.table);
                        if (tableDomain == null) {
                            return;
                        }
                        LocalTableHeaderAxisConfiguration localRowHeaderAxis = null;
                        if (!AbstractNattableWidgetManager.this.getTable().isInvertAxis()) {
                            if (AbstractNattableWidgetManager.this.getTable().getLocalRowHeaderAxisConfiguration() != null) {
                                localRowHeaderAxis = AbstractNattableWidgetManager.this.getTable().getLocalRowHeaderAxisConfiguration();
                            } else {
                                localHeaderFeature = null;
                                rowHeaderAxis = AbstractNattableWidgetManager.this.getTable().getTableConfiguration().getRowHeaderAxisConfiguration();
                                localRowHeaderAxis = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration(rowHeaderAxis);
                                localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
                                initLocalRowHeaderAxis = new SetRequest(tableDomain, (EObject)AbstractNattableWidgetManager.this.table, (EStructuralFeature)localHeaderFeature, (Object)localRowHeaderAxis);
                                localRowHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((Object)AbstractNattableWidgetManager.this.table);
                                resizeRowHeaderCommand.add((IUndoableOperation)localRowHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalRowHeaderAxis));
                                isLocalRowHeaderAxisCreation = true;
                            }
                        } else if (AbstractNattableWidgetManager.this.getTable().getLocalColumnHeaderAxisConfiguration() != null) {
                            localRowHeaderAxis = AbstractNattableWidgetManager.this.getTable().getLocalColumnHeaderAxisConfiguration();
                        } else {
                            localHeaderFeature = null;
                            rowHeaderAxis = AbstractNattableWidgetManager.this.getTable().getTableConfiguration().getColumnHeaderAxisConfiguration();
                            localRowHeaderAxis = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration(rowHeaderAxis);
                            localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalColumnHeaderAxisConfiguration();
                            initLocalRowHeaderAxis = new SetRequest(tableDomain, (EObject)AbstractNattableWidgetManager.this.table, (EStructuralFeature)localHeaderFeature, (Object)localRowHeaderAxis);
                            localRowHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((Object)AbstractNattableWidgetManager.this.table);
                            resizeRowHeaderCommand.add((IUndoableOperation)localRowHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalRowHeaderAxis));
                            isLocalRowHeaderAxisCreation = true;
                        }
                        if (localRowHeaderAxis != null) {
                            if (!localRowHeaderAxis.isDisplayIndex()) {
                                ++resizedHeaderPosition;
                            }
                            if (resizedHeaderPosition > 0 && rowHeaderLayerStack instanceof RowHeaderHierarchicalLayerStack) {
                                --resizedHeaderPosition;
                                resizedHeaderPosition = ((RowHeaderHierarchicalLayerStack)rowHeaderLayerStack).getRowHeaderLayerLabel().getColumnIndexByPosition(resizedHeaderPosition);
                                ++resizedHeaderPosition;
                            }
                            if (resizedHeaderPosition == 0 && localRowHeaderAxis != null) {
                                SetValueCommand resizeRowHeaderIndexCommand;
                                int newHeaderIndexWidth = rowHeaderLayerStack.getRowIndexDataLayer().getColumnWidthByPosition(0);
                                IntValueStyle valueIndex = (IntValueStyle)localRowHeaderAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowIndexWidth");
                                if (valueIndex != null && valueIndex.getIntValue() != newHeaderIndexWidth) {
                                    SetRequest resizeRowHeaderIndex = new SetRequest(tableDomain, (EObject)valueIndex, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderIndexWidth);
                                    resizeRowHeaderIndexCommand = new SetValueCommand(resizeRowHeaderIndex);
                                    resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderIndexCommand);
                                } else if (valueIndex == null && newHeaderIndexWidth != DefaultSizeUtils.getDefaultRowHeaderWidth()) {
                                    valueIndex = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                                    valueIndex.setIntValue(newHeaderIndexWidth);
                                    valueIndex.setName("rowIndexWidth");
                                    SetRequest initRowHeaderIndexSizeRequest = new SetRequest(tableDomain, (EObject)localRowHeaderAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueIndex);
                                    resizeRowHeaderIndexCommand = new SetValueCommand(initRowHeaderIndexSizeRequest);
                                    resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderIndexCommand);
                                }
                            }
                            if (1 <= resizedHeaderPosition && localRowHeaderAxis != null) {
                                int newHeaderLabelWidth = rowHeaderLayerStack.getRowLabelDataLayer().getColumnWidthByPosition(resizedHeaderPosition - 1);
                                if (1 == resizedHeaderPosition) {
                                    SetValueCommand resizeRowHeaderLabelCommand;
                                    IntValueStyle valueLabel = (IntValueStyle)localRowHeaderAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowLabelWidth");
                                    if (valueLabel != null && valueLabel.getIntValue() != newHeaderLabelWidth) {
                                        SetRequest resizeRowHeaderLabel = new SetRequest(tableDomain, (EObject)valueLabel, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderLabelWidth);
                                        resizeRowHeaderLabelCommand = new SetValueCommand(resizeRowHeaderLabel);
                                        resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                                    } else if (valueLabel == null && newHeaderLabelWidth != DefaultSizeUtils.getDefaultRowHeaderWidth()) {
                                        valueLabel = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                                        valueLabel.setIntValue(newHeaderLabelWidth);
                                        valueLabel.setName("rowLabelWidth");
                                        SetRequest initRowHeaderLabelSizeRequest = new SetRequest(tableDomain, (EObject)localRowHeaderAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueLabel);
                                        resizeRowHeaderLabelCommand = new SetValueCommand(initRowHeaderLabelSizeRequest);
                                        resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                                    }
                                } else {
                                    StringBuilder nameStyle = new StringBuilder("rowPosition");
                                    nameStyle.append(resizedHeaderPosition);
                                    nameStyle.append("LabelWidth");
                                    IntValueStyle valueLabel = (IntValueStyle)localRowHeaderAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), nameStyle.toString());
                                    if (valueLabel != null && valueLabel.getIntValue() != newHeaderLabelWidth) {
                                        SetRequest resizeRowHeaderLabel = new SetRequest(tableDomain, (EObject)valueLabel, (EStructuralFeature)NattablestylePackage.eINSTANCE.getIntValueStyle_IntValue(), (Object)newHeaderLabelWidth);
                                        SetValueCommand resizeRowHeaderLabelCommand = new SetValueCommand(resizeRowHeaderLabel);
                                        resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                                    } else if (valueLabel == null && newHeaderLabelWidth != DefaultSizeUtils.getDefaultRowHeaderWidth()) {
                                        valueLabel = NattablestyleFactory.eINSTANCE.createIntValueStyle();
                                        valueLabel.setIntValue(newHeaderLabelWidth);
                                        valueLabel.setName(nameStyle.toString());
                                        SetRequest initRowHeaderLabelSizeRequest = new SetRequest(tableDomain, (EObject)localRowHeaderAxis, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)valueLabel);
                                        SetValueCommand resizeRowHeaderLabelCommand = new SetValueCommand(initRowHeaderLabelSizeRequest);
                                        resizeRowHeaderCommand.add((IUndoableOperation)resizeRowHeaderLabelCommand);
                                    }
                                }
                            }
                            if (resizeRowHeaderCommand.canExecute() && !resizeRowHeaderCommand.isEmpty() && (!isLocalRowHeaderAxisCreation || isLocalRowHeaderAxisCreation && 1 < resizeRowHeaderCommand.size())) {
                                tableDomain.getCommandStack().execute((org.eclipse.emf.common.command.Command)new GMFtoEMFCommandWrapper((ICommand)resizeRowHeaderCommand));
                            }
                        }
                    }
                }
            }
        };
        rowHeaderLayerStack.addLayerListener(this.resizeRowHeaderListener);
    }

    @Override
    public LocationValue getLocationInTheTable(Point absolutePoint) {
        Point widgetPoint = this.natTable.toControl(absolutePoint.x, absolutePoint.y);
        TableGridRegion kind = TableGridRegion.UNKNOWN;
        int columnPosition = this.natTable.getColumnPositionByX(widgetPoint.x);
        int columnIndex = this.natTable.getColumnIndexByPosition(columnPosition);
        int rowPosition = this.natTable.getRowPositionByY(widgetPoint.y);
        int rowIndex = this.natTable.getRowIndexByPosition(rowPosition);
        ILayerCell cell = this.natTable.getCellByPosition(columnPosition, rowPosition);
        Object columnObject = null;
        Object rowObject = null;
        if (rowIndex == -1 && columnIndex == -1) {
            kind = TableGridRegion.UNKNOWN;
        } else if (rowIndex == -1) {
            kind = TableGridRegion.AFTER_ROW_HEADER;
        } else if (columnIndex == -1) {
            kind = TableGridRegion.AFTER_COLUMN_HEADER;
        } else if (cell != null) {
            LabelStack label = cell.getConfigLabels();
            if (label.hasLabel("ROW_HEADER")) {
                kind = TableGridRegion.ROW_HEADER;
            } else if (label.hasLabel("COLUMN_HEADER")) {
                kind = TableGridRegion.COLUMN_HEADER;
            } else if (label.hasLabel("CORNER")) {
                kind = TableGridRegion.CORNER;
            } else if (label.hasLabel("BODY")) {
                kind = TableGridRegion.CELL;
                columnObject = this.getColumnElement(columnIndex);
                rowObject = this.getRowElement(rowIndex);
            }
        }
        return new LocationValue(absolutePoint, widgetPoint, kind, cell, columnIndex, rowIndex, columnObject, rowObject);
    }

    public GridLayer getGridLayer() {
        return this.gridLayer;
    }

    @Override
    public void print() {
        this.natTable.doCommand((ILayerCommand)new TurnViewportOffCommand());
        this.natTable.doCommand((ILayerCommand)new PrintCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
        this.natTable.doCommand((ILayerCommand)new TurnViewportOnCommand());
    }

    @Override
    public void selectAll() {
        this.natTable.doCommand((ILayerCommand)new SelectAllCommand());
    }

    @Override
    public void exportToXLS() {
        this.natTable.doCommand((ILayerCommand)new ExportCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
    }

    @Override
    public void exportToFile() {
        this.natTable.doCommand((ILayerCommand)new PapyrusFileExportCommand(this.natTable.getConfigRegistry(), this.natTable.getShell()));
    }

    public void copyToClipboard() {
        this.natTable.doCommand((ILayerCommand)new CopyDataToClipboardCommand("\t", System.getProperty("line.separator"), this.natTable.getConfigRegistry()));
    }

    @Override
    public BodyLayerStack getBodyLayerStack() {
        return this.bodyLayerStack;
    }

    public void dispose() {
        if (this.bodyDataProvider != null) {
            this.bodyLayerStack.removeLayerListener(this.resizeAxisListener);
            this.bodyLayerStack.dispose();
            this.bodyLayerStack = null;
            this.bodyDataProvider.dispose();
            this.bodyDataProvider = null;
        }
        if (this.rowHeaderDataProvider != null) {
            this.rowHeaderLayerStack.removeLayerListener(this.resizeRowHeaderListener);
            this.rowHeaderLayerStack.dispose();
            this.rowHeaderLayerStack = null;
            this.rowHeaderDataProvider.dispose();
            this.rowHeaderDataProvider = null;
        }
        if (this.columnHeaderDataProvider != null) {
            this.columnHeaderLayerStack.removeLayerListener(this.resizeColumnHeaderListener);
            this.columnHeaderLayerStack.dispose();
            this.columnHeaderLayerStack = null;
            this.columnHeaderDataProvider.dispose();
            this.columnHeaderDataProvider = null;
        }
        if (this.tableEditingDomain != null && this.resourceSetListener != null) {
            this.tableEditingDomain.removeResourceSetListener(this.resourceSetListener);
            this.tableEditingDomain = null;
        }
        if (this.filterStrategy instanceof IDisposable) {
            ((IDisposable)this.filterStrategy).dispose();
        }
        if (this.decorationService != null) {
            this.decorationService = null;
        }
        this.cellAxisConfiguration = null;
        this.filterConfiguration = null;
        this.tableEditingDomain = null;
        this.contextEditingDomain = null;
        this.tableContext = null;
        if (this.natTable != null) {
            this.natTable.dispose();
        }
        if (this.tablePopupMenuConfiguration != null) {
            this.tablePopupMenuConfiguration.dispose();
        }
    }

    public EObject getTableContext() {
        return this.tableContext;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    protected abstract IPapyrusSortModel getRowSortModel();

    public boolean revealElement(Object element) {
        return this.revealElement(Collections.singleton(element));
    }

    public boolean revealElement(Collection<?> elements) {
        Object currentRealObject;
        Object currentAxisObject;
        Object realObject;
        ArrayList toFind;
        boolean selectObject = false;
        SelectionLayer selectionLayer = this.bodyLayerStack.getSelectionLayer();
        List<Object> rowObjects = this.getRowElementsList();
        List<Object> columnObjects = this.getColumnElementsList();
        selectionLayer.clear();
        int rowIndex = 0;
        while (rowIndex < rowObjects.size()) {
            toFind = new ArrayList(elements);
            for (Object object : elements) {
                realObject = AxisUtils.getRepresentedElement(object);
                if (realObject.equals(object)) continue;
                toFind.add(realObject);
            }
            currentAxisObject = rowObjects.get(rowIndex);
            currentRealObject = AxisUtils.getRepresentedElement(currentAxisObject);
            if (toFind.contains(currentRealObject)) {
                selectionLayer.doCommand((ILayerCommand)new SelectRowsCommand((ILayer)selectionLayer, 0, rowIndex, false, true));
                toFind.remove(currentRealObject);
                selectObject = true;
            }
            if (toFind.isEmpty()) {
                return selectObject;
            }
            ++rowIndex;
        }
        int columnIndex = 0;
        while (columnIndex < columnObjects.size()) {
            toFind = new ArrayList(elements);
            for (Object object : elements) {
                realObject = AxisUtils.getRepresentedElement(object);
                if (realObject.equals(object)) continue;
                toFind.add(realObject);
            }
            currentAxisObject = columnObjects.get(columnIndex);
            currentRealObject = AxisUtils.getRepresentedElement(currentAxisObject);
            if (toFind.contains(currentRealObject)) {
                selectionLayer.doCommand((ILayerCommand)new SelectColumnCommand((ILayer)selectionLayer, columnIndex, 0, false, true));
                toFind.remove(currentRealObject);
                selectObject = true;
            }
            if (toFind.isEmpty()) {
                return selectObject;
            }
            ++columnIndex;
        }
        return selectObject;
    }

    protected void initTableAxis() {
        block33: {
            int actualRowAxisElements;
            DataLayer tableBodyLayer;
            block34: {
                int axisHeight;
                int axisWidth;
                BooleanValueStyle saveColumnsWidth;
                tableBodyLayer = this.getBodyLayerStack().getBodyDataLayer();
                EList notationColumnsAxisList = this.getTable().getCurrentColumnAxisProvider().getAxis();
                EList notationRowsAxisList = this.getTable().getCurrentRowAxisProvider().getAxis();
                int actualColumnAxisElements = this.getTableAxisElementProvider().getColumnElementsList().size();
                actualRowAxisElements = this.getTableAxisElementProvider().getRowElementsList().size();
                IntValueStyle value = null;
                boolean isUsedPercentage = this.isColumnWidthAsPercentage();
                if (isUsedPercentage) {
                    tableBodyLayer.setColumnPercentageSizing(true);
                }
                if ((saveColumnsWidth = (BooleanValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "saveColumnsWidth")) == null) {
                    TableConfiguration config = this.getTable().getTableConfiguration();
                    saveColumnsWidth = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "saveColumnsWidth");
                }
                HashSet<Integer> notManagedIndexAxisWidth = new HashSet<Integer>();
                int remainingPercentage = 100;
                int index = 0;
                while (index < notationColumnsAxisList.size()) {
                    IAxis currentColumnAxis = (IAxis)notationColumnsAxisList.get(index);
                    if (!this.getTable().isInvertAxis()) {
                        axisWidth = tableBodyLayer.getColumnWidthByPosition(index);
                        value = (IntValueStyle)currentColumnAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisWidth");
                        if (value != null && (saveColumnsWidth == null || saveColumnsWidth != null && !saveColumnsWidth.isBooleanValue())) {
                            if (isUsedPercentage) {
                                tableBodyLayer.setColumnWidthPercentageByPosition(index, value.getIntValue());
                                remainingPercentage -= value.getIntValue();
                            } else {
                                tableBodyLayer.setColumnWidthByPosition(index, value.getIntValue());
                            }
                        } else if (axisWidth != DefaultSizeUtils.getDefaultCellWidth() && !isUsedPercentage) {
                            tableBodyLayer.setColumnWidthByPosition(index, DefaultSizeUtils.getDefaultCellWidth());
                        } else if (isUsedPercentage) {
                            notManagedIndexAxisWidth.add(index);
                        }
                    } else {
                        axisHeight = tableBodyLayer.getRowHeightByPosition(index);
                        value = (IntValueStyle)currentColumnAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisHeight");
                        if (value != null) {
                            tableBodyLayer.setRowHeightByPosition(index, value.getIntValue());
                        } else if (axisHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                            tableBodyLayer.setRowHeightByPosition(index, DefaultSizeUtils.getDefaultCellHeight());
                        }
                    }
                    ++index;
                }
                index = 0;
                while (index < notationRowsAxisList.size()) {
                    IAxis currentRowAxis = (IAxis)notationRowsAxisList.get(index);
                    if (!this.getTable().isInvertAxis()) {
                        axisHeight = tableBodyLayer.getRowHeightByPosition(index);
                        value = (IntValueStyle)currentRowAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisHeight");
                        if (value != null) {
                            tableBodyLayer.setRowHeightByPosition(index, value.getIntValue());
                        } else if (axisHeight != DefaultSizeUtils.getDefaultCellHeight()) {
                            tableBodyLayer.setRowHeightByPosition(index, DefaultSizeUtils.getDefaultCellHeight());
                        }
                    } else {
                        axisWidth = tableBodyLayer.getColumnWidthByPosition(index);
                        value = (IntValueStyle)currentRowAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "axisWidth");
                        if (value != null && (saveColumnsWidth == null || saveColumnsWidth != null && !saveColumnsWidth.isBooleanValue())) {
                            if (isUsedPercentage) {
                                tableBodyLayer.setColumnWidthPercentageByPosition(index, value.getIntValue());
                                remainingPercentage -= value.getIntValue();
                            } else {
                                tableBodyLayer.setColumnWidthByPosition(index, value.getIntValue());
                            }
                        } else if (axisWidth != DefaultSizeUtils.getDefaultCellWidth() && !isUsedPercentage) {
                            tableBodyLayer.setColumnWidthByPosition(index, DefaultSizeUtils.getDefaultCellWidth());
                        } else if (isUsedPercentage) {
                            notManagedIndexAxisWidth.add(index);
                        }
                    }
                    ++index;
                }
                int numberIndex = 0;
                Iterator iterator = notManagedIndexAxisWidth.iterator();
                while (iterator.hasNext()) {
                    int index2 = (Integer)iterator.next();
                    tableBodyLayer.setColumnWidthPercentageByPosition(index2, PercentageCalculationUtils.calculatePercentageToSet(numberIndex, remainingPercentage, notManagedIndexAxisWidth.size()));
                    ++numberIndex;
                }
                if (notationRowsAxisList.size() != 0) break block33;
                if (!this.getTable().isInvertAxis()) break block34;
                int index3 = 0;
                while (index3 < actualColumnAxisElements) {
                    if (isUsedPercentage) {
                        tableBodyLayer.setColumnWidthPercentageByPosition(index3, 100 / actualColumnAxisElements);
                    } else {
                        tableBodyLayer.setColumnWidthByPosition(index3, DefaultSizeUtils.getDefaultCellWidth());
                    }
                    ++index3;
                }
                break block33;
            }
            if (this.getTable().isInvertAxis()) break block33;
            int index = 0;
            while (index < actualRowAxisElements) {
                tableBodyLayer.setRowHeightByPosition(index, DefaultSizeUtils.getDefaultCellHeight());
                ++index;
            }
        }
    }

    protected void doFillColumnsSize() {
        int parentSize;
        int columnSize;
        Composite parent;
        BooleanValueStyle fillColumnsSize = (BooleanValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize");
        if (fillColumnsSize == null) {
            TableConfiguration config = this.getTable().getTableConfiguration();
            fillColumnsSize = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "fillColumnsSize");
        }
        if (fillColumnsSize != null && fillColumnsSize.isBooleanValue() && (parent = this.natTable.getParent()) != null && !parent.isDisposed() && (columnSize = PapyrusTableSizeCalculation.getColumnFillWidth(this, parentSize = parent.getSize().x)) > 0) {
            int columnPosition = 0;
            while (columnPosition < this.getBodyLayerStack().getColumnHideShowLayer().getColumnCount()) {
                this.getBodyLayerStack().getBodyDataLayer().setColumnWidthByPosition(columnPosition, columnSize);
                ++columnPosition;
            }
        }
    }

    protected boolean isColumnWidthAsPercentage() {
        BooleanValueStyle columnsWidthAsPercentage = (BooleanValueStyle)this.getTable().getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
        if (columnsWidthAsPercentage == null) {
            TableConfiguration config = this.getTable().getTableConfiguration();
            columnsWidthAsPercentage = (BooleanValueStyle)config.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "columnsWidthAsPercentage");
        }
        return columnsWidthAsPercentage != null && columnsWidthAsPercentage.isBooleanValue();
    }

    protected void initTableHeaders() {
        DataLayer tableRowIndexHeaderLayer = this.rowHeaderLayerStack.getRowIndexDataLayer();
        DataLayer tableRowLabelHeaderLayer = this.rowHeaderLayerStack.getRowLabelDataLayer();
        DataLayer tableColumnIndexHeaderLayer = this.columnHeaderLayerStack.getColumnIndexDataLayer();
        DataLayer tableColumnLabelHeaderLayer = this.columnHeaderLayerStack.getColumnLabelDataLayer();
        AbstractHeaderAxisConfiguration rowHeader = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
        AbstractHeaderAxisConfiguration columnHeader = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
        IntValueStyle valueColumnIndex = (IntValueStyle)columnHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "columnIndexHeight");
        if (valueColumnIndex != null) {
            tableColumnIndexHeaderLayer.setRowHeightByPosition(0, valueColumnIndex.getIntValue());
        } else {
            tableColumnIndexHeaderLayer.setRowHeightByPosition(0, DefaultSizeUtils.getDefaultCellHeight());
        }
        IntValueStyle valueColumnLabel = (IntValueStyle)columnHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "columnLabelHeight");
        if (valueColumnLabel != null) {
            tableColumnLabelHeaderLayer.setRowHeightByPosition(0, valueColumnLabel.getIntValue());
        } else {
            tableColumnLabelHeaderLayer.setRowHeightByPosition(0, DefaultSizeUtils.getDefaultCellHeight());
        }
        IntValueStyle valueRowIndex = (IntValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowIndexWidth");
        if (valueRowIndex != null) {
            tableRowIndexHeaderLayer.setColumnWidthByPosition(0, valueRowIndex.getIntValue());
        } else {
            tableRowIndexHeaderLayer.setColumnWidthByPosition(0, DefaultSizeUtils.getDefaultRowHeaderWidth());
        }
        IntValueStyle valueRowLabel = (IntValueStyle)rowHeader.getNamedStyle(NattablestylePackage.eINSTANCE.getIntValueStyle(), "rowLabelWidth");
        if (valueRowLabel != null) {
            tableRowLabelHeaderLayer.setColumnWidthByPosition(0, valueRowLabel.getIntValue());
        } else {
            tableRowLabelHeaderLayer.setColumnWidthByPosition(0, DefaultSizeUtils.getDefaultRowHeaderWidth());
        }
        for (Style style : rowHeader.getStyles()) {
            String styleNameWithoutPrefix;
            String styleNameWithoutSuffix;
            int position;
            String styleName;
            if (!(style instanceof IntValueStyle) || !(styleName = ((IntValueStyle)style).getName()).startsWith("rowPosition") || (position = Integer.parseInt(styleNameWithoutSuffix = (styleNameWithoutPrefix = styleName.replace("rowPosition", "")).replace("LabelWidth", "")) - 1) >= tableRowLabelHeaderLayer.getColumnCount()) continue;
            tableRowLabelHeaderLayer.setColumnWidthByPosition(position, ((IntValueStyle)style).getIntValue());
        }
    }

    protected void initTableMerge() {
        BooleanValueStyle currentAxisMergeBoolean;
        IAxis currentAxis;
        int index;
        this.clearTableSpan();
        BooleanValueStyle valueRow = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeRows");
        BooleanValueStyle valueColumn = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeColumns");
        boolean mergeSelectedRows = this.getToMergeRowBoolean();
        boolean mergeSelectedColumns = this.getToMergeColumnBoolean();
        EList notationColumnsAxisList = this.getTable().getCurrentColumnAxisProvider().getAxis();
        EList notationRowsAxisList = this.getTable().getCurrentRowAxisProvider().getAxis();
        ArrayList<Integer> selectedAxisIndex = new ArrayList<Integer>();
        if (valueRow != null && valueRow.isBooleanValue()) {
            this.bodyLayerStack.getBodyLayerSpanProvider().setAutoColumnSpan(true);
        }
        if (valueColumn != null && valueColumn.isBooleanValue()) {
            this.bodyLayerStack.getBodyLayerSpanProvider().setAutoRowSpan(true);
        }
        if (mergeSelectedRows) {
            if (!this.getTable().isInvertAxis()) {
                index = 0;
                while (index < notationRowsAxisList.size()) {
                    currentAxis = (IAxis)notationRowsAxisList.get(index);
                    currentAxisMergeBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
                    if (currentAxisMergeBoolean != null && currentAxisMergeBoolean.isBooleanValue()) {
                        selectedAxisIndex.add(index);
                    }
                    ++index;
                }
            } else {
                index = 0;
                while (index < notationColumnsAxisList.size()) {
                    currentAxis = (IAxis)notationColumnsAxisList.get(index);
                    currentAxisMergeBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows");
                    if (currentAxisMergeBoolean != null && currentAxisMergeBoolean.isBooleanValue()) {
                        selectedAxisIndex.add(index);
                    }
                    ++index;
                }
            }
            this.bodyLayerStack.getBodyLayerSpanProvider().setAutoColumnSpan(true);
            this.bodyLayerStack.getBodyLayerSpanProvider().addAutoSpanningRowPositions(selectedAxisIndex.toArray(new Integer[selectedAxisIndex.size()]));
        }
        if (mergeSelectedColumns) {
            if (!this.getTable().isInvertAxis()) {
                index = 0;
                while (index < notationColumnsAxisList.size()) {
                    currentAxis = (IAxis)notationColumnsAxisList.get(index);
                    currentAxisMergeBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
                    if (currentAxisMergeBoolean != null && currentAxisMergeBoolean.isBooleanValue()) {
                        selectedAxisIndex.add(index);
                    }
                    ++index;
                }
            } else {
                index = 0;
                while (index < notationRowsAxisList.size()) {
                    currentAxis = (IAxis)notationRowsAxisList.get(index);
                    currentAxisMergeBoolean = (BooleanValueStyle)currentAxis.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns");
                    if (currentAxisMergeBoolean != null && currentAxisMergeBoolean.isBooleanValue()) {
                        selectedAxisIndex.add(index);
                    }
                    ++index;
                }
            }
            this.bodyLayerStack.getBodyLayerSpanProvider().setAutoRowSpan(true);
            this.bodyLayerStack.getBodyLayerSpanProvider().addAutoSpanningColumnPositions(selectedAxisIndex.toArray(new Integer[selectedAxisIndex.size()]));
        }
    }

    protected void clearTableSpan() {
        this.bodyLayerStack.getBodyLayerSpanProvider().clearAutoSpanningColumnPositions();
        this.bodyLayerStack.getBodyLayerSpanProvider().clearAutoSpanningRowPositions();
        this.bodyLayerStack.getBodyLayerSpanProvider().setAutoColumnSpan(false);
        this.bodyLayerStack.getBodyLayerSpanProvider().setAutoRowSpan(false);
    }

    protected boolean getToMergeRowBoolean() {
        for (Object currentObject : this.getRowElementsList()) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            if (!(currentObject instanceof IAxis) || (axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows")) == null || !axisToMerge.isBooleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean getToMergeColumnBoolean() {
        for (Object currentObject : this.getColumnElementsList()) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            if (!(currentObject instanceof IAxis) || (axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns")) == null || !axisToMerge.isBooleanValue()) continue;
            return true;
        }
        return false;
    }

    protected boolean getToggleStateSelectedRows() {
        int selectionSize = this.bodyLayerStack.getSelectionLayer().getFullySelectedRowPositions().length;
        int[] nArray = this.bodyLayerStack.getSelectionLayer().getFullySelectedRowPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            int index = nArray[n2];
            Object currentObject = this.getRowElement(index);
            if (this.getRowElement(index) instanceof IAxis && ((axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedRows")) != null && !axisToMerge.isBooleanValue() || axisToMerge == null)) {
                return false;
            }
            ++n2;
        }
        return selectionSize > 0;
    }

    protected boolean getToggleStateSelectedColumns() {
        int selectionSize = this.bodyLayerStack.getSelectionLayer().getFullySelectedColumnPositions().length;
        int[] nArray = this.bodyLayerStack.getSelectionLayer().getFullySelectedColumnPositions();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis currentAxis;
            BooleanValueStyle axisToMerge;
            int index = nArray[n2];
            Object currentObject = this.getColumnElement(index);
            if (this.getColumnElement(index) instanceof IAxis && ((axisToMerge = (BooleanValueStyle)(currentAxis = (IAxis)currentObject).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeInSelectedColumns")) != null && !axisToMerge.isBooleanValue() || axisToMerge == null)) {
                return false;
            }
            ++n2;
        }
        return selectionSize > 0;
    }

    protected boolean getToggleStateAllRows() {
        BooleanValueStyle mergeRows = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeRows");
        return mergeRows != null && mergeRows.isBooleanValue();
    }

    protected void updateToggleActionState() {
        ICommandService commandService = EclipseCommandUtils.getCommandService();
        if (commandService != null) {
            AbstractHeaderAxisConfiguration columnAxisConfiguration = HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
            Command command = commandService.getCommand("org.eclipse.papyrus.infra.nattable.column.display.filter");
            EclipseCommandUtils.updateToggleCommandState((Command)command, (boolean)columnAxisConfiguration.isDisplayFilter());
        }
    }

    protected boolean getToggleStateAllColumns() {
        BooleanValueStyle mergeColumns = (BooleanValueStyle)HeaderAxisConfigurationManagementUtils.getColumnAbstractHeaderAxisConfigurationUsedInTable(this.getTable()).getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeColumns");
        return mergeColumns != null && mergeColumns.isBooleanValue();
    }

    public Object getAdapter(Class adapter) {
        ISelection selection;
        if (adapter == TableSelectionProvider.class) {
            return this.selectionProvider;
        }
        if (adapter == TableSelectionWrapper.class && (selection = this.selectionProvider.getSelection()) instanceof TableStructuredSelection) {
            return ((TableStructuredSelection)selection).getAdapter(TableSelectionWrapper.class);
        }
        if (adapter == TableStructuredSelection.class && (selection = this.selectionProvider.getSelection()) instanceof TableStructuredSelection) {
            return selection;
        }
        return null;
    }

    public final TableStructuredSelection getSelectionInTable() {
        ISelection selection;
        if (this.selectionProvider != null && (selection = this.selectionProvider.getSelection()) instanceof TableStructuredSelection) {
            return (TableStructuredSelection)selection;
        }
        return null;
    }

    protected final Map<Integer, Object> getFullySelectedRows() {
        TableSelectionWrapper selectionWrapper;
        TableStructuredSelection selection = this.getSelectionInTable();
        if (selection != null && (selectionWrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class)) != null) {
            return selectionWrapper.getFullySelectedRows();
        }
        return Collections.emptyMap();
    }

    protected final Map<Integer, Object> getFullySelectedColumns() {
        TableSelectionWrapper selectionWrapper;
        TableStructuredSelection selection = this.getSelectionInTable();
        if (selection != null && (selectionWrapper = (TableSelectionWrapper)selection.getAdapter(TableSelectionWrapper.class)) != null) {
            return selectionWrapper.getFullySelectedColumns();
        }
        return Collections.emptyMap();
    }
}

