/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.util;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public class JavaProjectClasspathChangeAnalyzer {
    public Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragmentRoot) {
            if (this.isRelevantPackageFragmentRootChange(delta)) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                return Collections.singleton(root.getJavaProject());
            }
        } else {
            if (element instanceof IJavaModel) {
                return this.getJavaProjectsWithClasspathChange(delta.getAffectedChildren());
            }
            if (element instanceof IJavaProject) {
                if (this.isClasspathChangeOnProject(delta)) {
                    if (this.isAttachmentChangeOnly(delta)) {
                        return Collections.emptySet();
                    }
                    return Collections.singleton((IJavaProject)element);
                }
                return this.getJavaProjectsWithClasspathChange(delta.getAffectedChildren());
            }
        }
        return Collections.emptySet();
    }

    public boolean isClasspathChangeOnProject(IJavaElementDelta delta) {
        assert (delta.getElement() instanceof IJavaProject);
        return (delta.getFlags() & 0x20000) != 0 || (delta.getFlags() & 0x200000) != 0;
    }

    public boolean isAttachmentChangeOnly(IJavaElementDelta delta) {
        if (delta.getAffectedChildren().length == 0) {
            return false;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (!this.isAttachmentChangeFlagOnly(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isRelevantPackageFragmentRootChange(IJavaElementDelta delta) {
        IJavaElement element = delta.getElement();
        assert (element instanceof IPackageFragmentRoot);
        return delta.getKind() == 2 || delta.getKind() == 1 || (delta.getFlags() & 0x100) != 0 || (delta.getFlags() & 0x80) != 0 || (delta.getFlags() & 0x40) != 0 || ((IPackageFragmentRoot)element).isExternal() && (delta.getFlags() & 1) == delta.getFlags();
    }

    private boolean isAttachmentChangeFlagOnly(IJavaElementDelta child) {
        return child.getFlags() == 4096 || child.getFlags() == 8192 || child.getFlags() == 12288;
    }

    private Set<IJavaProject> getJavaProjectsWithClasspathChange(IJavaElementDelta[] affectedChildren) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        IJavaElementDelta[] iJavaElementDeltaArray = affectedChildren;
        int n = affectedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta delta = iJavaElementDeltaArray[n2];
            set.addAll(this.getJavaProjectsWithClasspathChange(delta));
            ++n2;
        }
        return set;
    }
}

