/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.common.parser.NamedElementLabelParser;
import org.eclipse.papyrus.uml.diagram.common.utils.ParameterLabelUtil;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.UMLPackage;

public class ParameterLabelParser
extends NamedElementLabelParser {
    protected static final String DIRECTION_FORMAT = "%s %s";
    protected static final String NAME_FORMAT = "%s%s";
    protected static final String TYPE_FORMAT = "%s: %s";
    protected static final String MULTIPLICITY_FORMAT = "%s [%s..%s]";
    protected static final String DEFAULT_VALUE_FORMAT = "%s= %s";
    protected static final String MODIFIER_FORMAT = "%s{%s}";

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        Collection<String> maskValues = this.getMaskValues(element);
        if (maskValues.isEmpty()) {
            return "<empty label>";
        }
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject != null && eObject instanceof Parameter) {
            Parameter parameter = (Parameter)eObject;
            return ParameterLabelUtil.getPrintString(parameter, maskValues);
        }
        return "";
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        Object feature;
        if (event instanceof Notification && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature) {
            return UMLPackage.eINSTANCE.getTypedElement_Type().equals(feature) || UMLPackage.eINSTANCE.getParameter_Direction().equals(feature) || UMLPackage.eINSTANCE.getParameter_DefaultValue().equals(feature) || UMLPackage.eINSTANCE.getParameter_IsStream().equals(feature) || UMLPackage.eINSTANCE.getParameter_IsException().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsOrdered().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_IsUnique().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_LowerValue().equals(feature) || UMLPackage.eINSTANCE.getMultiplicityElement_UpperValue().equals(feature) || super.isAffectingEvent(event, flags);
        }
        return false;
    }

    @Override
    public List<EObject> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<EObject> semanticElementsBeingParsed = new ArrayList<EObject>();
        if (element != null && element instanceof Parameter) {
            Parameter semElement = (Parameter)element;
            semanticElementsBeingParsed.add((EObject)semElement);
            if (semElement.getType() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getType());
            }
            if (semElement.getDefaultValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getDefaultValue());
            }
            if (semElement.getLowerValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getLowerValue());
            }
            if (semElement.getUpperValue() != null) {
                semanticElementsBeingParsed.add((EObject)semElement.getUpperValue());
            }
        }
        return semanticElementsBeingParsed;
    }

    @Override
    public Map<String, String> getMasks() {
        HashMap<String, String> masks = new HashMap<String, String>();
        masks.put("direction", "Direction");
        masks.put("name", "Name");
        masks.put("type", "Type");
        masks.put("multiplicity", "Multiplicity");
        masks.put("defaultValue", "Default value");
        masks.put("modifiers", "Modifiers");
        return masks;
    }

    @Override
    public Collection<String> getDefaultValue(IAdaptable element) {
        return Arrays.asList("name");
    }
}

