/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.util.DiagramRenderUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.commands.Activator;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusPopupBarEditPolicy;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ShortCutPreviewEditPolicy
extends PapyrusPopupBarEditPolicy {
    private final double SCALE_FACTOR = 0.5;
    private int CUSTOM_ITEM_WIDTH;
    private int CUSTOM_ITEM_HEIGHT;
    private Diagram diagram;
    private Image previewImage;
    private Image scaledPreviewImage;
    private int maxHeight = 0;
    private int maxWidth = 0;

    public void activate() {
        super.activate();
        if (this.getHost() instanceof GraphicalEditPart && ((GraphicalEditPart)this.getHost()).getNotationView() != null && ((GraphicalEditPart)this.getHost()).getNotationView().getElement() instanceof Diagram) {
            this.diagram = (Diagram)((GraphicalEditPart)this.getHost()).getNotationView().getElement();
        }
    }

    public void deactivate() {
        super.deactivate();
        if (this.previewImage != null) {
            this.previewImage.dispose();
        }
        if (this.scaledPreviewImage != null) {
            this.scaledPreviewImage.dispose();
        }
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.diagram != null) {
            if (this.previewImage == null) {
                try {
                    this.previewImage = DiagramRenderUtil.renderToSWTImage((Diagram)this.diagram);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
            } else {
                int optimalWidth = (int)((double)this.getHost().getRoot().getViewer().getControl().getBounds().width * 0.5);
                int optimalHeight = (int)((double)this.getHost().getRoot().getViewer().getControl().getBounds().height * 0.5);
                if (this.scaledPreviewImage == null || optimalWidth != this.maxWidth || optimalHeight != this.maxHeight) {
                    this.maxHeight = optimalHeight;
                    this.maxWidth = optimalWidth;
                    if (this.scaledPreviewImage != null) {
                        this.scaledPreviewImage.dispose();
                    }
                    this.scaledPreviewImage = this.resize(this.previewImage, this.maxHeight, this.maxWidth);
                }
                this.CUSTOM_ITEM_WIDTH = this.scaledPreviewImage.getBounds().width;
                this.CUSTOM_ITEM_HEIGHT = this.scaledPreviewImage.getBounds().height;
                super.showDiagramAssistant(referencePoint);
            }
        }
    }

    protected void initPopupBars() {
        List theList = this.getPopupBarDescriptors();
        if (theList.isEmpty()) {
            return;
        }
        this.myBalloon = this.createPopupBarFigure();
        int iTotal = this.CUSTOM_ITEM_WIDTH * theList.size() + ACTION_MARGIN_RIGHT;
        this.getBalloon().setSize(iTotal, this.CUSTOM_ITEM_HEIGHT + 2 * ACTION_BUTTON_START_Y);
        int xLoc = ACTION_BUTTON_START_X;
        int yLoc = ACTION_BUTTON_START_Y;
        for (PapyrusPopupBarEditPolicy.PopupBarDescriptor theDesc : theList) {
            PreviewPopupBarLabelHandle b = new PreviewPopupBarLabelHandle(theDesc.getIcon());
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, yLoc);
            xLoc += this.CUSTOM_ITEM_WIDTH;
            r1.setSize(this.CUSTOM_ITEM_WIDTH, this.CUSTOM_ITEM_HEIGHT - ACTION_MARGIN_RIGHT);
            Label l = new Label();
            l.setText(theDesc.getToolTip());
            b.setToolTip((IFigure)l);
            b.setPreferredSize(this.CUSTOM_ITEM_WIDTH, this.CUSTOM_ITEM_HEIGHT);
            b.setBounds(r1);
            this.getBalloon().add((IFigure)b);
            b.addMouseMotionListener((MouseMotionListener)this);
            b.addMouseListener((MouseListener)this.myMouseKeyListener);
        }
    }

    protected void appendPopupBarDescriptors() {
        this.addPopupBarDescriptor(null, this.scaledPreviewImage, null, "Preview of " + this.diagram.getName());
    }

    private Image resize(Image image, int maxWidth, int maxHeight) {
        double widthD = image.getBounds().width;
        double heightD = image.getBounds().height;
        double maxWidthD = maxWidth;
        double maxHeightD = maxHeight;
        if (widthD > maxWidthD || heightD > maxHeightD) {
            Double scale = 1.0;
            scale = widthD > maxWidthD && heightD > maxHeightD ? (widthD >= heightD ? Double.valueOf(maxWidthD / widthD) : Double.valueOf(maxHeightD / heightD)) : (widthD > maxWidthD ? Double.valueOf(maxWidthD / widthD) : Double.valueOf(maxHeightD / heightD));
            int scaledWidth = (int)(widthD * scale);
            int scaledHeight = (int)(heightD * scale);
            Image scaled = new Image((Device)Display.getDefault(), scaledWidth, scaledHeight);
            GC gc = new GC((Drawable)scaled);
            gc.setAntialias(1);
            gc.setInterpolation(2);
            gc.drawImage(image, 0, 0, image.getBounds().width, image.getBounds().height, 0, 0, scaledWidth, scaledHeight);
            gc.dispose();
            return scaled;
        }
        return image;
    }

    private class PreviewPopupBarLabelHandle
    extends PapyrusPopupBarEditPolicy.PopupBarLabelHandle {
        public PreviewPopupBarLabelHandle(Image theImage) {
            super((PapyrusPopupBarEditPolicy)ShortCutPreviewEditPolicy.this, null, theImage);
        }

        public void handleMouseEntered(MouseEvent event) {
            this.calculateEnabled();
            super.handleMouseEntered(event);
            this.myMouseOver = true;
        }

        public void handleMouseExited(MouseEvent event) {
            super.handleMouseExited(event);
            this.myMouseOver = false;
        }
    }
}

