/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.PacketDispatcher;
import com.sun.messaging.jmq.io.ReadOnlyPacket;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.BrowserConsumer;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.ConnectionRecover;
import com.sun.messaging.jmq.jmsclient.Consumer;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.FlowControl;
import com.sun.messaging.jmq.jmsclient.InterestTable;
import com.sun.messaging.jmq.jmsclient.MessageConsumerImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.MessageProducerImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.QueueReceiverImpl;
import com.sun.messaging.jmq.jmsclient.ReadQTable;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.SessionQueue;
import com.sun.messaging.jmq.jmsclient.TopicSubscriberImpl;
import com.sun.messaging.jmq.util.DebugPrinter;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import com.sun.messaging.jms.JMSException;
import jakarta.jms.Destination;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadChannel
implements PacketDispatcher,
Runnable {
    private ConnectionImpl connection = null;
    private ProtocolHandler protocolHandler = null;
    protected ReadQTable readQTable = null;
    protected ReadQTable ackQTable = null;
    protected InterestTable interestTable = null;
    protected Hashtable requestMetaData = null;
    protected boolean isClosed = false;
    protected boolean receivedGoodByeReply = false;
    protected FlowControl flowControl = null;
    protected boolean protectMode = false;
    protected static final String iMQReadChannel = "iMQReadChannel-";
    private boolean isFatalErrorSet = false;
    private Throwable savedError = null;
    protected jakarta.jms.JMSException savedJMSException = null;
    private boolean fatalErrorIsProcessed = false;
    private boolean isBrokerNonResponsive = false;
    protected Thread readChannelThread = null;
    protected ConnectionRecover conrc = null;
    private boolean debug = Debug.debug;
    public static final int REQUEST_TYPE_STATUS = 1;
    public static final int REQUEST_TYPE_CLUSTER = 2;
    public static final int REQUEST_TYPE_CONSUMER = 3;

    ReadChannel(ConnectionImpl connection) {
        this.connection = connection;
        this.protocolHandler = connection.getProtocolHandler();
        this.protocolHandler.setReplyDispatcher(this);
        this.interestTable = connection.interestTable;
        this.readQTable = connection.readQTable;
        this.ackQTable = connection.ackQTable;
        this.requestMetaData = connection.requestMetaData;
        this.init();
    }

    private void init() {
        this.protectMode = this.connection.getProtectMode();
        this.connection.flowControl = this.flowControl = new FlowControl(this.connection);
        this.flowControl.start();
        this.readChannelThread = new Thread(this);
        if (this.connection.hasDaemonThreads()) {
            this.readChannelThread.setDaemon(true);
        }
        this.readChannelThread.setName(iMQReadChannel + this.connection.getLocalID());
        this.readChannelThread.start();
    }

    @Override
    public void dispatch(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        switch (pkt.getPacketType()) {
            case 54: {
                this.processPing(pkt);
                return;
            }
            case 55: {
                return;
            }
            case 73: {
                this.processInfoPacket(pkt);
                break;
            }
            case 15: 
            case 27: {
                this.replaceConsumerID(pkt);
                this.processAcknowledge(pkt);
                break;
            }
            case 11: {
                this.checkRedirectStatus(pkt);
                this.replaceConnectionID(pkt);
                this.updateBrokerVersionInfo(pkt);
                this.processAcknowledge(pkt);
                this.connection.writeChannel.updateFlowControl(pkt);
                break;
            }
            case 19: {
                this.replaceProducerID(pkt);
                this.processAcknowledge(pkt);
                break;
            }
            case 9: {
                if (this.asyncSendAcknowledge(pkt)) break;
                this.processAcknowledge(pkt);
                break;
            }
            case 13: 
            case 17: 
            case 23: 
            case 25: 
            case 35: 
            case 37: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 67: 
            case 69: 
            case 71: 
            case 77: 
            case 79: {
                this.processAcknowledge(pkt);
                break;
            }
            case 29: {
                this.processAcknowledge(pkt);
                this.receivedGoodByeReply = true;
                this.close();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.processJMSMessage(pkt);
                break;
            }
            case 52: {
                this.processResumeFlow(pkt);
                break;
            }
            case 28: {
                this.processBrokerGoodbye(pkt);
                break;
            }
            case 74: {
                this.processDebug(pkt);
                break;
            }
            default: {
                if (this.isClosed) break;
                String errString = AdministeredObject.cr.getKString("W2000");
                Debug.getPrintStream().println(errString);
                pkt.dump(Debug.getPrintStream());
                this.checkConnectionState();
            }
        }
    }

    private void checkConnectionState() {
        try {
            if (this.protocolHandler.isClosed()) {
                Debug.getPrintStream().println("Fatal Error: ReadChannel closing due to protocol handler closed.");
                this.close();
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void processPing(ReadOnlyPacket ping) {
        try {
            if (ping.getFlag(16)) {
                this.protocolHandler.pingReply(ping);
            }
        }
        catch (Exception jmse) {
            ExceptionHandler.rootLogger.log(Level.WARNING, jmse.getLocalizedMessage(), jmse);
        }
    }

    private void processInfoPacket(ReadWritePacket pkt) {
        try {
            Hashtable prop = pkt.getProperties();
            int requestType = (Integer)prop.get("JMQRequestType");
            if (requestType == 1) {
                this.processStatusInfoPacket(pkt);
            } else if (requestType == 2) {
                this.processClusterInfoPacket(pkt);
            } else if (requestType == 3) {
                this.processConsumerInfoPacket(pkt);
            } else {
                Debug.println("*** received unknown INFO packet: ");
                pkt.dump(Debug.getPrintStream());
            }
            String addrlist = (String)prop.get("JMQBrokerList");
            if (addrlist != null) {
                this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                this.connection.JMQBrokerList = addrlist;
                this.connection.triggerConnectionAddressListChangedEvent(addrlist);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            Debug.printStackTrace(e);
            pkt.dump(Debug.getPrintStream());
        }
    }

    private void processStatusInfoPacket(ReadWritePacket pkt) {
        Hashtable prop = ReadChannel.getHashtableFromMessageBody(pkt);
        this.processStatusInfo(prop);
    }

    private void processStatusInfo(Hashtable prop) {
        boolean isLocal = this.isLocalBroker(prop);
        if (isLocal) {
            int state = (Integer)prop.get("State");
            long msecs = 0L;
            if (state == 7) {
                Long milliSecs = (Long)prop.get("ShutdownMS");
                if (milliSecs != null) {
                    msecs = milliSecs;
                }
                this.connection.triggerConnectionClosingEvent(msecs);
            }
        } else {
            Debug.println("INFO pkt is not for the local broker.");
        }
    }

    private boolean isLocalBroker(Hashtable prop) {
        boolean isLocal = (Boolean)prop.get("isLocal");
        return isLocal;
    }

    private void processClusterInfoPacket(ReadWritePacket pkt) {
        boolean isLocal = false;
        Hashtable table = ReadChannel.getHashtableFromMessageBody(pkt);
        Iterator it = table.values().iterator();
        boolean found = false;
        Hashtable prop = null;
        while (it.hasNext() && !found) {
            Object obj = it.next();
            if (!(obj instanceof Hashtable) || !(isLocal = this.isLocalBroker(prop = (Hashtable)obj))) continue;
            found = true;
        }
        if (found) {
            this.processStatusInfo(prop);
        } else {
            Debug.println("INFO pkt is not for the local broker.");
            pkt.dump(Debug.getPrintStream());
        }
    }

    private void processConsumerInfoPacket(ReadWritePacket pkt) {
        Hashtable body = ReadChannel.getHashtableFromMessageBody(pkt);
        String destName = (String)body.get("JMQDestination");
        int destType = (Integer)body.get("JMQDestType");
        int infoType = (Integer)body.get("JMQConsumerInfoType");
        this.connection.triggerConsumerEvent(infoType, destName, destType);
    }

    protected static Hashtable getHashtableFromMessageBody(ReadOnlyPacket pkt) {
        Hashtable prop = null;
        try {
            InputStream is = pkt.getMessageBodyStream();
            FilteringObjectInputStream ois = new FilteringObjectInputStream(is);
            prop = (Hashtable)ois.readObject();
            ois.close();
            is.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            Debug.printStackTrace(e);
        }
        return prop;
    }

    protected void processDebug(ReadWritePacket pkt) {
        try {
            Hashtable props = ReadChannel.getHashtableFromMessageBody(pkt);
            if (props.get("kill.jvm") != null) {
                ConnectionImpl.connectionLogger.log(Level.INFO, "FAULT-INJECTION: BROKER REQUESTS CLIENT JVM to TERMINATE !");
                System.exit(1);
                return;
            }
            if (props.get("close.conn") != null) {
                String emsg = "FAULT-INJECTION: BROKER REQUESTS CLIENT CLOSE CONNECTION !";
                ConnectionImpl.connectionLogger.log(Level.INFO, emsg);
                jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(emsg);
                this.exitConnection(jmse);
                if (this.protocolHandler.isDirectMode()) {
                    this.protocolHandler.close();
                }
                return;
            }
            boolean isLoggingConfigSet = this.setLoggingConfig(props);
            if (isLoggingConfigSet) {
                return;
            }
            DebugPrinter dbp = new DebugPrinter(2);
            String filename = (String)props.get("file");
            dbp.setFile(filename);
            String vstr = (String)props.get("verbose");
            boolean verbose = Boolean.parseBoolean(vstr);
            Hashtable debugState = this.connection.getDebugState(verbose);
            debugState.put("DebugCmd", props);
            dbp.setHashtable(debugState);
            dbp.println();
            dbp.close();
        }
        catch (Throwable e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    private boolean setLoggingConfig(Hashtable props) {
        boolean isLoggingConfigSet = false;
        try {
            String loggerName = (String)props.get("logging.name");
            if (loggerName != null) {
                Logger logger = Logger.getLogger(loggerName);
                String levelName = (String)props.get("logging.level");
                Level level = Level.parse(levelName);
                logger.setLevel(level);
                System.out.println("***** set logger " + logger.getName() + " to level " + levelName);
                String handlerClassName = (String)props.get("logging.handler");
                Handler handler = null;
                if (handlerClassName != null) {
                    System.out.println("**** Handler: " + handlerClassName);
                    if (handlerClassName.equals("java.util.logging.FileHandler")) {
                        String pattern = (String)props.get("logging.pattern");
                        if (pattern != null) {
                            System.out.println("**** logging pattern: " + pattern);
                            handler = new FileHandler(pattern);
                        } else {
                            handler = new FileHandler();
                        }
                    } else {
                        handler = (Handler)Class.forName(handlerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    handler.setLevel(level);
                    String formatterClassName = (String)props.get("logging.formatter");
                    if (formatterClassName != null) {
                        Formatter formatter = (Formatter)Class.forName(formatterClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        System.out.println("*** setting formatter to handler: " + formatterClassName);
                        handler.setFormatter(formatter);
                    }
                    logger.addHandler(handler);
                    System.out.println("***** set handler " + handlerClassName + " to logger " + loggerName);
                }
                isLoggingConfigSet = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isLoggingConfigSet;
    }

    protected void processBrokerGoodbye(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        Boolean jmqExit = null;
        String evcode = "E203";
        try {
            Hashtable props = pkt.getProperties();
            if (props != null) {
                jmqExit = (Boolean)props.get("JMQExit");
                Integer reason = (Integer)props.get("JMQGoodbyeReason");
                int goodbyeReason = -1;
                if (reason != null) {
                    goodbyeReason = reason;
                    switch (goodbyeReason) {
                        case 1: {
                            evcode = "E201";
                            break;
                        }
                        case 2: {
                            evcode = "E202";
                            break;
                        }
                        case 3: {
                            evcode = "E204";
                            break;
                        }
                        case 4: {
                            evcode = "E203";
                            break;
                        }
                        case 5: {
                            evcode = "E206";
                            break;
                        }
                        default: {
                            evcode = "E203";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
        this.connection.triggerConnectionClosedEvent(evcode, null);
        if (!this.connection.imqReconnect || jmqExit != null && jmqExit.booleanValue()) {
            String errorString = AdministeredObject.cr.getKString("C4056");
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(errorString, "C4056");
            this.exitConnection(jmse);
        }
        if (this.protocolHandler.isDirectMode()) {
            this.protocolHandler.close();
        }
    }

    private void updateBrokerVersionInfo(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        try {
            Boolean isHA;
            int statusCode;
            Integer protoLevel;
            Hashtable props = pkt.getProperties();
            String brokerVersion = (String)props.get("JMQVersion");
            if (brokerVersion != null) {
                this.connection.setBrokerVersion(brokerVersion);
            }
            if ((protoLevel = (Integer)props.get("JMQProtocolLevel")) != null) {
                this.connection.setBrokerProtocolLevel(protoLevel);
            }
            if ((statusCode = ((Integer)props.get("JMQStatus")).intValue()) == 505 && this.connection.checkBrokerProtocolLevel()) {
                this.connection.setNegotiateProtocolLevel(true);
                this.close();
            } else if (statusCode == 200 && (isHA = (Boolean)props.get("JMQHA")) != null && isHA.booleanValue()) {
                String tmp;
                Long storeID;
                this.connection.setConnectedToHABroker();
                if (this.connection.JMQClusterID == null) {
                    this.connection.JMQClusterID = (String)props.get("JMQClusterID");
                }
                if ((storeID = (Long)props.get("JMQStoreSession")) != null) {
                    Debug.println("**** Previous JMQStoreSession: " + this.connection.JMQStoreSession);
                    Debug.println("**** Using JMQStoreSession: " + storeID);
                    this.connection.JMQStoreSession = storeID;
                }
                if ((tmp = (String)props.get("JMQBrokerList")) != null) {
                    this.connection.savedJMQBrokerList = this.connection.JMQBrokerList;
                    this.connection.JMQBrokerList = tmp;
                }
                Debug.println("*** connected to HA broker.  JMQClusterID=" + this.connection.JMQClusterID + " JMQStoreSession=" + this.connection.JMQStoreSession + " JMQBrokerList=" + this.connection.JMQBrokerList);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4000");
        }
    }

    protected void replaceConnectionID(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Long connectionID = (Long)props.get("JMQConnectionID");
            if (connectionID != null) {
                this.connection.setConnectionID(connectionID);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4000");
        }
    }

    protected void replaceProducerID(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        try {
            Long jmqBytesProp;
            Hashtable props = pkt.getProperties();
            Long ackID = pkt.getConsumerID();
            Long newID = (Long)props.get("JMQProducerID");
            MessageProducerImpl producer = (MessageProducerImpl)this.requestMetaData.get(ackID);
            this.requestMetaData.remove(ackID);
            if (newID == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No producer for packet: ");
                    pkt.dump(Debug.getPrintStream());
                }
                return;
            }
            int jmqSize = -1;
            long jmqBytes = -1L;
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            if (jmqSizeProp != null) {
                jmqSize = jmqSizeProp;
            }
            if ((jmqBytesProp = (Long)props.get("JMQBytes")) != null) {
                jmqBytes = jmqBytesProp;
            }
            long producerID = newID;
            Destination dest = producer.addProducerDest;
            producer.setProducerID(dest, producerID);
            producer.setFlowLimit(producerID, jmqSize);
            producer.setFlowBytesLimit(producerID, jmqBytes);
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace(Debug.getPrintStream());
        }
    }

    protected void replaceConsumerID(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        try {
            int jmqSize;
            Hashtable props = pkt.getProperties();
            Long ackID = pkt.getConsumerID();
            Long newID = (Long)props.get("JMQConsumerID");
            Consumer consumer = (Consumer)this.requestMetaData.get(ackID);
            this.requestMetaData.remove(ackID);
            if (newID == null) {
                if (this.debug) {
                    Debug.getPrintStream().println("**** No consumer for packet: ");
                    pkt.dump(Debug.getPrintStream());
                }
                return;
            }
            this.interestTable.removeInterest(consumer);
            consumer.setInterestId(newID);
            Integer destType = (Integer)props.get("JMQDestType");
            consumer.setDestType(destType);
            this.interestTable.addInterest(consumer);
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            if (jmqSizeProp != null && (jmqSize = jmqSizeProp.intValue()) > 0) {
                consumer.setPrefetchMaxMsgCount(jmqSize);
            }
            this.connection.flowControl.addConsumerFlowControl(consumer);
            SessionImpl session = null;
            if (pkt.getPacketType() == 15) {
                if (consumer instanceof TopicSubscriberImpl) {
                    TopicSubscriberImpl ts = (TopicSubscriberImpl)consumer;
                    session = ts.getSession();
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                } else if (consumer instanceof QueueReceiverImpl) {
                    QueueReceiverImpl qr = (QueueReceiverImpl)consumer;
                    session = qr.getSession();
                    session.addMessageConsumer((MessageConsumerImpl)consumer);
                }
            } else {
                BrowserConsumer bc = (BrowserConsumer)consumer;
                session = bc.getSession();
                session.addBrowserConsumer(bc);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
        }
    }

    protected void processResumeFlow(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        try {
            Hashtable props = pkt.getProperties();
            Integer jmqSizeProp = (Integer)props.get("JMQSize");
            Long jmqBytesProp = (Long)props.get("JMQBytes");
            Long producerID = (Long)props.get("JMQProducerID");
            if (this.debug) {
                Debug.println("processResumeFlow() : JMQSize = " + jmqSizeProp + ", JMQBytes = " + jmqBytesProp + ", ProducerID = " + producerID);
            }
            if (producerID != null) {
                MessageProducerImpl producer = this.connection.findMessageProducer(producerID);
                if (producer != null) {
                    if (jmqSizeProp != null) {
                        producer.setFlowLimit(producerID, jmqSizeProp);
                    }
                    if (jmqBytesProp != null) {
                        producer.setFlowBytesLimit(producerID, jmqBytesProp);
                    }
                } else if (this.debug) {
                    Debug.info("*** warning: Cannot find producer for the resume pkt: ");
                    pkt.dump(Debug.getPrintStream());
                    this.connection.printDebugState();
                }
            } else {
                if (this.debug) {
                    Debug.info("Connection Resume Flow pkt dump: ");
                    pkt.dump(Debug.getPrintStream());
                }
                this.connection.writeChannel.updateFlowControl(pkt);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            e.printStackTrace();
            pkt.dump(Debug.getPrintStream());
        }
    }

    protected void processJMSMessage(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        long id;
        SessionQueue sessionQ = null;
        Consumer consumer = null;
        Long sessionId = null;
        this.flowControl.messageReceived();
        if (pkt.getFlowPaused()) {
            this.flowControl.requestConnectionFlowResume();
        }
        if ((consumer = this.interestTable.getConsumer(id = pkt.getConsumerID())) != null) {
            sessionId = consumer.getReadQueueId();
            if (sessionId != null) {
                sessionQ = this.readQTable.get(sessionId);
                if (sessionQ != null) {
                    this.flowControl.messageReceived(consumer);
                    if (pkt.getConsumerFlow()) {
                        this.flowControl.requestResume(consumer);
                    }
                    if (consumer instanceof BrowserConsumer) {
                        this.deliverToBrowserConsumer((BrowserConsumer)consumer, pkt);
                    } else {
                        sessionQ.enqueueNotify(pkt);
                    }
                } else {
                    String errorString = AdministeredObject.cr.getKString("W2001");
                    String pktstr = errorString + "\n" + pkt.toVerboseString();
                    ConnectionImpl.connectionLogger.log(Level.WARNING, pktstr);
                }
            } else {
                if (this.debug) {
                    Debug.getPrintStream().println("ERROR: NO session (null) for packet: ");
                    pkt.dump(Debug.getPrintStream());
                }
                String msg = "No Session for pkt: \n" + pkt.toVerboseString();
                ConnectionImpl.connectionLogger.log(Level.FINE, msg);
            }
        } else {
            if (this.debug) {
                Debug.getPrintStream().println("ERROR: NO consumer for packet: ");
                pkt.dump(Debug.getPrintStream());
            }
            String msg = "No consumer for pkt: \n" + pkt.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.FINE, msg);
        }
    }

    protected void deliverToBrowserConsumer(BrowserConsumer consumer, ReadOnlyPacket pkt) throws jakarta.jms.JMSException {
        MessageImpl message = this.protocolHandler.getJMSMessage(pkt);
        SessionImpl session = consumer.session;
        message.setSession(session);
        consumer.onMessage(message);
    }

    private boolean asyncSendAcknowledge(ReadWritePacket pkt) {
        boolean synchronousReply = this.protocolHandler.isDirectModeTwoThreadWithSyncReplies();
        if (synchronousReply) {
            return true;
        }
        long ackId = pkt.getConsumerID();
        AsyncSendCallback cb = (AsyncSendCallback)this.requestMetaData.get(ackId);
        this.requestMetaData.remove(ackId);
        if (cb == null) {
            return false;
        }
        cb.processCompletion(pkt, true);
        return true;
    }

    protected void processAcknowledge(ReadWritePacket pkt) {
        boolean synchronousReply;
        boolean bl = synchronousReply = this.protocolHandler.isDirectModeTwoThreadWithSyncReplies() && pkt.getPacketType() != 23;
        if (synchronousReply) {
            return;
        }
        long ackId = pkt.getConsumerID();
        SessionQueue ackQ = this.ackQTable.get(ackId);
        if (ackQ != null) {
            if (this.debug) {
                Debug.println("*** notify waiting queue ...." + pkt);
            }
            ackQ.enqueueNotify(pkt);
        } else if (!(this.connection.connectionIsBroken || this.connection.reconnecting || this.connection.isCloseCalled)) {
            String errorString = AdministeredObject.cr.getKString("W2001");
            String pktstr = errorString + "\n" + pkt.toVerboseString();
            ConnectionImpl.connectionLogger.log(Level.WARNING, pktstr);
        }
    }

    protected synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.flowControl.close();
    }

    @Override
    public void run() {
        ReadWritePacket packet = null;
        while (!this.isClosed) {
            try {
                packet = this.protocolHandler.readPacket();
                this.dispatch(packet);
            }
            catch (jakarta.jms.JMSException e) {
                if (this.debug) {
                    Debug.println("ReadChannel[connection closed=" + this.connection.isClosed + ", received goodbye-reply=" + this.receivedGoodByeReply + "] : " + e.getMessage());
                    Debug.printStackTrace(e);
                }
                if (this.isFatalErrorSet) {
                    this.fatalError(this.savedError);
                    return;
                }
                if (this.connection.isClosed || this.receivedGoodByeReply) {
                    this.connection.connectionIsBroken = true;
                    this.closeIOAndNotify();
                    return;
                }
                if (this.isBrokerNonResponsive) {
                    this.isBrokerNonResponsive = false;
                    this.connection.triggerConnectionClosedEvent("E207", null);
                } else {
                    this.connection.triggerConnectionClosedEvent("E206", e);
                }
                this.recover2(e);
            }
            catch (Exception ex) {
                Debug.printStackTrace(ex);
            }
            catch (Throwable error) {
                this.fatalError(error);
            }
        }
        if (this.debug) {
            Debug.println("ReadChannel exit ...");
        }
    }

    protected synchronized void setFatalError(Throwable err) {
        try {
            if (this.isFatalErrorSet) {
                return;
            }
            this.isFatalErrorSet = true;
            this.savedError = err;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            Debug.printStackTrace(e);
        }
    }

    protected void setBrokerNonResponsive() {
        try {
            if (this.debug) {
                Debug.println("*** broker is not responsive.  Closing I/O stream ...");
            }
            this.isBrokerNonResponsive = true;
            this.protocolHandler.close();
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fatalError(Throwable error) {
        try {
            ExceptionHandler.logError(error);
            ReadChannel readChannel = this;
            synchronized (readChannel) {
                block11: {
                    if (!this.fatalErrorIsProcessed) break block11;
                    return;
                }
                this.fatalErrorIsProcessed = true;
            }
            this.connection.connectionIsBroken = true;
            this.readQTable.closeAll();
            String errorString = AdministeredObject.cr.getKString("C4089", error.toString());
            jakarta.jms.JMSException jmse = new jakarta.jms.JMSException(errorString, "C4089");
            this.exitConnection(jmse);
        }
        catch (Throwable err) {
            if (Debug.debug) {
                err.printStackTrace();
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    private void recover2(jakarta.jms.JMSException e) {
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.connection.setRecoverInProcess(true);
        boolean connectStatus = false;
        if (this.connection.imqReconnect) {
            connectStatus = this.doRecover();
        }
        this.connection.setRecoverInProcess(false);
        if (!connectStatus) {
            this.exitConnection(e);
        }
    }

    private boolean doRecover() {
        boolean reconnected = false;
        try {
            this.connection.setReconnecting(true);
            this.closeIOAndNotify();
            if (this.conrc == null) {
                this.conrc = new ConnectionRecover(this.connection);
            } else {
                this.conrc.waitUntilInactive();
                if (this.conrc.getRecoverState() == 7) {
                    return false;
                }
            }
            this.conrc.init();
            reconnected = true;
        }
        catch (Exception e) {
            ExceptionHandler.logCaughtException(e);
            this.connection.setReconnecting(false);
        }
        if (reconnected) {
            this.conrc.start();
        }
        return reconnected;
    }

    protected void exitConnection(jakarta.jms.JMSException e) {
        this.connection.connectionIsBroken = true;
        this.savedJMSException = e;
        try {
            this.closeIOAndNotify();
            this.readQTable.closeAll();
            this.connection.exitConnection();
            this.flowControl.close();
        }
        finally {
            this.isClosed = true;
            this.connection.triggerConnectionClosedEvent("E206", e);
            this.connection.logLifeCycle("E500");
            if (this.connection.exceptionListener != null) {
                this.connection.triggerConnectionExitEvent(e);
            } else {
                Exception linkedE = e.getLinkedException();
                if (linkedE != null && this.protocolHandler.authenticated) {
                    Debug.printStackTrace(linkedE);
                }
                if (this.protocolHandler.authenticated) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    protected void closeIOAndNotify() {
        block2: {
            try {
                this.protocolHandler.close();
            }
            catch (Exception e) {
                ExceptionHandler.logCaughtException(e);
                if (!this.debug) break block2;
                Debug.printStackTrace(e);
            }
        }
        this.readQTable.notifyAllQueues();
        this.ackQTable.notifyAllQueues();
    }

    private void checkRedirectStatus(ReadWritePacket pkt) throws jakarta.jms.JMSException {
        if (this.connection.reconnecting) {
            try {
                Hashtable props = pkt.getProperties();
                int statusCode = (Integer)props.get("JMQStatus");
                if (statusCode == 301) {
                    this.connection.JMQStoreOwner = (String)props.get("JMQStoreOwner");
                    this.connection.initiator.setRedirectURL(this.connection.JMQStoreOwner);
                    this.protocolHandler.close();
                    String str = AdministeredObject.cr.getKString("I108", this.connection.getLastContactedBrokerAddress(), this.connection.JMQStoreOwner);
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                } else if (statusCode == 408) {
                    String str = AdministeredObject.cr.getKString("I109", this.connection.getLastContactedBrokerAddress());
                    ConnectionImpl.connectionLogger.log(Level.INFO, str);
                    this.protocolHandler.close();
                    JMSException jmse = new JMSException(str);
                    ExceptionHandler.throwJMSException(jmse);
                }
            }
            catch (jakarta.jms.JMSException jmse) {
                throw jmse;
            }
            catch (Exception e) {
                JMSException jmse = new JMSException(e.toString());
                ExceptionHandler.throwJMSException(jmse);
            }
        }
    }
}

