/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.manager.ha;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.TakingoverTracker;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ClusteredBrokerImpl;
import com.sun.messaging.jmq.jmsserver.cluster.manager.ha.RepHAClusterManagerImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.MigratableStoreUtil;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;

public class RepHAClusteredBrokerImpl
extends ClusteredBrokerImpl
implements HAClusteredBroker {
    UID storeSession = null;

    public RepHAClusteredBrokerImpl(RepHAClusterManagerImpl parent, MQAddress url, boolean local, UID id) {
        super(parent, url, local, id);
    }

    @Override
    public String toString() {
        if (!this.isLocalBroker()) {
            return "-" + this.getInstanceName() + this.getBrokerURL() + ":" + this.getState() + "[StoreSession:" + this.storeSession + ", BrokerSession:" + this.getBrokerSessionUID() + "]:" + BrokerStatus.toString(this.getStatus());
        }
        return "*" + this.getInstanceName() + "@" + this.getBrokerURL() + ":" + this.getState() + "[StoreSession:" + this.storeSession + ", BrokerSession:" + this.getBrokerSessionUID() + "]:" + BrokerStatus.toString(this.getStatus());
    }

    @Override
    public synchronized UID getStoreSessionUID() {
        return this.storeSession;
    }

    public synchronized void setStoreSessionUID(UID uid) {
        this.storeSession = uid;
    }

    @Override
    public synchronized String getNodeName() throws BrokerException {
        String instn = this.getInstanceName();
        UID storeSession = this.getStoreSessionUID();
        return MigratableStoreUtil.makeEffectiveBrokerID(instn, storeSession);
    }

    @Override
    public String getTakeoverBroker() throws BrokerException {
        return null;
    }

    @Override
    public long getHeartbeat() throws BrokerException {
        return 0L;
    }

    @Override
    public long updateHeartbeat() throws BrokerException {
        throw new BrokerException("Operation not supported");
    }

    @Override
    public long updateHeartbeat(boolean reset) throws BrokerException {
        throw new BrokerException("Operation not supported");
    }

    @Override
    public TakeoverStoreInfo takeover(boolean force, Object extraInfo, TakingoverTracker tracker) throws BrokerException {
        String targetRepHostPort = (String)extraInfo;
        Store store = Globals.getStore();
        TakeoverStoreInfo o = store.takeoverBrokerStore(this.getInstanceName(), tracker.getDownStoreSessionUID(), targetRepHostPort, tracker);
        ((RepHAClusterManagerImpl)this.parent).addSupportedStoreSessionUID(tracker.getStoreSessionUID());
        return o;
    }

    @Override
    public void resetTakeoverBrokerReadyOperating() throws Exception {
        throw new BrokerException("Operation not supported");
    }

    @Override
    public void setStateFailoverProcessed(UID storeSession) throws Exception {
    }

    @Override
    public void setStateFailoverFailed(UID brokerSession) throws Exception {
    }
}

