/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketUtil;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConsumerAlreadyAddedException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class ConsumerHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    private static boolean DEBUG_CLUSTER_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private static boolean DEBUG_CLUSTER_MSG = Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    private DestinationList DL = Globals.getDestinationList();
    private FaultInjection fi = null;
    boolean ALWAYS_WAIT_ON_DESTROY = Globals.getConfig().getBooleanProperty("imq.waitForConsumerDestroy");

    public ConsumerHandler() {
        this.fi = FaultInjection.getInjection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        Consumer sub;
        Hashtable<String, Object> hash;
        Packet pkt;
        Consumer newc;
        Session session;
        boolean sessionPaused;
        block94: {
            block93: {
                UID uid;
                int status;
                String err_reason;
                block92: {
                    sessionPaused = false;
                    boolean conPaused = false;
                    Hashtable props = null;
                    try {
                        props = msg.getProperties();
                    }
                    catch (Exception ex) {
                        this.logger.logStack(16, "Unable to retrieve  properties from consumer message " + msg, ex);
                    }
                    if (props == null) {
                        props = new Hashtable();
                    }
                    Long lsessionid = (Long)props.get("JMQSessionID");
                    session = null;
                    err_reason = null;
                    Boolean blockprop = (Boolean)props.get("JMQBlock");
                    newc = null;
                    assert (blockprop == null || msg.getPacketType() == 16) : msg;
                    boolean blockprop_bool = blockprop != null && blockprop != false;
                    boolean isIndemp = msg.getIndempotent();
                    pkt = new Packet(con.useDirectBuffers());
                    pkt.setConsumerID(msg.getConsumerID());
                    hash = new Hashtable<String, Object>();
                    pkt.setPacketType(msg.getPacketType() + 1);
                    status = 200;
                    String warning = "B2009";
                    uid = null;
                    Integer oldid = null;
                    sub = null;
                    try {
                        DestinationList.acquirePartitionLock(true);
                        try {
                            Boolean rAll;
                            boolean redeliverAll;
                            Integer bodytype;
                            con.suspend();
                            conPaused = true;
                            if (msg.getPacketType() == 14) {
                                Integer inttype;
                                int type;
                                SessionUID sessionID;
                                if (DEBUG) {
                                    this.logger.log(8, "ConsumerHandler: [Received AddConsumer message {0}]", msg.toString());
                                }
                                pkt.setPacketType(15);
                                if (lsessionid == null) {
                                    if (DEBUG) {
                                        this.logger.log(8, "ConsumerHandler: not Raptor consumer packet (no session id)");
                                    }
                                    if ((session = con.getSession(sessionID = new SessionUID(con.getConnectionUID().longValue()))) == null) {
                                        session = Session.createSession(sessionID, con.getConnectionUID(), null, this.coreLifecycle);
                                        con.attachSession(session);
                                    }
                                } else {
                                    sessionID = new SessionUID(lsessionid);
                                    session = con.getSession(sessionID);
                                    if (session == null) {
                                        throw new BrokerException("Internal Error: client set invalid sessionUID " + sessionID + " session does not exist");
                                    }
                                }
                                if (blockprop_bool) {
                                    session.pause("Consumer - Block flag");
                                    sessionPaused = true;
                                }
                                if ((oldid = (Integer)props.get("JMQConsumerID")) != null) {
                                    hash.put("JMQOldConsumerID", oldid);
                                }
                                int n = type = (inttype = (Integer)props.get("JMQDestType")) == null ? -1 : inttype;
                                if (type == -1) {
                                    throw new BrokerException(Globals.getBrokerResources().getString("B4117", "Client is not sending DestType, unable to add interest"));
                                }
                                boolean queue = DestType.isQueue(type);
                                String destination = (String)props.get("JMQDestination");
                                String selector = (String)props.get("JMQSelector");
                                if (selector != null && selector.trim().length() == 0) {
                                    selector = null;
                                }
                                boolean mqshare = false;
                                boolean jmsshare = false;
                                boolean nolocal = false;
                                Boolean b = (Boolean)props.get("JMQNoLocal");
                                if (b != null && b.booleanValue()) {
                                    nolocal = true;
                                }
                                if ((b = (Boolean)props.get("JMQShare")) != null && b.booleanValue()) {
                                    mqshare = true;
                                }
                                if ((b = (Boolean)props.get("JMQJMSShare")) != null && b.booleanValue()) {
                                    jmsshare = true;
                                }
                                String durablename = (String)props.get("JMQDurableName");
                                String subscriptionName = (String)props.get("JMQSharedSubscriptionName");
                                String clientid = this.getClientID(props, con);
                                Boolean reconnect = (Boolean)props.get("JMQReconnect");
                                Integer size = (Integer)props.get("JMQSize");
                                if (mqshare && jmsshare) {
                                    String emsg = "Client protocol error: both JMQShare and JMQJMSShare set to true";
                                    Globals.getLogger().log(32, emsg);
                                    throw new BrokerException(emsg);
                                }
                                boolean shared = mqshare || jmsshare;
                                boolean durable = false;
                                if (durablename != null) {
                                    if (subscriptionName != null) {
                                        Object[] args = new Object[]{Subscription.getDSubLogString(clientid, durablename), destination, subscriptionName};
                                        this.logger.log(8, this.br.getKString("B1476", args));
                                    }
                                    subscriptionName = durablename;
                                    durable = true;
                                }
                                if (DestType.isTemporary(type)) {
                                    String emsg;
                                    if (durable) {
                                        emsg = this.br.getKString("B4438", destination, subscriptionName);
                                        this.logger.log(32, emsg);
                                        throw new BrokerException(emsg, "B4438", null, 412);
                                    }
                                    if (shared) {
                                        emsg = this.br.getKString("B4439", destination, subscriptionName);
                                        this.logger.log(32, emsg);
                                        throw new BrokerException(emsg, "B4439", null, 412);
                                    }
                                }
                                ConsumerParameters pm = new ConsumerParameters();
                                pm.isqueue = queue;
                                pm.destination = destination;
                                pm.selector = selector;
                                pm.clientid = clientid;
                                pm.subscriptionName = subscriptionName;
                                pm.durable = durable;
                                pm.shared = shared;
                                pm.jmsshare = jmsshare;
                                pm.nolocal = nolocal;
                                this.checkSubscriptionName(pm);
                                this.checkClientID(pm);
                                this.checkNoLocal(pm);
                                if (reconnect != null && reconnect.booleanValue()) {
                                    Globals.getLogger().log(32, "B3100", "JMQReconnect not implemented");
                                }
                                DestinationUID dest_uid = null;
                                Destination d = null;
                                if (DestinationUID.isWildcard(destination)) {
                                    dest_uid = DestinationUID.getUID(destination, DestType.isQueue(type));
                                } else {
                                    Destination[] ds = null;
                                    while (true) {
                                        ds = DestinationList.getDestination(con.getPartitionedStore(), destination, type, true, !con.isAdminConnection());
                                        d = ds[0];
                                        if (d == null) break;
                                        if (d.isAutoCreated()) {
                                            warning = "B2106";
                                        }
                                        try {
                                            d.incrementRefCount();
                                        }
                                        catch (BrokerException ex) {
                                            continue;
                                        }
                                        catch (IllegalStateException ex) {
                                            throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", ex, 500);
                                        }
                                        break;
                                    }
                                    if (d == null) {
                                        status = 404;
                                        throw new BrokerException(Globals.getBrokerResources().getKString("B4017", destination), "B4017", null, 404);
                                    }
                                    dest_uid = d.getDestinationUID();
                                }
                                if (jmsshare && mqshare) {
                                    Object[] args = new Object[]{"JMS", !durable ? Subscription.getNDSubLongLogString(clientid, dest_uid, selector, subscriptionName, nolocal) : Subscription.getDSubLogString(clientid, subscriptionName), destination, "JMQShare"};
                                    this.logger.log(8, this.br.getKString("B1477", args));
                                    mqshare = false;
                                }
                                Consumer c = null;
                                try {
                                    Consumer[] retc = this._createConsumer(dest_uid, con, session, selector, clientid, subscriptionName, durable, shared, jmsshare, nolocal, size == null ? -1 : size, msg.getSysMessageID().toString(), isIndemp, true);
                                    c = retc[0];
                                    newc = retc[1];
                                    sub = (Subscription)retc[2];
                                    if (c.getPrefetch() != -1 || size != null) {
                                        hash.put("JMQSize", c.getPrefetch());
                                    }
                                }
                                catch (SelectorFormatException ex) {
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B2016", selector), "B2016", ex, 400);
                                }
                                catch (OutOfLimitsException ex) {
                                    if (d != null && d.isQueue()) {
                                        Object[] args = new String[]{dest_uid.getName(), String.valueOf(d.getActiveConsumerCount()), String.valueOf(d.getFailoverConsumerCount())};
                                        throw new BrokerException(Globals.getBrokerResources().getKString("B4006", args), "B4006", ex, 409);
                                    }
                                    Object[] args = new String[]{Subscription.getDSubLogString(clientid, durablename), dest_uid.getName(), String.valueOf(ex.getLimit())};
                                    throw new BrokerException(Globals.getBrokerResources().getKString("B4186", args), "B4186", ex, 409);
                                }
                                finally {
                                    if (d != null) {
                                        d.decrementRefCount();
                                    }
                                }
                                Integer acktype = (Integer)props.get("JMQAckMode");
                                if (acktype != null) {
                                    c.getConsumerUID().setAckType(acktype);
                                }
                                uid = c.getConsumerUID();
                                if (props.get("JMQOldConsumerID") != null) {
                                    Object[] args = new Object[]{(ConsumerUID)uid + (String)(sub == null ? "" : "[" + (Subscription)sub + "]"), "" + dest_uid, props.get("JMQOldConsumerID")};
                                    this.logger.log(8, this.br.getKString("B1471", args));
                                }
                                break block92;
                            }
                            if (DEBUG) {
                                this.logger.log(8, "ConsumerHandler: [Received DestroyConsumer message {0}]", msg.toString());
                            }
                            warning = "B2010";
                            pkt.setPacketType(17);
                            String durableName = (String)props.get("JMQDurableName");
                            String clientID = this.getClientID(props, con);
                            Long cid = (Long)props.get("JMQConsumerID");
                            UID uID = uid = cid == null ? null : new ConsumerUID(cid);
                            if (lsessionid != null) {
                                SessionUID sessionID = new SessionUID(lsessionid);
                                session = con.getSession(sessionID);
                            } else {
                                session = Session.getSession((ConsumerUID)uid);
                            }
                            if (session == null && durableName == null && !isIndemp && con.getConnectionState() < 5) {
                                this.logger.log(32, this.br.getKString("B3250", this.br.getKString("B3309", lsessionid == null ? "" : lsessionid, "" + (ConsumerUID)uid) + "\n" + PacketUtil.dumpPacket(msg)));
                                Session.dumpAll();
                            }
                            int btype = (bodytype = (Integer)props.get("JMQBodyType")) == null ? 0 : bodytype;
                            SysMessageID lastid = null;
                            boolean lastidInTransaction = false;
                            if (btype == 3) {
                                int size = msg.getMessageBodySize();
                                if (size == 0) {
                                    this.logger.log(8, "Warning, bad body in destroy consumer");
                                } else {
                                    DataInputStream is = new DataInputStream(msg.getMessageBodyStream());
                                    lastid = new SysMessageID();
                                    lastid.readID(is);
                                    Boolean val = (Boolean)props.get("JMQLastDeliveredIDInTransaction");
                                    boolean bl = lastidInTransaction = val != null && val != false;
                                }
                            }
                            if (DEBUG && lastid != null) {
                                this.logger.log(8, "ConsumerHandler: destroy consumer with lastID [" + lastid + ", " + lastidInTransaction + "]" + DestinationList.get(con.getPartitionedStore(), lastid) + " for consumer " + (ConsumerUID)uid);
                            }
                            boolean bl = redeliverAll = (rAll = (Boolean)props.get("JMQRedeliverAll")) != null && rAll != false;
                            if (!sessionPaused && session != null) {
                                sessionPaused = true;
                                session.pause("Consumer removeconsumer");
                            }
                            this.destroyConsumer(con, session, (ConsumerUID)uid, durableName, clientID, lastid, lastidInTransaction, redeliverAll, isIndemp);
                        }
                        finally {
                            DestinationList.releasePartitionLock(true);
                        }
                    }
                    catch (BrokerException ex) {
                        status = ex.getStatusCode();
                        String consumid = null;
                        String destination = null;
                        try {
                            destination = (String)props.get("JMQDestination");
                            if (destination == null && msg.getPacketType() != 14) {
                                destination = "";
                            }
                            consumid = oldid != null ? oldid.toString() : "";
                        }
                        catch (Exception bodytype) {
                            // empty catch block
                        }
                        Object[] args = new String[]{consumid, con.getRemoteConnectionString(), destination};
                        err_reason = ex.getMessage();
                        if (ex.getStatusCode() == 412 || ex.getStatusCode() == 409) {
                            this.logger.log(16, warning, args, (Throwable)ex);
                        } else if (ex.getStatusCode() == 400) {
                            this.logger.log(16, warning, args, (Throwable)ex);
                            if (ex.getCause() != null) {
                                this.logger.log(8, ex.getCause().toString());
                            }
                        } else if (isIndemp && msg.getPacketType() == 16) {
                            this.logger.logStack(4, "Reprocessing Indempotent message for {0} on destination {2} from {1}", args, (Throwable)ex);
                            status = 200;
                            err_reason = null;
                        } else {
                            this.logger.logStack(16, warning, args, (Throwable)ex);
                        }
                    }
                    catch (IOException ex) {
                        this.logger.logStack(16, "Unable to process  consumer request " + msg, ex);
                        err_reason = ex.getMessage();
                        assert (false);
                    }
                    catch (SecurityException ex) {
                        status = 403;
                        err_reason = ex.getMessage();
                        String destination = null;
                        String consumid = null;
                        try {
                            destination = (String)props.get("JMQDestination");
                            if (oldid != null) {
                                consumid = oldid.toString();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.logger.log(16, warning, destination, consumid, ex);
                    }
                    finally {
                        if (conPaused) {
                            con.resume();
                        }
                    }
                }
                hash.put("JMQStatus", status);
                if (err_reason != null) {
                    hash.put("JMQReason", err_reason);
                }
                if (uid != null) {
                    hash.put("JMQConsumerID", uid.longValue());
                }
                IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                if (IMQBasicConnection.getDumpPacket()) break block93;
                IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                if (!IMQBasicConnection.getDumpOutPacket()) break block94;
            }
            hash.put("JMQReqID", msg.getSysMessageID().toString());
        }
        pkt.setProperties(hash);
        con.sendControlMessage(pkt);
        if (sessionPaused) {
            session.resume("Consumer - session was paused");
        }
        if (sub != null) {
            sub.resume("Consumer - added to sub");
        }
        if (newc != null) {
            newc.resume("Consumer - new consumer");
        }
        return true;
    }

    private String getClientID(Hashtable props, Connection con) {
        String clientid = (String)con.getClientData("client id");
        if (clientid == null && (clientid = (String)props.get("JMQClientID")) != null) {
            this.logger.log(32, "B3100", "Client did not send SET_CLIENTID before adding/removing a consumer, retrieved clientid " + clientid + " from packet properties");
        }
        return clientid;
    }

    public void destroyConsumer(IMQConnection con, Session session, ConsumerUID uid, String durableName, String clientID, SysMessageID lastid, boolean lastidInTransaction, boolean redeliverAll, boolean isIndemp) throws BrokerException {
        if (durableName != null) {
            Subscription usub = Subscription.unsubscribe(durableName, clientID);
            if (usub == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4058", Subscription.getDSubLogString(clientID, durableName)), 404);
            }
            DestinationUID dest_uid = usub.getDestinationUID();
            Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), dest_uid);
            Destination d = ds[0];
            if (d != null) {
                d.removeConsumer(uid, true);
            }
        } else {
            boolean redeliver = false;
            if (con.getClientProtocolVersion() < 350) {
                redeliver = true;
            }
            if (session == null && !isIndemp) {
                if (con.getConnectionState() >= 6) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4274", con.getConnectionUID()), 404);
                }
                throw new BrokerException(Globals.getBrokerResources().getKString("B4275", uid, con.getConnectionUID()), 404);
            }
            if (session != null) {
                Consumer c = (Consumer)session.detatchConsumer(uid, lastid, lastidInTransaction, redeliver, redeliverAll);
                if (DEBUG) {
                    this.logger.log(8, "ConsumerHandler: closed consumer " + c + ", with {lastid=" + lastid + ", lastidInTransaction=" + lastidInTransaction + ", redeliver=" + redeliver + ", redeliverAll=" + redeliverAll + ", isindemp=" + isIndemp + "}");
                }
                DestinationUID dest_uid = c.getDestinationUID();
                Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), dest_uid);
                Destination d = ds[0];
                if (d != null) {
                    d.removeConsumer(uid, true);
                }
            }
        }
    }

    public Consumer[] createConsumer(DestinationUID dest_uid, IMQConnection con, Session session, String selectorstr, String clientid, String subscriptionName, boolean durable, boolean shared, boolean jmsshare, boolean nolocal, int size, String consumerString, boolean isIndemp, boolean useFlowControl) throws BrokerException, SelectorFormatException, IOException {
        ConsumerParameters pm = new ConsumerParameters();
        pm.isqueue = dest_uid.isQueue();
        pm.destination = dest_uid.toString();
        pm.selector = selectorstr;
        pm.clientid = clientid;
        pm.subscriptionName = subscriptionName;
        pm.durable = durable;
        pm.shared = shared;
        pm.jmsshare = jmsshare;
        pm.nolocal = nolocal;
        this.checkSubscriptionName(pm);
        this.checkClientID(pm);
        this.checkNoLocal(pm);
        return this._createConsumer(dest_uid, con, session, selectorstr, clientid, subscriptionName, durable, shared, jmsshare, nolocal, size, consumerString, isIndemp, useFlowControl);
    }

    private Consumer[] _createConsumer(DestinationUID dest_uid, IMQConnection con, Session session, String selectorstr, String clientid, String subscriptionName, boolean durable, boolean shared, boolean jmsshare, boolean nolocal, int size, String consumerString, boolean isIndemp, boolean useFlowControl) throws BrokerException, SelectorFormatException, IOException {
        Consumer c = null;
        Consumer newc = null;
        Subscription sub = null;
        String selector = selectorstr;
        if (selectorstr != null && selectorstr.trim().length() == 0) {
            selector = null;
        }
        try {
            int prefetch = -1;
            if (isIndemp && (c = Consumer.getConsumer(consumerString)) != null) {
                prefetch = c.getPrefetch();
            }
            if (c == null) {
                int dprefetch;
                c = new Consumer(dest_uid, selector, nolocal, con.getConnectionUID());
                c.setCreator(consumerString);
                newc = c;
                newc.pause("Consumer: new consumer");
                Destination[] ds = DestinationList.getDestination(con.getPartitionedStore(), dest_uid);
                Destination d = ds[0];
                boolean wildcard = dest_uid.isWildcard();
                int cprefetch = size;
                int n = wildcard ? -1 : (dprefetch = !shared ? d.getMaxPrefetch() : d.getSharedConsumerFlowLimit());
                prefetch = dprefetch == -1 ? cprefetch : (cprefetch == -1 ? cprefetch : (cprefetch > dprefetch ? dprefetch : cprefetch));
                c.setPrefetch(prefetch, useFlowControl);
                if (subscriptionName != null && durable) {
                    if (!shared) {
                        this.logger.log(8, this.br.getKString("B1478", Subscription.getDSubLogString(clientid, subscriptionName), dest_uid));
                    } else {
                        this.logger.log(8, this.br.getKString("B1479", Subscription.getDSubLogString(clientid, subscriptionName) + (jmsshare ? "jms" : "mq"), dest_uid));
                    }
                    sub = Subscription.findCreateDurableSubscription(clientid, subscriptionName, shared, jmsshare, dest_uid, selector, nolocal, true);
                    sub.setCreator(consumerString);
                    sub.pause("Consumer attaching to durable");
                    sub.attachConsumer(c, con);
                    c.localConsumerCreationReady();
                    Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, dest_uid);
                    LinkedHashSet<Destination> dset = null;
                    Iterator<LinkedHashSet<Destination>> itr = dmap.values().iterator();
                    boolean notify = true;
                    while (itr.hasNext()) {
                        dset = itr.next();
                        if (dset == null) continue;
                        for (Destination dd : dset) {
                            if (dd == null) continue;
                            Subscription oldsub = null;
                            try {
                                oldsub = (Subscription)dd.addConsumer(sub, notify, con);
                            }
                            catch (ConsumerAlreadyAddedException e) {
                                this.logger.log(8, e.getMessage());
                            }
                            if (oldsub == null) continue;
                            oldsub.purge();
                        }
                        notify = false;
                    }
                    sub.sendCreateSubscriptionNotification(c);
                } else if ((wildcard || !d.isQueue()) && shared) {
                    this.logger.log(8, this.br.getKString("B1480", Subscription.getNDSubLongLogString(clientid, dest_uid, selectorstr, subscriptionName, nolocal), "" + dest_uid));
                    sub = Subscription.createAttachNonDurableSub(c, con, subscriptionName, shared, jmsshare);
                    c.localConsumerCreationReady();
                    if (sub != null) {
                        sub.pause("Consumer: attaching to nondurable");
                        Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, dest_uid);
                        LinkedHashSet<Destination> dset2 = null;
                        for (LinkedHashSet<Destination> dset2 : dmap.values()) {
                            if (dset2 == null) continue;
                            for (Destination dd : dset2) {
                                if (dd == null) continue;
                                dd.addConsumer(sub, true, con);
                            }
                        }
                    }
                    c.attachToConnection(con.getConnectionUID());
                    if (sub != null) {
                        sub.sendCreateSubscriptionNotification(c);
                    }
                } else {
                    c.localConsumerCreationReady();
                    Destination dd2 = null;
                    Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, dest_uid);
                    LinkedHashSet<Destination> dset3 = null;
                    for (LinkedHashSet<Destination> dset3 : dmap.values()) {
                        if (dset3 == null) continue;
                        for (Destination dd2 : dset3) {
                            if (dd2 == null) continue;
                            dd2.addConsumer(c, true, con);
                        }
                    }
                    c.attachToConnection(con.getConnectionUID());
                    c.sendCreateConsumerNotification();
                }
            }
            if (this.fi.FAULT_INJECTION) {
                HashMap<Object, Object> fips = new HashMap<Object, Object>();
                fips.put("mqDestinationName", DestinationUID.getUniqueString(dest_uid.getName(), dest_uid.isQueue()));
                this.fi.checkFaultAndSleep("consumer.add.1", fips);
            }
            session.attachConsumer(c);
            if (DEBUG) {
                this.logger.log(8, "Attached consumer " + c + "[prefetch=" + c.getPrefetch() + ", useConsumerFlowControl=" + useFlowControl + "] to session " + session);
            }
            Consumer[] retc = new Consumer[]{c, newc, sub};
            return retc;
        }
        catch (Exception e) {
            Object[] args = new Object[]{durable ? Subscription.getDSubLogString(clientid, subscriptionName) : (shared ? Subscription.getNDSubLongLogString(clientid, dest_uid, selector, subscriptionName, nolocal) : ""), con, dest_uid};
            String emsg = Globals.getBrokerResources().getKString("B2106", args);
            this.logger.logStack(32, emsg, e);
            try {
                if (c != null) {
                    try {
                        session.detatchConsumer(c.getConsumerUID(), null, false, false, false);
                    }
                    catch (Exception e1) {
                        try {
                            c.destroyConsumer(new HashSet(), null, true, false, true);
                        }
                        catch (Exception cprefetch) {
                            // empty catch block
                        }
                    }
                }
                Map<PartitionedStore, LinkedHashSet<Destination>> dmap = DestinationList.findMatchingDestinationMap(null, dest_uid);
                LinkedHashSet<Destination> dset4 = null;
                Destination dd3 = null;
                for (LinkedHashSet<Destination> dset4 : dmap.values()) {
                    if (dset4 == null) continue;
                    for (Destination dd3 : dset4) {
                        if (dd3 == null) continue;
                        try {
                            if (c != null) {
                                dd3.removeConsumer(c.getConsumerUID(), true);
                            }
                            if (sub == null) continue;
                            dd3.removeConsumer(sub.getConsumerUID(), true);
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    if (sub != null && c != null) {
                        sub.releaseConsumer(c.getConsumerUID());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (subscriptionName != null && durable && sub != null && sub.getCreator() != null && sub.getCreator().equals(consumerString)) {
                    try {
                        Subscription.unsubscribe(subscriptionName, clientid);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof SelectorFormatException) {
                throw (SelectorFormatException)e;
            }
            throw new BrokerException(emsg, e);
        }
    }

    private void checkNoLocal(ConsumerParameters pm) throws BrokerException {
        if (!pm.nolocal) {
            return;
        }
        if (pm.isqueue) {
            Globals.getLogger().log(32, "B3100", "NoLocal is not supported on Queue Receivers");
            throw new BrokerException("Unsupported property on queues JMQNoLocal is set to " + pm.nolocal, 500);
        }
        if (pm.clientid == null) {
            if (pm.durable) {
                String emsg = Globals.getBrokerResources().getKString("B4432", pm.subscriptionName);
                Globals.getLogger().log(32, emsg);
                throw new BrokerException(emsg, "B4432", null, 412);
            }
            if (pm.shared) {
                String emsg = Globals.getBrokerResources().getKString("B4434", "[" + pm.clientid + ":" + pm.destination + ":" + pm.selector + ":" + pm.subscriptionName + "]");
                Globals.getLogger().log(32, emsg);
                throw new BrokerException(emsg, "B4434", null, 412);
            }
        }
    }

    private void checkSubscriptionName(ConsumerParameters pm) throws BrokerException {
        if (pm.isqueue && pm.subscriptionName != null) {
            String emsg = "Protocol error: Unexpected subscription name for Queue";
            Globals.getLogger().log(32, emsg);
            throw new BrokerException(emsg);
        }
        if (pm.durable && (pm.subscriptionName == null || pm.subscriptionName.trim().equals(""))) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4436", pm.subscriptionName, pm.destination), "B4436", null, 412);
        }
        if (pm.shared && pm.jmsshare && (pm.subscriptionName == null || pm.subscriptionName.trim().equals(""))) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4437", pm.subscriptionName, pm.destination), "B4437", null, 412);
        }
    }

    private void checkClientID(ConsumerParameters pm) throws BrokerException {
        if (pm.isqueue) {
            return;
        }
        if (pm.durable && !pm.jmsshare && pm.clientid == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4135", pm.subscriptionName), "B4135", null, 412);
        }
        if (!pm.durable && pm.shared && !pm.jmsshare && pm.clientid == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4308", pm.destination), "B4308", null, 412);
        }
        if ((pm.durable || pm.shared) && pm.clientid != null && pm.clientid.trim().length() == 0) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4109", pm.clientid), "B4109", null, 412);
        }
    }

    static {
        if (!DEBUG) {
            DEBUG = DEBUG_CLUSTER_TXN || DEBUG_CLUSTER_MSG;
        }
    }

    private static class ConsumerParameters {
        boolean isqueue = true;
        String destination = null;
        String selector = null;
        String clientid = null;
        String subscriptionName = null;
        boolean durable = true;
        boolean shared = true;
        boolean jmsshare = true;
        boolean nolocal = true;

        private ConsumerParameters() {
        }
    }
}

