/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.admin.DestinationInfo;
import java.util.Hashtable;

public class UpdateDestinationHandler
extends AdminCmdHandler {
    private static boolean DEBUG = UpdateDestinationHandler.getDEBUG();

    public UpdateDestinationHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": " + cmd_props);
        }
        DestinationInfo info = (DestinationInfo)this.getBodyObject(cmd_msg);
        int status = 200;
        String errMsg = null;
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            try {
                Destination[] ds = DestinationList.getDestination(null, info.name, DestType.isQueue(info.type));
                Destination d = ds[0];
                if (d == null) {
                    errMsg = this.rb.getString("B4017", info.name);
                    status = 404;
                } else {
                    int maxcons;
                    if (info.isModified(4)) {
                        int maxMessages = info.maxMessages;
                        d.setCapacity(maxMessages);
                    }
                    if (info.isModified(16)) {
                        SizeString maxSize = new SizeString();
                        maxSize.setBytes(info.maxMessageSize);
                        d.setMaxByteSize(maxSize);
                    }
                    if (info.isModified(8)) {
                        SizeString maxBytes = new SizeString();
                        maxBytes.setBytes(info.maxMessageBytes);
                        d.setByteCapacity(maxBytes);
                    }
                    if (info.isModified(32)) {
                        int scope = info.destScope;
                        d.setScope(scope);
                    }
                    if (info.isModified(64)) {
                        int destlimit = info.destLimitBehavior;
                        d.setLimitBehavior(destlimit);
                    }
                    if (info.isModified(128)) {
                        int prefetch = info.maxPrefetch;
                        d.setMaxPrefetch(prefetch);
                    }
                    if (info.isModified(256)) {
                        int clusterdeliverypolicy = info.destCDP;
                        d.setClusterDeliveryPolicy(clusterdeliverypolicy);
                    }
                    if (info.isModified(512)) {
                        maxcons = info.maxActiveConsumers;
                        d.setMaxActiveConsumers(maxcons);
                    }
                    if (info.isModified(1024)) {
                        maxcons = info.maxFailoverConsumers;
                        d.setMaxFailoverConsumers(maxcons);
                    }
                    if (info.isModified(2048)) {
                        int maxproducers = info.maxProducers;
                        d.setMaxProducers(maxproducers);
                    }
                    if (info.isModified(4096)) {
                        int maxsharedcons = info.maxNumSharedConsumers;
                        d.setMaxSharedConsumers(maxsharedcons);
                    }
                    if (info.isModified(8192)) {
                        int sflowlimit = info.sharedConsumerFlowLimit;
                        d.setSharedFlowLimit(sflowlimit);
                    }
                    if (info.isModified(16384)) {
                        boolean dmq = info.useDMQ;
                        d.setUseDMQ(dmq);
                    }
                    if (info.isModified(32768)) {
                        d.setValidateXMLSchemaEnabled(info.validateXMLSchemaEnabled);
                    }
                    if (info.isModified(65536)) {
                        d.setXMLSchemaUriList(info.XMLSchemaUriList);
                    }
                    if (info.isModified(131072)) {
                        d.setReloadXMLSchemaOnFailure(info.reloadXMLSchemaOnFailure);
                    }
                    d.update();
                }
            }
            catch (Exception ex) {
                errMsg = UpdateDestinationHandler.getMessageFromException(ex);
                status = 500;
            }
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        UpdateDestinationHandler.setProperties(reply, 41, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

