/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWorkMessage;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionLogManager;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.WaitTimeoutException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class LoggedMessageHelper {
    public static final Logger logger = Globals.getLogger();
    Map<SysMessageID, SysMessageID> loggedSendsSinceLastCheckpoint = new ConcurrentHashMap<SysMessageID, SysMessageID>();
    Set<SysMessageID> pendingRemove = Collections.synchronizedSet(new HashSet());
    TransactionLogManager txnLogManager;

    public LoggedMessageHelper(TransactionLogManager txnLogManager) {
        this.txnLogManager = txnLogManager;
    }

    public void preMessageRemoved(DestinationUID dstID, SysMessageID mid) throws BrokerException {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " preMessageRemoved() dest=" + dstID + " mid=" + mid;
            logger.log(4, msg);
        }
        if (!TransactionLogManager.logNonTransactedMsgAck && this.loggedSendsSinceLastCheckpoint.containsKey(mid)) {
            this.txnLogManager.logMsgRemoval(dstID, mid);
        }
        this.loggedSendsSinceLastCheckpoint.remove(mid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessageRemoved(DestinationUID dstID, SysMessageID mid) throws BrokerException {
        Set<SysMessageID> set = this.pendingRemove;
        synchronized (set) {
            boolean found = this.pendingRemove.remove(mid);
            if (found) {
                if (Store.getDEBUG()) {
                    String msg = this.getPrefix() + " postMessageRemoved() dest=" + dstID + " id=" + mid + " pendingRemoves=" + this.pendingRemove.size();
                    logger.log(4, msg);
                }
                if (this.pendingRemove.isEmpty()) {
                    this.pendingRemove.notifyAll();
                }
            }
        }
    }

    public void lastAckLogged(DestinationUID dst, SysMessageID id) {
        this.pendingRemove.add(id);
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " lastAckLogged() dest=" + dst + " id=" + id + " pendingRemoves=" + this.pendingRemove.size();
            logger.log(4, msg);
        }
        this.loggedSendsSinceLastCheckpoint.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPendingRemoveCompletion(boolean nowait) throws WaitTimeoutException {
        Set<SysMessageID> set = this.pendingRemove;
        synchronized (set) {
            String msg;
            if (Store.getDEBUG()) {
                msg = this.getPrefix() + " num pendingRemove =" + this.pendingRemove.size();
                logger.log(4, msg);
            }
            try {
                while (!this.pendingRemove.isEmpty()) {
                    if (Store.getDEBUG()) {
                        msg = this.getPrefix() + " waiting for " + this.pendingRemove.size() + " pendingRemove";
                        logger.log(4, msg);
                    }
                    if (nowait) {
                        throw new WaitTimeoutException(this.getClass().getSimpleName());
                    }
                    this.pendingRemove.wait(1000L);
                }
                this.txnLogManager.notifyPlayToStoreCompletion();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    void messageListLogged(List<TransactionWorkMessage> twms) {
        for (TransactionWorkMessage twm : twms) {
            this.messageLogged(twm);
        }
    }

    public void messageLogged(TransactionWorkMessage twm) {
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " messageLogged()" + twm;
            logger.log(4, msg);
        }
        SysMessageID id = twm.getMessage().getSysMessageID();
        this.loggedSendsSinceLastCheckpoint.put(id, id);
    }

    public void onCheckpoint() {
        this.loggedSendsSinceLastCheckpoint.clear();
    }

    String getPrefix() {
        return "LoggedMessageHelper: " + Thread.currentThread().getName();
    }
}

