/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.jms.tx.log;

import com.sun.messaging.bridge.service.jms.tx.GlobalXid;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GlobalXidDecision
implements Externalizable {
    public static final int COMMIT = 0;
    public static final int ROLLBACK = 1;
    private GlobalXid globalXid = null;
    private int globalDecision = 0;

    public GlobalXidDecision() {
    }

    public GlobalXidDecision(GlobalXid xid, int decision) {
        if (decision != 0 && decision != 1) {
            throw new IllegalArgumentException("Invalid global decision value: " + decision);
        }
        this.globalXid = xid;
        this.globalDecision = decision;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.globalXid.write(out);
        out.writeInt(this.globalDecision);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.globalXid = GlobalXid.read(in);
        this.globalDecision = in.readInt();
    }

    private static String decisionString(int d) {
        if (d == 0) {
            return "COMMIT";
        }
        if (d == 1) {
            return "ROLLBACK";
        }
        return "UNKNOWN";
    }

    public String toString() {
        return this.globalXid.toString() + "(" + GlobalXidDecision.decisionString(this.globalDecision) + ")";
    }

    public GlobalXid getGlobalXid() {
        return this.globalXid;
    }

    public int getGlobalDecision() {
        return this.globalDecision;
    }
}

