/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;

public class MqttSuback
extends MqttAck {
    private int[] grantedQos;

    public MqttSuback(byte info, byte[] data) throws IOException {
        super((byte)9);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.msgId = dis.readUnsignedShort();
        int index = 0;
        this.grantedQos = new int[data.length - 2];
        int qos = dis.read();
        while (qos != -1) {
            this.grantedQos[index] = qos;
            ++index;
            qos = dis.read();
        }
        dis.close();
    }

    protected byte[] getVariableHeader() throws MqttException {
        return new byte[0];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(" granted Qos");
        int i = 0;
        while (i < this.grantedQos.length) {
            sb.append(" ").append(this.grantedQos[i]);
            ++i;
        }
        return sb.toString();
    }
}

