/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class WebSocketReceiver
implements Runnable {
    private static final String CLASS_NAME;
    private static final Logger log;
    private boolean running = false;
    private boolean stopping = false;
    private Object lifecycle = new Object();
    private InputStream input;
    private Thread receiverThread = null;
    private volatile boolean receiving;
    private PipedOutputStream pipedOutputStream;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketReceiver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    }

    public WebSocketReceiver(InputStream input, PipedInputStream pipedInputStream) throws IOException {
        this.input = input;
        this.pipedOutputStream = new PipedOutputStream();
        pipedInputStream.connect(this.pipedOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.receiverThread = new Thread((Runnable)this, threadName);
                this.receiverThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopping = true;
        boolean closed = false;
        Object object = this.lifecycle;
        synchronized (object) {
            log.fine(CLASS_NAME, "stop", "850");
            if (this.running) {
                this.running = false;
                this.receiving = false;
                closed = true;
                this.closeOutputStream();
            }
        }
        if (closed && !Thread.currentThread().equals(this.receiverThread)) {
            try {
                this.receiverThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.receiverThread = null;
        log.fine(CLASS_NAME, "stop", "851");
    }

    public void run() {
        while (this.running && this.input != null) {
            try {
                log.fine(CLASS_NAME, "run", "852");
                this.receiving = this.input.available() > 0;
                WebSocketFrame incomingFrame = new WebSocketFrame(this.input);
                if (!incomingFrame.isCloseFlag()) {
                    int i = 0;
                    while (i < incomingFrame.getPayload().length) {
                        this.pipedOutputStream.write(incomingFrame.getPayload()[i]);
                        ++i;
                    }
                    this.pipedOutputStream.flush();
                } else if (!this.stopping) {
                    throw new IOException("Server sent a WebSocket Frame with the Stop OpCode");
                }
                this.receiving = false;
            }
            catch (IOException iOException) {
                this.stop();
            }
        }
    }

    private void closeOutputStream() {
        try {
            this.pipedOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

