/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;

public class MqttSubscribe
extends MqttWireMessage {
    private String[] names;
    private int[] qos;
    private int count;

    public MqttSubscribe(byte info, byte[] data) throws IOException {
        super((byte)8);
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        this.msgId = dis.readUnsignedShort();
        this.count = 0;
        this.names = new String[10];
        this.qos = new int[10];
        boolean end = false;
        while (!end) {
            try {
                this.names[this.count] = this.decodeUTF8(dis);
                this.qos[this.count++] = dis.readByte();
            }
            catch (Exception exception) {
                end = true;
            }
        }
        dis.close();
    }

    public MqttSubscribe(String[] names, int[] qos) {
        super((byte)8);
        this.names = names;
        this.qos = qos;
        if (names.length != qos.length) {
            throw new IllegalArgumentException();
        }
        this.count = names.length;
        int i = 0;
        while (i < qos.length) {
            MqttMessage.validateQos(qos[i]);
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" names:[");
        int i = 0;
        while (i < this.count) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append("\"").append(this.names[i]).append("\"");
            ++i;
        }
        sb.append("] qos:[");
        i = 0;
        while (i < this.count) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.qos[i]);
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    protected byte getMessageInfo() {
        return (byte)(2 | (this.duplicate ? 8 : 0));
    }

    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public byte[] getPayload() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            int i = 0;
            while (i < this.names.length) {
                this.encodeUTF8(dos, this.names[i]);
                dos.writeByte(this.qos[i]);
                ++i;
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public boolean isRetryable() {
        return true;
    }
}

