/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttAsyncClient;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttCallbackExtended;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.eclipse.paho.client.mqttv3.MqttPingSender;
import org.eclipse.paho.client.mqttv3.MqttSecurityException;
import org.eclipse.paho.client.mqttv3.MqttToken;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.TimerPingSender;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ConnectActionListener;
import org.eclipse.paho.client.mqttv3.internal.DisconnectedMessageBuffer;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.NetworkModule;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.TCPNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.security.SSLSocketFactoryFactory;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketSecureNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPublish;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttSubscribe;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttUnsubscribe;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private static final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private static final String CLIENT_ID_PREFIX = "paho";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connOpts;
    private Object userContext;
    private Timer reconnectTimer;
    private static int reconnectDelay = 1000;
    private boolean reconnecting = false;
    private static Object clientLock = new Object();
    private ScheduledExecutorService executorService;

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(serverURI, clientId, persistence, new TimerPingSender());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        this(serverURI, clientId, persistence, pingSender, null);
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender, ScheduledExecutorService executorService) throws MqttException {
        log.setResourceName(clientId);
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        int i = 0;
        while (i < clientId.length() - 1) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
            ++i;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        this.executorService = executorService;
        if (this.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(10);
        }
        log.fine(CLASS_NAME, "MqttAsyncClient", "101", new Object[]{clientId, serverURI, persistence});
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, pingSender, this.executorService);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        log.fine(CLASS_NAME, "createNetworkModules", "116", new Object[]{address});
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        int i = 0;
        while (i < array.length) {
            networkModules[i] = this.createNetworkModule(array[i], options);
            ++i;
        }
        log.fine(CLASS_NAME, "createNetworkModules", "108");
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        TCPNetworkModule netModule;
        URI uri;
        int serverURIType;
        SocketFactory factory;
        block28: {
            log.fine(CLASS_NAME, "createNetworkModule", "115", new Object[]{address});
            factory = options.getSocketFactory();
            serverURIType = MqttConnectOptions.validateURI(address);
            try {
                uri = new URI(address);
                if (uri.getHost() != null || !address.contains("_")) break block28;
                try {
                    Field hostField = URI.class.getDeclaredField("host");
                    hostField.setAccessible(true);
                    String shortAddress = address.substring(uri.getScheme().length() + 3);
                    hostField.set(uri, this.getHostName(shortAddress));
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                    throw ExceptionHelper.createMqttException(e.getCause());
                }
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Malformed URI: " + address + ", " + e.getMessage());
            }
        }
        String host = uri.getHost();
        int port = uri.getPort();
        switch (serverURIType) {
            case 0: {
                if (port == -1) {
                    port = 1883;
                }
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId);
                netModule.setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                if (port == -1) {
                    port = 8883;
                }
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (sslClientProps != null) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                ((SSLNetworkModule)netModule).setSSLHostnameVerifier(options.getSSLHostnameVerifier());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 3: {
                if (port == -1) {
                    port = 80;
                }
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketNetworkModule(factory, address, host, port, this.clientId);
                ((WebSocketNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 4: {
                String[] enabledCiphers;
                if (port == -1) {
                    port = 443;
                }
                SSLSocketFactoryFactory wSSFactoryFactory = null;
                if (factory == null) {
                    wSSFactoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (sslClientProps != null) {
                        wSSFactoryFactory.initialize(sslClientProps, null);
                    }
                    factory = wSSFactoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, address, host, port, this.clientId);
                ((WebSocketSecureNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (wSSFactoryFactory == null || (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            default: {
                log.fine(CLASS_NAME, "createNetworkModule", "119", new Object[]{address});
                netModule = null;
            }
        }
        return netModule;
    }

    private String getHostName(String uri) {
        int portIndex = uri.indexOf(58);
        if (portIndex == -1) {
            portIndex = uri.indexOf(47);
        }
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(0, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        if (options == null) {
            options = new MqttConnectOptions();
        }
        this.connOpts = options;
        this.userContext = userContext;
        boolean automaticReconnect = options.isAutomaticReconnect();
        log.fine(CLASS_NAME, "connect", "103", new Object[]{options.isCleanSession(), new Integer(options.getConnectionTimeout()), options.getKeepAliveInterval(), options.getUserName(), options.getPassword() == null ? "[null]" : "[notnull]", options.getWillMessage() == null ? "[null]" : "[notnull]", userContext, callback});
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        this.comms.setReconnectCallback(new MqttReconnectCallback(automaticReconnect));
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback, this.reconnecting);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        if (this.mqttCallback instanceof MqttCallbackExtended) {
            connectActionListener.setMqttCallbackExtended((MqttCallbackExtended)this.mqttCallback);
        }
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        log.fine(CLASS_NAME, "disconnect", "104", new Object[]{quiesceTimeout, userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
        }
        catch (MqttException ex) {
            log.fine(CLASS_NAME, "disconnect", "105", null, ex);
            throw ex;
        }
        log.fine(CLASS_NAME, "disconnect", "108");
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout, boolean sendDisconnectPacket) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout, sendDisconnectPacket);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public String getCurrentServerURI() {
        return this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopic.validate(topic, false);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    public IMqttToken checkPing(Object userContext, IMqttActionListener callback) throws MqttException {
        log.fine(CLASS_NAME, "ping", "117");
        MqttToken token = this.comms.checkForActivity();
        log.fine(CLASS_NAME, "ping", "118");
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < topicFilters.length) {
            this.comms.removeMessageListener(topicFilters[i]);
            ++i;
        }
        if (log.isLoggable(5)) {
            StringBuffer subs = new StringBuffer();
            int i2 = 0;
            while (i2 < topicFilters.length) {
                if (i2 > 0) {
                    subs.append(", ");
                }
                subs.append("topic=").append(topicFilters[i2]).append(" qos=").append(qos[i2]);
                MqttTopic.validate(topicFilters[i2], true);
                ++i2;
            }
            log.fine(CLASS_NAME, "subscribe", "106", new Object[]{subs.toString(), userContext, callback});
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        log.fine(CLASS_NAME, "subscribe", "109");
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback, IMqttMessageListener[] messageListeners) throws MqttException {
        if (messageListeners.length != qos.length || qos.length != topicFilters.length) {
            throw new IllegalArgumentException();
        }
        IMqttToken token = this.subscribe(topicFilters, qos, userContext, callback);
        int i = 0;
        while (i < topicFilters.length) {
            this.comms.setMessageListener(topicFilters[i], messageListeners[i]);
            ++i;
        }
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        if (log.isLoggable(5)) {
            String subs = "";
            int i = 0;
            while (i < topicFilters.length) {
                if (i > 0) {
                    subs = String.valueOf(subs) + ", ";
                }
                subs = String.valueOf(subs) + topicFilters[i];
                ++i;
            }
            log.fine(CLASS_NAME, "unsubscribe", "107", new Object[]{subs, userContext, callback});
        }
        int i = 0;
        while (i < topicFilters.length) {
            MqttTopic.validate(topicFilters[i], true);
            ++i;
        }
        i = 0;
        while (i < topicFilters.length) {
            this.comms.removeMessageListener(topicFilters[i]);
            ++i;
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        log.fine(CLASS_NAME, "unsubscribe", "110");
        return token;
    }

    @Override
    public boolean removeMessage(IMqttDeliveryToken token) throws MqttException {
        return this.comms.removeMessage(token);
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.mqttCallback = callback;
        this.comms.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.comms.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.comms.messageArrivedComplete(messageId, qos);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        log.fine(CLASS_NAME, "publish", "111", new Object[]{topic, userContext, callback});
        MqttTopic.validate(topic, false);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        log.fine(CLASS_NAME, "publish", "112");
        return token;
    }

    public void reconnect() throws MqttException {
        log.fine(CLASS_NAME, "reconnect", "500", new Object[]{this.clientId});
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.stopReconnectCycle();
        this.attemptReconnect();
    }

    private void attemptReconnect() {
        log.fine(CLASS_NAME, "attemptReconnect", "500", new Object[]{this.clientId});
        try {
            this.connect(this.connOpts, this.userContext, new MqttReconnectActionListener("attemptReconnect"));
        }
        catch (MqttSecurityException ex) {
            log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
        catch (MqttException ex) {
            log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
    }

    private void startReconnectCycle() {
        String methodName = "startReconnectCycle";
        log.fine(CLASS_NAME, methodName, "503", new Object[]{this.clientId, (long)reconnectDelay});
        this.reconnectTimer = new Timer("MQTT Reconnect: " + this.clientId);
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReconnectCycle() {
        String methodName = "stopReconnectCycle";
        log.fine(CLASS_NAME, methodName, "504", new Object[]{this.clientId});
        Object object = clientLock;
        synchronized (object) {
            if (this.connOpts.isAutomaticReconnect()) {
                if (this.reconnectTimer != null) {
                    this.reconnectTimer.cancel();
                    this.reconnectTimer = null;
                }
                reconnectDelay = 1000;
            }
        }
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(bufferOpts));
    }

    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.comms.getBufferedMessage(bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.comms.deleteBufferedMessage(bufferIndex);
    }

    public int getInFlightMessageCount() {
        return this.comms.getActualInFlight();
    }

    @Override
    public void close() throws MqttException {
        this.close(false);
    }

    public void close(boolean force) throws MqttException {
        log.fine(CLASS_NAME, "close", "113");
        this.comms.close(force);
        log.fine(CLASS_NAME, "close", "114");
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    class MqttReconnectActionListener
    implements IMqttActionListener {
        final String methodName;

        MqttReconnectActionListener(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public void onSuccess(IMqttToken asyncActionToken) {
            log.fine(CLASS_NAME, this.methodName, "501", new Object[]{asyncActionToken.getClient().getClientId()});
            MqttAsyncClient.this.comms.setRestingState(false);
            MqttAsyncClient.this.stopReconnectCycle();
        }

        @Override
        public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
            log.fine(CLASS_NAME, this.methodName, "502", new Object[]{asyncActionToken.getClient().getClientId()});
            if (reconnectDelay < 128000) {
                reconnectDelay = reconnectDelay * 2;
            }
            this.rescheduleReconnectCycle(reconnectDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rescheduleReconnectCycle(int delay) {
            String reschedulemethodName = String.valueOf(this.methodName) + ":rescheduleReconnectCycle";
            log.fine(CLASS_NAME, reschedulemethodName, "505", new Object[]{MqttAsyncClient.this.clientId, String.valueOf(reconnectDelay)});
            Object object = clientLock;
            synchronized (object) {
                if (MqttAsyncClient.this.connOpts.isAutomaticReconnect()) {
                    if (MqttAsyncClient.this.reconnectTimer != null) {
                        MqttAsyncClient.this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), delay);
                    } else {
                        reconnectDelay = delay;
                        MqttAsyncClient.this.startReconnectCycle();
                    }
                }
            }
        }
    }

    class MqttReconnectCallback
    implements MqttCallbackExtended {
        final boolean automaticReconnect;

        MqttReconnectCallback(boolean isAutomaticReconnect) {
            this.automaticReconnect = isAutomaticReconnect;
        }

        @Override
        public void connectionLost(Throwable cause) {
            if (this.automaticReconnect) {
                MqttAsyncClient.this.comms.setRestingState(true);
                MqttAsyncClient.this.reconnecting = true;
                MqttAsyncClient.this.startReconnectCycle();
            }
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        @Override
        public void connectComplete(boolean reconnect, String serverURI) {
        }
    }

    private class ReconnectTask
    extends TimerTask {
        private static final String methodName = "ReconnectTask.run";

        private ReconnectTask() {
        }

        @Override
        public void run() {
            log.fine(CLASS_NAME, methodName, "506");
            MqttAsyncClient.this.attemptReconnect();
        }
    }
}

