/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.emf.edit;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.passage.lic.emf.ecore.DomainContentAdapter;
import org.eclipse.passage.lic.emf.ecore.EditingDomainRegistry;
import org.eclipse.passage.lic.emf.edit.ComposedAdapterFactoryProvider;
import org.eclipse.passage.lic.equinox.io.EquinoxPaths;
import org.osgi.service.event.EventAdmin;

public abstract class BaseDomainRegistry<I>
implements EditingDomainRegistry<I>,
IEditingDomainProvider {
    protected EventAdmin eventAdmin;
    private String domainName;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryEditingDomain editingDomain;
    private final List<String> sources = new ArrayList<String>();
    private EContentAdapter contentAdapter;

    public BaseDomainRegistry() {
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.composedAdapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void bindEventAdmin(EventAdmin admin) {
        this.eventAdmin = admin;
    }

    protected void unbindEventAdmin(EventAdmin admin) {
        this.eventAdmin = null;
    }

    protected void bindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        this.composedAdapterFactory = factoryProvider.getComposedAdapterFactory();
        this.editingDomain.setAdapterFactory((AdapterFactory)this.composedAdapterFactory);
    }

    protected void unbindFactoryProvider(ComposedAdapterFactoryProvider factoryProvider) {
        this.composedAdapterFactory = null;
        this.editingDomain.setAdapterFactory((AdapterFactory)this.composedAdapterFactory);
    }

    protected void activate(Map<String, Object> properties) {
        this.domainName = String.valueOf(properties.get("org.eclipse.passage.lic.emf.edit.domain.name"));
        this.contentAdapter = this.createContentAdapter();
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.contentAdapter);
        this.loadResourceSet();
    }

    protected void loadResourceSet() {
        try {
            Path domainPath = this.getResourceSetPath();
            if (!Files.exists(domainPath, new LinkOption[0])) {
                return;
            }
            List<String> lines = Files.readAllLines(domainPath);
            for (String line : lines) {
                this.registerSource(line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = EquinoxPaths.resolveInstallBasePath();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        Path domainPath = passagePath.resolve(this.domainName);
        return domainPath;
    }

    protected abstract DomainContentAdapter<I, ? extends EditingDomainRegistry<I>> createContentAdapter();

    protected void deactivate(Map<String, Object> properties) {
        this.saveResourceSet();
        this.editingDomain.getResourceSet().eAdapters().remove((Object)this.contentAdapter);
    }

    protected void saveResourceSet() {
        try {
            Path domainPath = this.getResourceSetPath();
            if (!Files.exists(domainPath, new LinkOption[0])) {
                Files.createFile(domainPath, new FileAttribute[0]);
            }
            Files.write(domainPath, this.sources, new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ComposedAdapterFactory getComposedAdapterFactory() {
        return this.composedAdapterFactory;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected Map<?, ?> getLoadOptions() {
        return new HashMap();
    }

    protected Map<?, ?> getSaveOptions() {
        return new HashMap();
    }

    public void loadSource(String source) throws Exception {
        URI uri = this.createURI(source);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Resource resource = resourceSet.createResource(uri);
        resource.load(this.getLoadOptions());
    }

    public void unloadSource(String source) throws Exception {
        URI uri = this.createURI(source);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        Resource resource = resourceSet.getResource(uri, false);
        resource.unload();
        resourceSet.getResources().remove((Object)resource);
    }

    protected URI createURI(String source) {
        return URI.createFileURI((String)source);
    }

    @Override
    public void registerSource(String source) {
        this.sources.add(source);
        try {
            this.loadSource(source);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINER, e.getMessage(), e);
        }
    }

    @Override
    public void unregisterSource(String source) {
        this.sources.remove(source);
        try {
            this.unloadSource(source);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINER, e.getMessage(), e);
        }
    }

    @Override
    public Iterable<String> getSources() {
        return Collections.unmodifiableList(this.sources);
    }
}

