/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.jetty;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.passage.lbc.api.BackendRequestDispatcher;

class JettyRequestHandler
extends AbstractHandler {
    private final List<BackendRequestDispatcher> requestDispatchers = new ArrayList<BackendRequestDispatcher>();

    JettyRequestHandler(Iterable<BackendRequestDispatcher> dispatchers) {
        dispatchers.forEach(this.requestDispatchers::add);
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (BackendRequestDispatcher requestExecutor : this.requestDispatchers) {
            if (!requestExecutor.canDispatchRequest((HttpServletRequest)baseRequest)) continue;
            requestExecutor.dispatchRequest(request, response);
            baseRequest.setHandled(true);
        }
    }
}

