/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.util.function.Supplier;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicenseGrant;
import org.eclipse.passage.lic.licenses.model.meta.LicensesFactory;
import org.eclipse.passage.loc.internal.api.PersonalLicenseRequest;

final class LicenseGrantFromRequest
implements Supplier<LicenseGrant> {
    private final LicensePlanFeatureDescriptor feature;
    private final PersonalLicenseRequest request;

    public LicenseGrantFromRequest(LicensePlanFeatureDescriptor feature, PersonalLicenseRequest request) {
        this.feature = feature;
        this.request = request;
    }

    @Override
    public LicenseGrant get() {
        LicensesFactory licenseFactory = LicensesFactory.eINSTANCE;
        LicenseGrant grant = licenseFactory.createLicenseGrant();
        grant.setFeatureIdentifier(this.feature.getFeatureIdentifier());
        grant.setMatchVersion(this.feature.getMatchVersion());
        grant.setMatchRule(this.feature.getMatchRule());
        grant.setCapacity(1);
        grant.setConditionExpression(this.request.conditionExpression());
        grant.setConditionType(this.request.conditionType());
        grant.setValidFrom(this.request.validFrom());
        grant.setValidUntil(this.request.validUntil());
        return grant;
    }
}

