/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReport;
import org.eclipse.passage.loc.report.internal.core.license.LicensePlanReportParameters;
import org.eclipse.passage.loc.report.internal.core.license.LicenseStorage;
import org.eclipse.passage.loc.yars.internal.api.FetchedData;

final class LicensePlanReportFetch
implements FetchedData<LicenseStorage, LicensePlanReport> {
    private final LicenseStorage storage;
    private final LicensePlanReportParameters parameters;

    LicensePlanReportFetch(LicenseStorage storage, LicensePlanReportParameters parameters) {
        this.storage = storage;
        this.parameters = parameters;
    }

    public List<LicensePlanReport> get() {
        return this.parameters.plans().stream().map(this::entry).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<LicensePlanReport> entry(String id) {
        Optional<LicensePlanDescriptor> plan = this.storage.plan(id);
        if (!plan.isPresent()) {
            return Optional.empty();
        }
        List licenses = this.storage.licenses(id).stream().filter(lic -> lic.getIssueDate().after(this.parameters.from())).filter(lic -> lic.getIssueDate().before(this.parameters.to())).collect(Collectors.toList());
        return Optional.of(new LicensePlanReport(plan.get(), licenses.size(), licenses.stream().collect(Collectors.groupingBy(UserLicenseDescriptor::getUser)), this.parameters.explain()));
    }
}

