/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.passage.lic.api.conditions.MatchingRule;
import org.eclipse.passage.lic.api.version.SemanticVersion;
import org.eclipse.passage.lic.base.conditions.MatchingRuleCompatible;
import org.eclipse.passage.lic.base.conditions.MatchingRuleDefault;
import org.eclipse.passage.lic.base.conditions.MatchingRuleEquivalent;
import org.eclipse.passage.lic.base.conditions.MatchingRuleGreaterOrEqual;
import org.eclipse.passage.lic.base.conditions.MatchingRulePerfect;
import org.eclipse.passage.lic.base.version.BaseSemanticVersion;
import org.eclipse.passage.lic.base.version.SafeVersion;
import org.eclipse.passage.lic.licenses.LicensePlanFeatureDescriptor;
import org.eclipse.passage.lic.licenses.PersonalFeatureGrantDescriptor;
import org.eclipse.passage.lic.licenses.model.api.VersionMatch;
import org.eclipse.passage.loc.workbench.emfforms.renderers.ExplainedComboControlRenderer;
import org.eclipse.passage.loc.workbench.emfforms.renderers.MatchingRuleExplained;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;

public final class MatchRuleRenderer
extends ExplainedComboControlRenderer {
    private final List<MatchingRule> values;
    private final List<String> names;
    private final MatchingRule unset = new MatchingRuleDefault();

    @Inject
    public MatchRuleRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
        this.values = Arrays.asList(new MatchingRuleCompatible(), new MatchingRuleEquivalent(), new MatchingRuleGreaterOrEqual(), new MatchingRulePerfect());
        this.names = this.values.stream().map(MatchingRule::identifier).collect(Collectors.toList());
    }

    @Override
    protected List<String> getDefinedValues() {
        return this.names;
    }

    protected String getUnsetText() {
        return this.unset.identifier();
    }

    @Override
    protected void describeUnset() {
        this.describe(this.values.indexOf(this.unset));
    }

    @Override
    protected void describe(int index) {
        if (index < 0 || index >= this.values.size()) {
            return;
        }
        this.describe(this.values.get(index), this.guideVersion());
    }

    private void describe(MatchingRule rule, SemanticVersion guide) {
        MatchingRuleExplained explained = new MatchingRuleExplained(rule, guide);
        Object text = "";
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        for (MatchingRuleExplained.Sample sample : explained.samples()) {
            if (!((String)text).isEmpty()) {
                text = (String)text + "  ";
            }
            String piece = this.mark(sample.ok()) + sample.text();
            styles.add(this.sampleSyle(((String)text).length(), piece, sample.ok()));
            text = (String)text + piece;
        }
        this.description.setText((String)text);
        styles.forEach(arg_0 -> ((StyledText)this.description).setStyleRange(arg_0));
    }

    private String mark(boolean ok) {
        return ok ? "\u2713 " : "\u2717 ";
    }

    private StyleRange sampleSyle(int from, String sample, boolean ok) {
        StyleRange style = new StyleRange();
        style.start = from;
        style.length = sample.length();
        style.foreground = this.combo.getDisplay().getSystemColor(ok ? 6 : 4);
        return style;
    }

    private SemanticVersion guideVersion() {
        return this.guide().map(v -> new SafeVersion(v).semantic()).orElse((SemanticVersion)new BaseSemanticVersion(1, 2, 3));
    }

    private Optional<String> guide() {
        EObject owner = this.getViewModelContext().getDomainModel();
        if (owner instanceof LicensePlanFeatureDescriptor) {
            return Optional.ofNullable(((LicensePlanFeatureDescriptor)owner).getFeature().getVersionMatch().getVersion());
        }
        if (owner instanceof PersonalFeatureGrantDescriptor) {
            return Optional.ofNullable(((PersonalFeatureGrantDescriptor)owner).getFeature().getVersionMatch().getVersion());
        }
        if (owner instanceof VersionMatch) {
            return Optional.ofNullable(((VersionMatch)owner).getVersion());
        }
        return Optional.empty();
    }
}

