/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ManageTextValuesDialog
extends Dialog {
    private final String splitter;
    private final String initialValues;
    private Text editor;
    private String resultValues;

    public ManageTextValuesDialog(Shell parentShell, String values, String splitter) {
        super(parentShell);
        this.splitter = splitter;
        this.initialValues = values;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(400, 500);
    }

    public String getResultValue() {
        return this.resultValues;
    }

    private String prepareResultValues() {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = this.editor.getText().split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String filtred = item.trim();
            if (!filtred.isEmpty()) {
                if (builder.length() > 0) {
                    builder.append(this.splitter);
                }
                builder.append(filtred);
            }
            ++n2;
        }
        return builder.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.resultValues = this.prepareResultValues();
        }
        super.buttonPressed(buttonId);
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite base = new Composite(parent, 2048);
        base.setLayout((Layout)new GridLayout(1, false));
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor = new Text(base, 2);
        this.editor.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.initialValues != null) {
            String replaced = this.initialValues.replace(this.splitter, "\n");
            this.editor.setText(replaced);
        }
        return parent;
    }

    protected boolean isResizable() {
        return true;
    }
}

