/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.hc.remote.impl;

import java.util.Collections;
import org.eclipse.passage.lic.api.conditions.mining.ContentType;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.hc.remote.Connection;

public final class ResultsTransfered {
    private final byte[] data;
    private final int code;
    private final String message;
    private final ContentType contentType;
    private final boolean successful;

    public ResultsTransfered(Connection connection) throws Exception {
        this.code = connection.code();
        this.message = connection.message();
        this.contentType = connection.contentType();
        this.data = connection.payload();
        this.successful = connection.successful();
    }

    public ContentType contentType() {
        return this.contentType;
    }

    public byte[] data() {
        return this.data;
    }

    public boolean successful() {
        return this.successful;
    }

    public Diagnostic diagnose() {
        if (this.successful()) {
            return new BaseDiagnostic();
        }
        return new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), String.format("%d: %s", this.code, this.message))));
    }
}

