/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.FileCollection;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class Settings {
    private final Supplier<Path> base;
    private final Predicate<Map<String, Object>> enough;

    public Settings(Supplier<Path> base, Predicate<Map<String, Object>> enough) {
        this.base = base;
        this.enough = enough;
    }

    public Settings(Supplier<Path> base) {
        this(base, map -> false);
    }

    public Map<String, Object> get() throws LicensingException {
        try {
            return this.properties(this.settingFiles());
        }
        catch (IOException e) {
            throw new LicensingException(String.format(BaseMessages.getString("Settings.error_on_reading_settings"), this.base.get()), (Throwable)e);
        }
    }

    private Collection<Path> settingFiles() throws LicensingException {
        return new FileCollection(this.base, new PassageFileExtension.Settings()).get();
    }

    private Map<String, Object> properties(Collection<Path> files) throws IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Path file : files) {
            this.loadAndAdd(properties, file);
            if (!this.enough.test(properties)) continue;
            return properties;
        }
        return properties;
    }

    private void loadAndAdd(Map<String, Object> properties, Path file) throws IOException {
        Properties heap = new Properties();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = Files.newInputStream(file, new OpenOption[0]);){
            heap.load(stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        heap.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            Object object = properties.put(k.toString(), v);
        }));
    }
}

