/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.inspector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.inspector.FeatureCase;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.internal.equinox.inspector.EquinoxFeatureInspector;

public class EquinoxFeatureCase
implements FeatureCase {
    private final EquinoxFeatureInspector inspector;
    private final List<LicensingRequirement> requirements;
    private final List<RestrictionVerdict> verdicts;
    private final Set<Class<?>> query;
    private final Map<String, Integer> failures;
    private final Iterable<String> featureIdentifiers;

    EquinoxFeatureCase(EquinoxFeatureInspector inspector, Iterable<String> features) {
        this.inspector = inspector;
        this.featureIdentifiers = features;
        this.requirements = new ArrayList<LicensingRequirement>();
        this.verdicts = new ArrayList<RestrictionVerdict>();
        this.failures = new HashMap<String, Integer>();
        this.query = new HashSet();
        this.query.add(LicensingRequirement.class);
        this.query.add(RestrictionVerdict.class);
    }

    public Iterable<String> getFeatureIdentifiers() {
        return this.featureIdentifiers;
    }

    public Iterable<LicensingRequirement> getRequirements() {
        if (this.query.contains(LicensingRequirement.class)) {
            this.inspector.getRequirements(this.featureIdentifiers).forEach(this.requirements::add);
            this.query.remove(LicensingRequirement.class);
        }
        return this.requirements;
    }

    public Iterable<RestrictionVerdict> getRestrictions() {
        if (this.query.contains(RestrictionVerdict.class)) {
            this.inspector.getRestrictions(this.featureIdentifiers).forEach(this.verdicts::add);
            this.query.remove(RestrictionVerdict.class);
        }
        return this.verdicts;
    }

    public void close() {
        this.inspector.close(this);
    }

    public void reset() {
        this.requirements.clear();
        this.verdicts.clear();
        this.failures.clear();
        this.query.clear();
        this.query.add(LicensingRequirement.class);
        this.query.add(RestrictionVerdict.class);
    }

    void conditionNotValid(LicensingCondition condition, int code) {
        this.failures.put(condition.getFeatureIdentifier(), code);
    }

    public List<RestrictionVerdict> status() {
        Map<LicensingRequirement, RestrictionVerdict> base = StreamSupport.stream(this.getRestrictions().spliterator(), false).collect(Collectors.toMap(v -> v.getLicensingRequirement(), v -> v));
        return StreamSupport.stream(this.getRequirements().spliterator(), false).map(r -> this.wrap(base, (LicensingRequirement)r)).collect(Collectors.toList());
    }

    private RestrictionVerdict wrap(Map<LicensingRequirement, RestrictionVerdict> base, LicensingRequirement requirement) {
        RestrictionVerdict verdict = base.get(requirement);
        if (verdict == null) {
            return new NoRestriction(requirement, this.inspector.getLicensingConfiguration());
        }
        Integer code = this.failures.get(requirement.getFeatureIdentifier());
        if (code == null) {
            return verdict;
        }
        return new WrappedVerdict(verdict, code);
    }

    private final class NoRestriction
    implements RestrictionVerdict {
        private final LicensingRequirement requirement;
        private final LicensingConfiguration configuration;

        private NoRestriction(LicensingRequirement requirement, LicensingConfiguration configuration) {
            this.requirement = requirement;
            this.configuration = configuration;
        }

        public String getRestrictionLevel() {
            return "";
        }

        public int getRestrictionCode() {
            return 0;
        }

        public LicensingRequirement getLicensingRequirement() {
            return this.requirement;
        }

        public LicensingConfiguration getLicensingConfiguration() {
            return this.configuration;
        }
    }

    private final class WrappedVerdict
    implements RestrictionVerdict {
        private final RestrictionVerdict verdict;
        private final Integer code;

        private WrappedVerdict(RestrictionVerdict verdict, Integer code) {
            this.verdict = verdict;
            this.code = code;
        }

        public String getRestrictionLevel() {
            return this.verdict.getRestrictionLevel();
        }

        public int getRestrictionCode() {
            return this.code;
        }

        public LicensingRequirement getLicensingRequirement() {
            return this.verdict.getLicensingRequirement();
        }

        public LicensingConfiguration getLicensingConfiguration() {
            return this.verdict.getLicensingConfiguration();
        }
    }
}

