/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.BinaryOperator;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.base.BaseNamedData;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.SumOfCollections;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceCannotOperate;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.internal.equinox.requirements.RequirementsFromBundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class BundleRequirements
implements ResolvedRequirements {
    private final Optional<BundleContext> context = Optional.of(FrameworkUtil.getBundle(this.getClass()).getBundleContext());

    public StringServiceId id() {
        return new StringServiceId("manifest");
    }

    public ServiceInvocationResult<Collection<Requirement>> all() {
        if (this.sabotage()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceCannotOperate(), EquinoxMessages.BundleRequirements_no_context));
        }
        return this.resolve();
    }

    private boolean sabotage() {
        return !this.context.isPresent();
    }

    private ServiceInvocationResult<Collection<Requirement>> resolve() {
        return Arrays.stream(this.context.get().getBundles()).map(RequirementsFromBundle::new).map(BaseNamedData::get).filter(Optional::isPresent).map(Optional::get).reduce((BinaryOperator<ServiceInvocationResult>)new BaseServiceInvocationResult.Sum((BinaryOperator)new SumOfCollections())).orElse((ServiceInvocationResult)new BaseServiceInvocationResult(Collections.emptyList()));
    }
}

